/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.module.ExtensionsManager;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.launch.CustomVmOptions;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.Launcher;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.launch.TilingHandler;
import VASSAL.preferences.Prefs;
import VASSAL.preferences.ReadOnlyPrefs;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.concurrent.FutureUtils;
import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ModuleFileFilter;
import VASSAL.tools.io.ProcessLauncher;
import VASSAL.tools.io.ProcessWrapper;
import VASSAL.tools.ipc.IPCMessage;
import VASSAL.tools.ipc.IPCMessenger;
import VASSAL.tools.ipc.SimpleIPCMessage;
import VASSAL.tools.lang.MemoryUtils;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLaunchAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(AbstractLaunchAction.class);
    protected static final int PHYS_MEMORY;
    protected static final int DEFAULT_INITIAL_HEAP = 256;
    protected static final int DEFAULT_MAXIMUM_HEAP = 512;
    protected static final int FAILSAFE_INITIAL_HEAP = 64;
    protected static final int FAILSAFE_MAXIMUM_HEAP = 128;
    protected final Window window;
    protected final String entryPoint;
    protected final LaunchRequest lr;
    protected static final Set<File> editing;
    protected static final Map<File, Integer> using;
    protected static final List<IPCMessenger> children;
    protected static final AtomicInteger nextId;

    public AbstractLaunchAction(String name, Window window, String entryPoint, LaunchRequest lr) {
        super(name);
        this.window = window;
        this.entryPoint = entryPoint;
        this.lr = lr;
    }

    public static boolean isInUse(File file) {
        return using.containsKey(file);
    }

    public static boolean isEditing(File file) {
        return editing.contains(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean shutDown() {
        ModuleManagerWindow.getInstance().toBack();
        ArrayList<Future<IPCMessage>> futures = new ArrayList<Future<IPCMessage>>();
        List<IPCMessenger> list = children;
        synchronized (list) {
            for (IPCMessenger ipc : children) {
                try {
                    futures.add(ipc.send(new Launcher.CloseRequest()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (Future future : futures) {
            try {
                if (!(future.get() instanceof Launcher.CloseReject)) continue;
                System.out.println("rejected!");
                return false;
            }
            catch (InterruptedException | ExecutionException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ModuleManagerWindow.getInstance().setWaitCursor(true);
        this.getLaunchTask().execute();
    }

    protected abstract LaunchTask getLaunchTask();

    protected File promptForFile() {
        FileChooser fc = FileChooser.createFileChooser(this.window, (DirectoryConfigurer)Prefs.getGlobalPrefs().getOption("modulesDir"));
        this.addFileFilters(fc);
        if (fc.showOpenDialog() == 0) {
            this.lr.module = fc.getSelectedFile();
            if (this.lr.module != null) {
                if (this.lr.module.exists()) {
                    AbstractMetaData metadata = MetaDataFactory.buildMetaData(this.lr.module);
                    if (metadata == null || !(metadata instanceof ModuleMetaData)) {
                        ErrorDialog.show("Error.invalid_vassal_module", this.lr.module.getAbsolutePath());
                        logger.error("-- Load of {} failed: Not a Vassal module", (Object)this.lr.module.getAbsolutePath());
                        this.lr.module = null;
                    }
                } else {
                    this.lr.module = null;
                }
            }
        }
        return this.lr.module;
    }

    protected void addFileFilters(FileChooser fc) {
        fc.addChoosableFileFilter(new ModuleFileFilter());
    }

    static {
        long physMemoryBytes = MemoryUtils.getPhysicalMemory();
        PHYS_MEMORY = physMemoryBytes < 0L ? 4096 : (int)(physMemoryBytes >> 20);
        editing = Collections.synchronizedSet(new HashSet());
        using = Collections.synchronizedMap(new HashMap());
        children = Collections.synchronizedList(new ArrayList());
        nextId = new AtomicInteger(1);
    }

    protected class LaunchTask
    extends SwingWorker<Void, Void> {
        protected final int id = nextId.getAndIncrement();
        protected final LaunchRequest lr;
        protected ServerSocket serverSocket;
        protected Socket clientSocket;
        protected IPCMessenger ipc;

        protected LaunchTask() {
            this.lr = new LaunchRequest(AbstractLaunchAction.this.lr);
            this.serverSocket = null;
            this.clientSocket = null;
            this.ipc = null;
        }

        @Override
        public Void doInBackground() throws InterruptedException, IOException {
            if (this.lr.module != null) {
                logger.info("Loading module file {}", (Object)this.lr.module.getAbsolutePath());
                String aname = this.lr.module.getAbsolutePath();
                ModuleMetaData meta = new ModuleMetaData(new ZipFile(aname));
                String hstr = DigestUtils.sha1Hex((String)(meta.getName() + "_" + meta.getVersion()));
                File cdir = new File(Info.getConfDir(), "tiles/" + hstr);
                TilingHandler th = new TilingHandler(aname, cdir, new Dimension(256, 256), PHYS_MEMORY, nextId.getAndIncrement());
                try {
                    th.sliceTiles();
                }
                catch (CancellationException e) {
                    this.cancel(true);
                    return null;
                }
                ExtensionsManager mgr = new ExtensionsManager(this.lr.module);
                for (File ext : mgr.getActiveExtensions()) {
                    TilingHandler eth = new TilingHandler(ext.getAbsolutePath(), cdir, new Dimension(256, 256), PHYS_MEMORY, nextId.getAndIncrement());
                    try {
                        eth.sliceTiles();
                    }
                    catch (CancellationException e) {
                        this.cancel(true);
                        return null;
                    }
                }
            }
            if (this.lr.game != null) {
                logger.info("Loading game file {}", (Object)this.lr.game.getAbsolutePath());
            }
            if (this.lr.importFile != null) {
                logger.info("Importing module file {}", (Object)this.lr.importFile.getAbsolutePath());
            }
            int initialHeap = 256;
            int maximumHeap = 512;
            String moduleName = null;
            if (this.lr.module != null) {
                AbstractMetaData data = MetaDataFactory.buildMetaData(this.lr.module);
                if (data == null) {
                    ErrorDialog.show("Error.invalid_vassal_file", this.lr.module.getAbsolutePath());
                    ModuleManagerWindow.getInstance().setWaitCursor(false);
                    return null;
                }
                if (data instanceof ModuleMetaData) {
                    moduleName = ((ModuleMetaData)data).getName();
                    logger.info("Loading module {}", (Object)moduleName);
                    ReadOnlyPrefs p = new ReadOnlyPrefs(moduleName);
                    initialHeap = this.getHeapSize(p, "initialHeap", 256);
                    maximumHeap = this.getHeapSize(p, "maximumHeap", 512);
                }
            } else if (this.lr.importFile != null) {
                Prefs p = Prefs.getGlobalPrefs();
                initialHeap = this.getHeapSize(p, "initialHeap", 256);
                maximumHeap = this.getHeapSize(p, "maximumHeap", 512);
            }
            if (maximumHeap > PHYS_MEMORY) {
                initialHeap = 64;
                maximumHeap = 128;
                FutureUtils.wait(WarningDialog.show("Warning.maximum_heap_too_large", 128));
            } else if (maximumHeap < 128) {
                initialHeap = 64;
                maximumHeap = 128;
                FutureUtils.wait(WarningDialog.show("Warning.maximum_heap_too_small", 128));
            } else if (initialHeap < 64) {
                initialHeap = 64;
                maximumHeap = 128;
                FutureUtils.wait(WarningDialog.show("Warning.initial_heap_too_small", 64));
            } else if (initialHeap > maximumHeap) {
                initialHeap = 64;
                maximumHeap = 128;
                FutureUtils.wait(WarningDialog.show("Warning.initial_heap_too_large", 64));
            }
            InetAddress lo = InetAddress.getByName(null);
            this.serverSocket = new ServerSocket(0, 0, lo);
            List<String> argumentList = this.buildArgumentList(moduleName);
            String[] args = argumentList.toArray(new String[0]);
            args[1] = "-Xms" + initialHeap + "M";
            args[2] = "-Xmx" + maximumHeap + "M";
            ProcessWrapper proc = new ProcessLauncher().launch(args);
            try {
                proc.future.get(1000L, TimeUnit.MILLISECONDS);
            }
            catch (CancellationException e) {
                this.cancel(true);
                return null;
            }
            catch (ExecutionException e) {
                logger.error("", (Throwable)e);
            }
            catch (TimeoutException e) {
                // empty catch block
            }
            if (proc.future.isDone()) {
                args[1] = "-Xms64M";
                args[2] = "-Xmx128M";
                proc = new ProcessLauncher().launch(args);
                try {
                    proc.future.get(1000L, TimeUnit.MILLISECONDS);
                }
                catch (ExecutionException e) {
                    logger.error("", (Throwable)e);
                }
                catch (TimeoutException e) {
                    // empty catch block
                }
                if (proc.future.isDone()) {
                    throw new IOException("failed to start child process");
                }
                FutureUtils.wait(WarningDialog.show("Warning.maximum_heap_too_large", 128));
            }
            this.clientSocket = this.serverSocket.accept();
            this.ipc = new IPCMessenger(this.clientSocket);
            this.ipc.addEventListener(NotifyOpenModuleOk.class, new NotifyOpenModuleOkListener());
            this.ipc.addEventListener(NotifyNewModuleOk.class, new NotifyNewModuleOkListener());
            this.ipc.addEventListener(NotifyImportModuleOk.class, new NotifyImportModuleOkListener());
            this.ipc.addEventListener(NotifyOpenModuleFailed.class, new NotifyOpenModuleFailedListener());
            this.ipc.addEventListener(NotifySaveFileOk.class, new NotifySaveFileOkListener());
            this.ipc.start();
            children.add(this.ipc);
            try {
                proc.future.get();
            }
            catch (ExecutionException e) {
                logger.error("", (Throwable)e);
            }
            return null;
        }

        protected int getHeapSize(ReadOnlyPrefs p, String key, int defaultHeap) {
            String val = p.getStoredValue(key);
            if (val == null) {
                return defaultHeap;
            }
            try {
                return Integer.parseInt(val);
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }

        protected int getHeapSize(Prefs p, String key, int defaultHeap) {
            Object val = p.getValue(key);
            if (val == null) {
                return defaultHeap;
            }
            try {
                return Integer.parseInt(val.toString());
            }
            catch (NumberFormatException ex) {
                return -1;
            }
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (CancellationException e) {
                ModuleManagerWindow.getInstance().setWaitCursor(false);
            }
            catch (InterruptedException e) {
                ErrorDialog.bug(e);
            }
            catch (ExecutionException e) {
                Throwable c = e.getCause();
                if (c instanceof IOException) {
                    ErrorDialog.showDetails(e, ThrowableUtils.getStackTrace(e), "Error.socket_error", new Object[0]);
                } else {
                    ErrorDialog.bug(e);
                }
            }
            finally {
                if (this.clientSocket != null) {
                    try {
                        this.clientSocket.close();
                    }
                    catch (IOException e) {
                        logger.error("Error while closing clientSocket", (Throwable)e);
                    }
                }
                if (this.serverSocket != null) {
                    try {
                        this.serverSocket.close();
                    }
                    catch (IOException e) {
                        logger.error("Error while closing serverSocket", (Throwable)e);
                    }
                }
                children.remove(this.ipc);
            }
        }

        private List<String> buildArgumentList(String moduleName) {
            Boolean disableD3d;
            String vHome;
            String userDir;
            ArrayList<String> result = new ArrayList<String>();
            int port = this.serverSocket.getLocalPort();
            result.add(Info.javaBinPath);
            result.add("");
            result.add("");
            result.addAll(new CustomVmOptions().getCustomVmOptions());
            result.add("-DVASSAL.id=" + this.id);
            result.add("-DVASSAL.port=" + port);
            String userHome = System.getProperty("user.home");
            if (userHome != null) {
                result.add("-Duser.home=" + userHome);
            }
            if ((userDir = System.getProperty("user.dir")) != null) {
                result.add("-Duser.dir=" + userDir);
            }
            if ((vHome = System.getProperty("VASSAL.home")) != null) {
                result.add("-DVASSAL.home=" + vHome);
            }
            result.add("-cp");
            result.add(System.getProperty("java.class.path"));
            if (SystemUtils.IS_OS_MAC_OSX) {
                String d_name = moduleName != null && moduleName.length() > 0 ? moduleName : "Unnamed module";
                String d_icon = new File(Info.getBaseDir(), "Contents/Resources/VASSAL.icns").getAbsolutePath();
                result.add("-Xdock:name=" + d_name);
                result.add("-Xdock:icon=" + d_icon);
            } else if (SystemUtils.IS_OS_WINDOWS && Boolean.TRUE.equals(disableD3d = (Boolean)Prefs.getGlobalPrefs().getValue("disableD3d"))) {
                result.add("-Dsun.java2d.d3d=false");
            }
            result.add(AbstractLaunchAction.this.entryPoint);
            result.addAll(Arrays.asList(this.lr.toArgs()));
            return result;
        }
    }

    protected static class NotifySaveFileOkListener
    implements EventListener<NotifySaveFileOk> {
        protected NotifySaveFileOkListener() {
        }

        @Override
        public void receive(Object rc, final NotifySaveFileOk msg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModuleManagerWindow.getInstance().update(msg.file);
                }
            });
        }
    }

    protected static class NotifyOpenModuleFailedListener
    implements EventListener<NotifyOpenModuleFailed> {
        protected NotifyOpenModuleFailedListener() {
        }

        @Override
        public void receive(Object src, NotifyOpenModuleFailed msg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModuleManagerWindow.getInstance().setWaitCursor(false);
                }
            });
            ErrorDialog.showDetails(msg.thrown, ThrowableUtils.getStackTrace(msg.thrown), "Error.module_load_failed", msg.thrown.getMessage());
        }
    }

    protected static class NotifyImportModuleOkListener
    implements EventListener<NotifyImportModuleOk> {
        protected NotifyImportModuleOkListener() {
        }

        @Override
        public void receive(Object src, NotifyImportModuleOk msg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModuleManagerWindow.getInstance().setWaitCursor(false);
                }
            });
        }
    }

    protected static class NotifyNewModuleOkListener
    implements EventListener<NotifyNewModuleOk> {
        protected NotifyNewModuleOkListener() {
        }

        @Override
        public void receive(Object src, NotifyNewModuleOk msg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModuleManagerWindow.getInstance().setWaitCursor(false);
                }
            });
        }
    }

    protected static class NotifyOpenModuleOkListener
    implements EventListener<NotifyOpenModuleOk> {
        protected NotifyOpenModuleOkListener() {
        }

        @Override
        public void receive(Object src, final NotifyOpenModuleOk msg) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModuleManagerWindow mmw = ModuleManagerWindow.getInstance();
                    mmw.addModule(msg.lr.module);
                    mmw.setWaitCursor(false);
                }
            });
        }
    }

    public static class NotifySaveFileOk
    extends SimpleIPCMessage {
        private static final long serialVersionUID = 1L;
        public final File file;

        public NotifySaveFileOk(File file) {
            this.file = file;
        }
    }

    public static class NotifyOpenModuleFailed
    extends LaunchRequestMessage {
        private static final long serialVersionUID = 1L;
        public final Throwable thrown;

        public NotifyOpenModuleFailed(LaunchRequest lr, Throwable thrown) {
            super(lr);
            this.thrown = thrown;
        }
    }

    public static class NotifyImportModuleOk
    extends LaunchRequestMessage {
        private static final long serialVersionUID = 1L;

        public NotifyImportModuleOk(LaunchRequest lr) {
            super(lr);
        }
    }

    public static class NotifyNewModuleOk
    extends LaunchRequestMessage {
        private static final long serialVersionUID = 1L;

        public NotifyNewModuleOk(LaunchRequest lr) {
            super(lr);
        }
    }

    public static class NotifyOpenModuleOk
    extends LaunchRequestMessage {
        private static final long serialVersionUID = 1L;

        public NotifyOpenModuleOk(LaunchRequest lr) {
            super(lr);
        }
    }

    protected static abstract class LaunchRequestMessage
    extends SimpleIPCMessage {
        private static final long serialVersionUID = 1L;
        protected final LaunchRequest lr;

        public LaunchRequestMessage(LaunchRequest lr) {
            this.lr = lr;
        }
    }
}

