/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ReadErrorDialog;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang3.SystemUtils;

public class BrowserSupport {
    private static final HyperlinkListener listener = new HyperlinkListener(){

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                BrowserSupport.openURL(e.getURL().toString());
            }
        }
    };

    public static void openURL(String url) {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(url));
                return;
            }
            catch (IOException e) {
                if (!SystemUtils.IS_OS_WINDOWS) {
                    ReadErrorDialog.error(e, url);
                    return;
                }
            }
            catch (IllegalArgumentException | URISyntaxException e) {
                ErrorDialog.bug(e);
                return;
            }
        }
        ProcessBuilder pb = new ProcessBuilder("xdg-open", url);
        pb.redirectError(ProcessBuilder.Redirect.INHERIT);
        try {
            pb.start();
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, url);
        }
    }

    public static HyperlinkListener getListener() {
        return listener;
    }
}

