/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.menu;

import VASSAL.tools.menu.ChildProxy;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuItemProxy;
import VASSAL.tools.menu.MenuMarker;
import VASSAL.tools.menu.MenuProxy;
import VASSAL.tools.menu.ParentProxy;
import VASSAL.tools.menu.SeparatorProxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenuBar;

public abstract class MenuManager {
    protected static MenuManager instance;
    private Map<String, List<MenuItemProxy>> actionLocations = new HashMap<String, List<MenuItemProxy>>();
    private Map<String, MenuMarker> markers = new HashMap<String, MenuMarker>();

    public static MenuManager getInstance() {
        if (instance == null) {
            throw new IllegalStateException();
        }
        return instance;
    }

    public MenuManager() {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
    }

    public abstract JMenuBar getMenuBarFor(JFrame var1);

    public abstract MenuBarProxy getMenuBarProxyFor(JFrame var1);

    public MenuItemProxy addKey(String key) {
        List items = this.actionLocations.computeIfAbsent(key, k -> new ArrayList());
        MenuItemProxy item = new MenuItemProxy();
        items.add(item);
        return item;
    }

    public List<MenuItemProxy> getItems(String key) {
        return this.actionLocations.get(key);
    }

    public void addAction(String key, Action a) {
        List<MenuItemProxy> items = this.actionLocations.get(key);
        if (items != null) {
            for (MenuItemProxy i : items) {
                i.setAction(a);
            }
        }
    }

    public void removeAction(String key) {
        this.addAction(key, null);
    }

    public MenuMarker getMarker(String key) {
        return this.markers.get(key);
    }

    public MenuMarker addMarker(String key) {
        MenuMarker marker = new MenuMarker();
        this.markers.put(key, marker);
        return marker;
    }

    public void addToSection(String key, ChildProxy<?> item) {
        MenuMarker start = this.getMarker(key + ".start");
        MenuMarker end = this.getMarker(key + ".end");
        ParentProxy parent = end.getParent();
        int startPos = parent.getIndex(start);
        int endPos = parent.getIndex(end);
        if (parent instanceof MenuProxy && startPos + 1 == endPos) {
            if (this.nextVisibleItemNotASeparator(end)) {
                ((MenuProxy)parent).insertSeparator(endPos + 1);
            }
            if (this.prevVisibleItemNotASeparator(start)) {
                ((MenuProxy)parent).insertSeparator(startPos);
            }
        }
        parent.insert(item, endPos);
    }

    public void removeFromSection(String key, ChildProxy<?> item) {
        int endPos;
        int startPos;
        MenuMarker start = this.getMarker(key + ".start");
        MenuMarker end = this.getMarker(key + ".end");
        ParentProxy parent = end.getParent();
        parent.remove(item);
        if (parent instanceof MenuProxy && (startPos = parent.getIndex(start)) + 1 == (endPos = parent.getIndex(end))) {
            if (this.visibleItemBefore(start)) {
                parent.remove(startPos - 1);
            } else if (this.visibleItemAfter(end)) {
                parent.remove(endPos + 1);
            }
        }
    }

    private boolean visibleItemAfter(ChildProxy<?> child) {
        ParentProxy parent = child.getParent();
        int count = parent.getChildCount();
        for (int i = parent.getIndex(child) + 1; i < count; ++i) {
            ChildProxy<?> c = parent.getChild(i);
            if (c instanceof MenuMarker) continue;
            return true;
        }
        return false;
    }

    private boolean visibleItemBefore(ChildProxy<?> child) {
        ParentProxy parent = child.getParent();
        for (int i = parent.getIndex(child) - 1; i >= 0; ++i) {
            ChildProxy<?> c = parent.getChild(i);
            if (c instanceof MenuMarker) continue;
            return true;
        }
        return false;
    }

    private boolean nextVisibleItemNotASeparator(ChildProxy<?> child) {
        ParentProxy parent = child.getParent();
        int count = parent.getChildCount();
        for (int i = parent.getIndex(child) + 1; i < count; ++i) {
            ChildProxy<?> c = parent.getChild(i);
            if (c instanceof MenuMarker) continue;
            return !(c instanceof SeparatorProxy);
        }
        return false;
    }

    private boolean prevVisibleItemNotASeparator(ChildProxy<?> child) {
        ParentProxy parent = child.getParent();
        for (int i = parent.getIndex(child) - 1; i >= 0; --i) {
            ChildProxy<?> c = parent.getChild(i);
            if (c instanceof MenuMarker) continue;
            return !(c instanceof SeparatorProxy);
        }
        return false;
    }
}

