/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.wizard;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.imageio.ImageIO;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import org.netbeans.modules.wizard.NbBridge;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardObserver;

public class InstructionsPanel
extends JComponent
implements WizardObserver,
Accessible {
    private static final long serialVersionUID = 1L;
    private final BufferedImage img;
    private final Wizard wizard;
    private static final int MARGIN = 5;
    String[] steps = new String[0];
    private int historicWidth = Integer.MIN_VALUE;
    private Dimension minSize = new Dimension();
    private boolean inSummaryPage;

    public InstructionsPanel(Wizard wiz) {
        this(null, wiz);
        Font f = UIManager.getFont("Tree.font");
        if (f != null) {
            this.setFont(f);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.wizard.addWizardObserver((WizardObserver)this);
    }

    @Override
    public void removeNotify() {
        this.wizard.removeWizardObserver((WizardObserver)this);
        super.removeNotify();
    }

    BufferedImage getImage() {
        return this.img;
    }

    public InstructionsPanel(BufferedImage img, Wizard wizard) {
        if (img == null) {
            img = (BufferedImage)UIManager.get("wizard.sidebar.image");
        }
        String imgStr = System.getProperty("wizard.sidebar.image");
        if (img == null && imgStr != null) {
            ClassLoader cl = this.getClass().getClassLoader();
            URL url = cl.getResource(imgStr);
            if (url != null) {
                try {
                    img = ImageIO.read(url);
                }
                catch (IOException ioe) {
                    System.err.println("Could not load wizard image " + ioe.getMessage());
                    System.setProperty("wizard.sidebar.image", null);
                    img = null;
                }
            } else {
                System.err.println("Bad URL for wizard image " + imgStr);
                System.setProperty("wizard.sidebar.image", null);
                img = null;
            }
        }
        if (img == null) {
            try {
                img = ImageIO.read(InstructionsPanel.class.getResourceAsStream("defaultWizard.png"));
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
        this.img = img;
        this.wizard = wizard;
    }

    @Override
    public boolean isOpaque() {
        return this.img != null;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Font f = this.getFont() != null ? this.getFont() : UIManager.getFont("controlFont");
        FontMetrics fm = g.getFontMetrics(f);
        Insets ins = this.getInsets();
        if (this.img != null) {
            int dx = ins.left;
            int dy = ins.top;
            g2d.drawImage((Image)this.img, dx, dy, this);
        } else {
            g.setColor(Color.WHITE);
            g.fillRect(ins.left, ins.top, this.getWidth() - (ins.left + ins.right), this.getHeight() - (ins.top + ins.bottom));
        }
        String currentStep = this.wizard.getCurrentStep();
        if (!this.inSummaryPage) {
            this.steps = this.wizard.getAllSteps();
        }
        String[] steps = this.steps;
        if (this.inSummaryPage) {
            String summaryStep = NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "Summary");
            String[] nue = new String[steps.length + 1];
            System.arraycopy(steps, 0, nue, 0, steps.length);
            nue[nue.length - 1] = summaryStep;
            steps = nue;
        }
        int y = fm.getMaxAscent() + ins.top + 5;
        int x = ins.left + 5;
        int h = fm.getMaxAscent() + fm.getMaxDescent() + 3;
        Font boldFont = f.deriveFont(1);
        g.setFont(boldFont);
        g.drawString(NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "Steps"), x, y);
        int underlineY = ins.top + 5 + fm.getAscent() + 3;
        g.drawLine(x, underlineY, x + (this.getWidth() - (x + ins.left + 5)), underlineY);
        y += h + 10;
        g.setFont(this.getFont());
        g.setColor(this.getForeground());
        for (int i = 0; i < steps.length; ++i) {
            boolean selected;
            boolean canOnlyFinish;
            boolean isUndetermined = "_#UndeterminedStep".equals(steps[i]);
            boolean bl = canOnlyFinish = this.wizard.getForwardNavigationMode() == 2;
            if (isUndetermined && canOnlyFinish) break;
            String curr = this.inSummaryPage && i == this.steps.length ? i + 1 + ". " + steps[i] : i + 1 + ". " + (isUndetermined ? NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "elipsis") : this.wizard.getStepDescription(steps[i]));
            if (curr == null) continue;
            boolean bl2 = selected = steps[i].equals(currentStep) && !this.inSummaryPage || this.inSummaryPage && i == steps.length - 1;
            if (selected) {
                g.setFont(boldFont);
            }
            int width = fm.stringWidth(curr);
            while (width > this.getWidth() - (ins.left + ins.right) && curr.length() > 5) {
                curr = curr.substring(0, curr.length() - 5) + NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "elipsis");
            }
            g.drawString(curr, x, y);
            if (selected) {
                g.setFont(f);
            }
            y += h;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Font f = this.getFont() != null ? this.getFont() : UIManager.getFont("controlFont");
        Graphics g = this.getGraphics();
        if (g == null) {
            g = new BufferedImage(1, 1, 2).getGraphics();
        }
        f = f.deriveFont(1);
        FontMetrics fm = g.getFontMetrics(f);
        Insets ins = this.getInsets();
        int h = fm.getHeight();
        String[] steps = this.wizard.getAllSteps();
        int w = Integer.MIN_VALUE;
        for (int i = 0; i < steps.length; ++i) {
            String desc = i + ". " + ("_#UndeterminedStep".equals(steps[i]) ? NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "elipsis") : this.wizard.getStepDescription(steps[i]));
            if (desc == null) continue;
            w = Math.max(w, fm.stringWidth(desc) + 5);
        }
        if (Integer.MIN_VALUE == w) {
            w = 250;
        }
        h = (h + 3) * steps.length;
        this.minSize.width = w;
        this.minSize.height = h;
        if (this.img != null) {
            w = Math.max(w, this.img.getWidth());
            h = Math.max(h, this.img.getHeight());
        }
        h = h + ins.top + ins.bottom;
        this.historicWidth = w = Math.max(w, this.historicWidth);
        return new Dimension(w, h);
    }

    public void setInSummaryPage(boolean val) {
        this.inSummaryPage = val;
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        this.getPreferredSize();
        return this.minSize;
    }

    public void stepsChanged(Wizard wizard) {
        this.repaint();
    }

    public void navigabilityChanged(Wizard wizard) {
    }

    public void selectionChanged(Wizard wizard) {
        this.repaint();
    }

    @Override
    public void doLayout() {
        Component[] c = this.getComponents();
        Insets ins = this.getInsets();
        int y = this.getHeight() - (5 + ins.bottom);
        int x = 5 + ins.left;
        int w = this.getWidth() - (10 + ins.left + ins.right);
        if (w < 0) {
            w = 0;
        }
        for (int i = c.length - 1; i >= 0; --i) {
            Dimension d = c[i].getPreferredSize();
            c[i].setBounds(x, y - d.height, w, d.height);
            y -= d.height;
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        return new ACI(this);
    }

    private static class ACI
    extends AccessibleContext {
        private final Wizard wizard;
        private final InstructionsPanel panel;
        JEditorPane pane;

        public ACI(InstructionsPanel pnl) {
            this.wizard = pnl.wizard;
            this.panel = pnl;
            if (pnl.getParent() instanceof Accessible) {
                this.setAccessibleParent((Accessible)((Object)pnl.getParent()));
            }
            this.setAccessibleName(NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "ACN_InstructionsPanel"));
            this.setAccessibleDescription(NbBridge.getString("org/netbeans/modules/wizard/Bundle", InstructionsPanel.class, "ACSD_InstructionsPanel"));
        }

        @Override
        public AccessibleText getAccessibleText() {
            if (this.pane == null) {
                this.pane = new JEditorPane();
                this.pane.setBounds(this.panel.getBounds());
                this.pane.getAccessibleContext().getAccessibleText();
                this.pane.setFont(this.panel.getFont());
                CellRendererPane cell = new CellRendererPane();
                cell.add(this.pane);
            }
            this.pane.setText(this.getText());
            this.pane.selectAll();
            this.pane.validate();
            return this.pane.getAccessibleContext().getAccessibleText();
        }

        public String getText() {
            StringBuffer sb = new StringBuffer();
            String[] s = this.wizard.getAllSteps();
            for (int i = 0; i < s.length; ++i) {
                sb.append(this.wizard.getStepDescription(s[i]));
                sb.append('\n');
            }
            return sb.toString();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleState[] states = new AccessibleState[]{AccessibleState.VISIBLE, AccessibleState.OPAQUE, AccessibleState.SHOWING, AccessibleState.MULTI_LINE};
            return new AccessibleStateSet(states);
        }

        @Override
        public int getAccessibleIndexInParent() {
            return -1;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            throw new IndexOutOfBoundsException("" + i);
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return Locale.getDefault();
        }
    }
}

