/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.configure.Configurer;
import VASSAL.configure.SingleChildInstance;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ColorManager
extends AbstractConfigurable {
    protected static ColorManager instance;
    public static final Color DEFAULT_COLOR;
    public static final String SELECT_COLOR = "Select...";
    protected static Color[] standardColors;
    protected static String[] standardColorNames;
    protected Map<String, ColorSwatch> userColors = new HashMap<String, ColorSwatch>();

    public static ColorManager getColorManager() {
        return instance;
    }

    protected static String getStandardColorName(Color c) {
        for (int i = 0; i < standardColors.length; ++i) {
            if (!standardColors[i].equals(c)) continue;
            return standardColorNames[i];
        }
        return null;
    }

    protected static Color getStandardColor(String name) {
        for (int i = 0; i < standardColors.length; ++i) {
            if (!standardColorNames[i].equals(name)) continue;
            return standardColors[i];
        }
        return null;
    }

    public ColorManager() {
        instance = this;
    }

    public ColorSwatch getColorSwatch(String name) {
        ColorSwatch c = this.userColors.get(name);
        if (c == null) {
            c = new ColorSwatch(name, ColorManager.getStandardColor(name));
        }
        return c;
    }

    public ColorSwatch getColorSwatch(Color color) {
        if (color == null) {
            return new ColorSwatch("CLEAR", null);
        }
        ColorSwatch swatch = null;
        for (ColorSwatch cs : this.userColors.values()) {
            if (!color.equals(cs.getColor())) continue;
            swatch = cs;
            break;
        }
        if (swatch == null) {
            for (int j = 0; j < standardColors.length && swatch == null; ++j) {
                if (standardColors[j] == null || !standardColors[j].equals(color)) continue;
                swatch = new ColorSwatch(standardColorNames[j], standardColors[j]);
            }
        }
        if (swatch == null) {
            swatch = new ColorSwatch(SELECT_COLOR, color);
        }
        return swatch;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[0];
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public String getAttributeValueString(String key) {
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
    }

    @Override
    public Configurer getConfigurer() {
        return null;
    }

    @Override
    public void addTo(Buildable parent) {
        this.validator = new SingleChildInstance(GameModule.getGameModule(), this.getClass());
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{ColorSwatch.class};
    }

    public static String getConfigureTypeName() {
        return "Named Colors";
    }

    @Override
    public void add(Buildable b) {
        super.add(b);
        if (b instanceof ColorSwatch) {
            ColorSwatch def = (ColorSwatch)b;
            this.userColors.put(def.getConfigureName(), def);
            def.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("name".equals(evt.getPropertyName())) {
                        ColorManager.this.userColors.remove(evt.getOldValue());
                        ColorManager.this.userColors.put((String)evt.getNewValue(), (ColorSwatch)evt.getSource());
                    }
                }
            });
        }
    }

    @Override
    public void remove(Buildable b) {
        super.remove(b);
        if (b instanceof ColorSwatch) {
            this.userColors.remove(((ColorSwatch)b).getConfigureName());
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceImageDefinitions.htm", "NamedColors");
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    public Color getColorByName(String colorName) {
        ColorSwatch gcolor = this.getColorSwatch(colorName);
        if (gcolor != null) {
            Color color = gcolor.getColor();
            return color;
        }
        return DEFAULT_COLOR;
    }

    public String[] getColorNames() {
        ArrayList<ColorSwatch> a = new ArrayList<ColorSwatch>(this.userColors.values());
        Collections.sort(a);
        ArrayList<String> names = new ArrayList<String>(a.size() + standardColors.length);
        for (ColorSwatch cs : a) {
            names.add(cs.getConfigureName());
        }
        names.addAll(Arrays.asList(standardColorNames));
        return names.toArray(new String[0]);
    }

    static {
        DEFAULT_COLOR = Color.WHITE;
        standardColors = new Color[]{Color.WHITE, Color.GRAY, Color.BLACK, null, Color.RED, Color.GREEN, Color.BLUE, Color.ORANGE, Color.PINK, Color.CYAN, Color.MAGENTA, Color.YELLOW, Color.LIGHT_GRAY, Color.DARK_GRAY};
        standardColorNames = new String[]{"WHITE", "GRAY", "BLACK", "CLEAR", "RED", "GREEN", "BLUE", "ORANGE", "PINK", "CYAN", "MAGENTA", "YELLOW", "LIGHT GRAY", "DARK GRAY"};
    }
}

