/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.PropertyExpression;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalCommand;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceFilter;
import VASSAL.i18n.Resources;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.event.ActionEvent;
import javax.swing.KeyStroke;

public class DeckGlobalKeyCommand
extends MassKeyCommand {
    public DeckGlobalKeyCommand() {
        this.globalCommand = new DeckGlobalCommand(this);
        this.setConfigureName("");
    }

    public DeckGlobalKeyCommand(String code) {
        this();
        this.decode(code);
    }

    public DeckGlobalKeyCommand(String code, PropertySource source) {
        this(code);
        this.propertySource = source;
        this.globalCommand.setPropertySource(source);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.DeckGlobalKeyCommand.component_type");
    }

    @Override
    public void addTo(Buildable parent) {
        if (parent instanceof Map) {
            this.map = (Map)parent;
        }
        if (parent instanceof PropertySource) {
            this.propertySource = (PropertySource)((Object)parent);
        }
        ((DrawPile)parent).addGlobalKeyCommand(this);
        this.globalCommand.setPropertySource(this.propertySource);
    }

    @Override
    public void removeFrom(Buildable parent) {
        ((DrawPile)parent).removeGlobalKeyCommand(this);
    }

    public KeyCommand getKeyCommand(Deck deck) {
        return new DeckKeyCommand(this.getLocalizedConfigureName(), null, deck);
    }

    @Override
    public PieceFilter getFilter() {
        if (this.propertiesFilter == null || this.propertiesFilter.getExpression() == null || this.propertiesFilter.getExpression().length() == 0) {
            return null;
        }
        return super.getFilter();
    }

    public void apply(Deck deck) {
        GameModule.getGameModule().sendAndLog(((DeckGlobalCommand)this.globalCommand).apply(deck, this.getFilter()));
    }

    public String encode() {
        SequenceEncoder se = new SequenceEncoder('|');
        se.append(this.getConfigureName()).append(this.getAttributeValueString("hotkey")).append(this.getAttributeValueString("filter")).append(this.getAttributeValueString("deckCount")).append(this.getAttributeValueString("reportFormat")).append(this.getLocalizedConfigureName());
        return se.getValue();
    }

    public void decode(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, '|');
        this.setConfigureName(sd.nextToken(""));
        this.setAttribute("hotkey", sd.nextNamedKeyStroke('A'));
        this.setAttribute("filter", sd.nextToken(null));
        this.setAttribute("deckCount", sd.nextInt(0));
        this.setAttribute("reportFormat", sd.nextToken(""));
        this.localizedName = sd.nextToken(this.getConfigureName());
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.DeckGlobalKeyCommand.command"), Resources.getString("Editor.DeckGlobalKeyCommand.matching_properties"), Resources.getString("Editor.DeckGlobalKeyCommand.affects"), Resources.getString("Editor.report_format")};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"name", "hotkey", "filter", "deckCount", "reportFormat"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, NamedKeyStroke.class, PropertyExpression.class, DeckPolicyConfig2.class, MassKeyCommand.ReportFormatConfig.class};
    }

    public static class DeckGlobalCommand
    extends GlobalCommand {
        public DeckGlobalCommand(RecursionLimiter.Loopable l) {
            super(l);
        }

        public Command apply(Deck d, PieceFilter filter) {
            Command c;
            String reportText = this.reportFormat.getText(this.source);
            if (reportText.length() > 0) {
                c = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "*" + reportText);
                c.execute();
            } else {
                c = new NullCommand();
            }
            GlobalCommand.Visitor visitor = new GlobalCommand.Visitor(this, c, filter, this.keyStroke);
            DeckVisitorDispatcher dispatcher = new DeckVisitorDispatcher(visitor);
            dispatcher.accept(d);
            visitor.getTracker().repaint();
            c = visitor.getCommand();
            return c;
        }
    }

    class DeckKeyCommand
    extends KeyCommand {
        private static final long serialVersionUID = 1L;
        protected Deck deck;

        public DeckKeyCommand(String name, KeyStroke key, Deck deck) {
            super(name, key, (GamePiece)deck);
            this.deck = deck;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DeckGlobalKeyCommand.this.apply(this.deck);
        }
    }

    public static class DeckPolicyConfig2
    extends MassKeyCommand.DeckPolicyConfig {
        public DeckPolicyConfig2() {
            this.typeConfig.setValidValues(new String[]{"All pieces", "Fixed number of pieces"});
            this.prompt.setText("Affects:  ");
        }
    }
}

