/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.jabber;

import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleStatus;
import VASSAL.chat.jabber.JabberClient;
import VASSAL.chat.jabber.JabberRoom;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jivesoftware.smack.util.StringUtils;

public class JabberPlayer
extends SimplePlayer {
    private String jid;
    private JabberRoom joinedRoom;

    private JabberPlayer(String jid) {
        super(jid, "???", new SimpleStatus());
        this.jid = jid;
    }

    public String getJid() {
        return this.jid;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof JabberPlayer && this.jid.equals(((JabberPlayer)o).jid);
    }

    public int hashCode() {
        return this.jid.hashCode();
    }

    @Override
    public String toString() {
        return this.name + " (" + StringUtils.parseName((String)this.jid) + ")";
    }

    public void join(JabberRoom room) {
        if (this.joinedRoom != null) {
            this.joinedRoom.removePlayer(this);
        }
        room.addPlayer(this);
        this.joinedRoom = room;
    }

    public JabberRoom getJoinedRoom() {
        return this.joinedRoom;
    }

    public String getRawJid() {
        if (this.jid.contains("/")) {
            return StringUtils.parseName((String)this.jid) + "@" + StringUtils.parseServer((String)this.jid);
        }
        return this.jid;
    }

    public String getLoginName() {
        return StringUtils.parseName((String)this.jid);
    }

    public static String xmppAddressToJid(String participant) {
        String address = StringUtils.parseServer((String)participant);
        String[] parts = address.split("\\.");
        String server = parts[parts.length - 1];
        String nick = StringUtils.parseResource((String)participant);
        return nick + "@" + server + "/VASSAL";
    }

    public static class Manager {
        private Map<String, JabberPlayer> jidToPlayer = new HashMap<String, JabberPlayer>();

        public JabberPlayer getPlayer(String jid) {
            if (jid == null) {
                return null;
            }
            JabberPlayer p = this.jidToPlayer.get(jid);
            if (p == null) {
                p = new JabberPlayer(jid);
                this.jidToPlayer.put(jid, p);
            }
            return p;
        }

        public JabberPlayer getPlayerByLogin(JabberClient client, String login) {
            return this.getPlayer(login + "@" + client.getHost() + "/VASSAL");
        }

        public synchronized void deletePlayer(String jid) {
            this.jidToPlayer.remove(jid);
        }

        public synchronized void clear() {
            this.jidToPlayer.clear();
        }

        public Collection<JabberPlayer> getAllPlayers() {
            return this.jidToPlayer.values();
        }
    }
}

