/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SimpleRoom;
import VASSAL.chat.ui.ChatControlsInitializer;
import VASSAL.chat.ui.ChatServerControls;
import VASSAL.chat.ui.JoinRoomAction;
import VASSAL.chat.ui.PlayerActionFactory;
import VASSAL.chat.ui.RoomActionFactory;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class RoomInteractionControlsInitializer
implements ChatControlsInitializer {
    public static final Font POPUP_MENU_FONT = new Font("Dialog", 0, 10);
    private List<PlayerActionFactory> playerActionFactories = new ArrayList<PlayerActionFactory>();
    private List<RoomActionFactory> roomActionFactories = new ArrayList<RoomActionFactory>();
    protected ChatServerConnection client;
    private MouseAdapter currentRoomPopupBuilder;
    private MouseAdapter roomPopupBuilder;
    private ActionListener roomCreator;

    public RoomInteractionControlsInitializer(ChatServerConnection client) {
        this.client = client;
    }

    @Override
    public void initializeControls(final ChatServerControls controls) {
        this.currentRoomPopupBuilder = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                this.maybePopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.maybePopup(e);
            }

            private void maybePopup(MouseEvent e) {
                JPopupMenu popup;
                Object target;
                JTree tree;
                TreePath path;
                if (e.isPopupTrigger() && (path = (tree = (JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null && (target = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof Player && (popup = RoomInteractionControlsInitializer.this.buildPopupForPlayer((SimplePlayer)target, tree)) != null) {
                    int n = popup.getComponentCount();
                    for (int i = 0; i < n; ++i) {
                        popup.getComponent(i).setFont(POPUP_MENU_FONT);
                    }
                    popup.show(tree, e.getX(), e.getY());
                }
            }
        };
        controls.getCurrentRoom().addMouseListener(this.currentRoomPopupBuilder);
        this.roomPopupBuilder = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.maybePopup(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Object target;
                JTree tree;
                TreePath path;
                if (e.isPopupTrigger()) {
                    this.maybePopup(e);
                } else if (e.getClickCount() == 2 && SwingUtils.isMainMouseButtonDown(e) && (path = (tree = (JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null && (target = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof SimpleRoom) {
                    int row = tree.getRowForLocation(e.getX(), e.getY());
                    if (tree.isCollapsed(row)) {
                        tree.expandRow(row);
                    } else {
                        tree.collapseRow(row);
                    }
                    RoomInteractionControlsInitializer.this.doubleClickRoom((Room)target, tree);
                }
            }

            private void maybePopup(MouseEvent e) {
                JTree tree = (JTree)e.getSource();
                TreePath path = tree.getPathForLocation(e.getX(), e.getY());
                if (path != null) {
                    Object target = ((DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject();
                    JPopupMenu popup = null;
                    if (target instanceof Player) {
                        popup = RoomInteractionControlsInitializer.this.buildPopupForPlayer((SimplePlayer)target, tree);
                    } else if (target instanceof SimpleRoom) {
                        popup = RoomInteractionControlsInitializer.this.buildPopupForRoom((Room)target, tree);
                    }
                    if (popup != null) {
                        int n = popup.getComponentCount();
                        for (int i = 0; i < n; ++i) {
                            popup.getComponent(i).setFont(POPUP_MENU_FONT);
                        }
                        popup.show(tree, e.getX(), e.getY());
                    }
                }
            }
        };
        controls.getRoomTree().addMouseListener(this.roomPopupBuilder);
        this.roomCreator = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RoomInteractionControlsInitializer.this.createRoom(controls.getNewRoom().getText());
                controls.getNewRoom().setText("");
            }
        };
        controls.getNewRoom().addActionListener(this.roomCreator);
    }

    protected void createRoom(String name) {
        this.client.setRoom(new SimpleRoom(name));
    }

    public JPopupMenu buildPopupForRoom(Room room, JTree tree) {
        JPopupMenu popup = new JPopupMenu();
        for (RoomActionFactory f : this.roomActionFactories) {
            popup.add(f.getAction(room, tree));
        }
        return popup.getComponentCount() == 0 ? null : popup;
    }

    public void doubleClickRoom(Room room, JTree tree) {
        if (!room.equals(this.client.getRoom())) {
            new JoinRoomAction(room, this.client).actionPerformed(null);
        }
    }

    public void addPlayerActionFactory(PlayerActionFactory f) {
        this.playerActionFactories.add(f);
    }

    public void addRoomActionFactory(RoomActionFactory f) {
        this.roomActionFactories.add(f);
    }

    public JPopupMenu buildPopupForPlayer(SimplePlayer target, JTree tree) {
        JPopupMenu popup = new JPopupMenu();
        for (PlayerActionFactory f : this.playerActionFactories) {
            Action a = f.getAction(target, tree);
            if (a == null) continue;
            popup.add(a);
        }
        return popup.getComponentCount() == 0 ? null : popup;
    }

    @Override
    public void uninitializeControls(ChatServerControls controls) {
        controls.getRoomTree().removeMouseListener(this.roomPopupBuilder);
        controls.getCurrentRoom().removeMouseListener(this.currentRoomPopupBuilder);
        controls.getNewRoom().removeActionListener(this.roomCreator);
    }
}

