/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.Configurer;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.configure.ImageConfigurer;
import VASSAL.preferences.Prefs;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.filechooser.FileChooser;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class FileConfigurer
extends Configurer {
    protected ArchiveWriter archive;
    protected JPanel p;
    protected JTextField tf;
    protected FileChooser fc;
    protected boolean editable;
    protected DirectoryConfigurer startingDirectory;

    public FileConfigurer(String key, String name) {
        this(key, name, (DirectoryConfigurer)null);
    }

    public FileConfigurer(String key, String name, DirectoryConfigurer startingDirectory) {
        super(key, name);
        this.setValue(null);
        this.editable = true;
        this.startingDirectory = startingDirectory;
        this.fc = this.initFileChooser();
    }

    protected FileChooser initFileChooser() {
        FileChooser fc = FileChooser.createFileChooser(null, this.startingDirectory);
        if (this.startingDirectory == null && GameModule.getGameModule() != null) {
            fc.setCurrentDirectory((File)Prefs.getGlobalPrefs().getValue("modulesDir"));
        }
        return fc;
    }

    public FileConfigurer(String key, String name, ArchiveWriter archive) {
        this(key, name);
        this.archive = archive;
    }

    @Override
    public String getValueString() {
        if (this.archive == null) {
            return this.getFileValue() == null ? "null" : this.getFileValue().getPath();
        }
        return this.getFileValue() == null ? "null" : this.getFileValue().getName();
    }

    @Override
    public void setValue(Object o) {
        File f = (File)o;
        if (f != null && f.exists() && this.archive != null) {
            this.addToArchive(f);
        }
        super.setValue(f);
        if (this.tf != null && !this.noUpdate) {
            this.tf.setText(this.getValueString());
        }
    }

    protected void addToArchive(File f) {
        this.archive.addFile(f.getPath(), f.getName());
    }

    @Override
    public void setValue(String s) {
        if (s == null) {
            this.setValue((Object)null);
        } else {
            this.setValue(new File(s));
        }
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 0));
            this.p.add(new JLabel(this.getName()));
            JButton b = new JButton("Select");
            this.p.add(b);
            this.tf = new JTextField(this.getValueString());
            this.tf.setEditable(this.editable);
            this.tf.setMaximumSize(new Dimension(this.tf.getMaximumSize().width, this.tf.getPreferredSize().height));
            this.tf.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent evt) {
                    this.update();
                }

                @Override
                public void insertUpdate(DocumentEvent evt) {
                    this.update();
                }

                @Override
                public void removeUpdate(DocumentEvent evt) {
                    this.update();
                }

                public void update() {
                    String text = FileConfigurer.this.tf.getText();
                    File f = text != null && text.length() > 0 && !"null".equals(text) ? new File(text) : null;
                    FileConfigurer.this.noUpdate = true;
                    FileConfigurer.this.setValue(f);
                    FileConfigurer.this.noUpdate = false;
                }
            });
            this.p.add(this.tf);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FileConfigurer.this.chooseNewValue();
                }
            });
        }
        return this.p;
    }

    public void chooseNewValue() {
        if (this.fc.showOpenDialog(this.getControls()) != 0) {
            this.setValue((Object)null);
        } else {
            this.setValue(this.fc.getSelectedFile().exists() ? this.fc.getSelectedFile() : null);
        }
    }

    public File getFileValue() {
        return (File)this.value;
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        ImageConfigurer c = new ImageConfigurer(null, "Test file", new ArchiveWriter("testArchive"));
        c.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                System.err.println(evt.getNewValue());
            }
        });
        f.getContentPane().add(c.getControls());
        f.pack();
        f.setVisible(true);
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        if (this.tf != null) {
            this.tf.setEditable(editable);
        }
    }
}

