/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.tools.NamedKeyManager;
import VASSAL.tools.NamedKeyStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class NamedHotKeyConfigurer
extends Configurer
implements KeyListener {
    private JTextField tf = new JTextField(16);
    private JPanel p;
    private boolean named;
    private JTextField keyName = new JTextField(16);
    private char lastChar;

    public NamedHotKeyConfigurer(String key, String name) {
        this(key, name, new NamedKeyStroke());
    }

    public NamedHotKeyConfigurer(String key, String name, NamedKeyStroke val) {
        super(key, name, val);
        this.named = val != null && val.isNamed();
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        boolean bl = this.named = this.value != null && ((NamedKeyStroke)this.value).isNamed();
        if (!this.named && this.tf != null && !this.tf.getText().equals(this.keyToString())) {
            this.tf.setText(this.keyToString());
        }
    }

    public String keyToString() {
        return NamedHotKeyConfigurer.getString((NamedKeyStroke)this.getValue());
    }

    @Override
    public Object getValue() {
        return super.getValue();
    }

    @Override
    public String getValueString() {
        return NamedHotKeyConfigurer.encode((NamedKeyStroke)this.getValue());
    }

    public NamedKeyStroke getValueNamedKeyStroke() {
        return (NamedKeyStroke)this.value;
    }

    @Override
    public void setValue(String s) {
        this.setValue(s == null ? null : NamedHotKeyConfigurer.decode(s));
    }

    public void setEnabled(boolean b) {
        this.tf.setEnabled(b);
        this.keyName.setEnabled(b);
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 0));
            this.tf.setMaximumSize(new Dimension(this.tf.getMaximumSize().width, this.tf.getPreferredSize().height));
            this.tf.setText(this.keyToString());
            this.tf.addKeyListener(this);
            this.p.add(new JLabel(this.getName()));
            this.p.add(this.tf);
            this.keyName.setText(this.getValueNamedKeyStroke() == null ? null : this.getValueNamedKeyStroke().getName());
            this.keyName.setMaximumSize(new Dimension(this.keyName.getMaximumSize().width, this.keyName.getPreferredSize().height));
            this.keyName.addKeyListener(new KeyListener(){

                @Override
                public void keyReleased(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 8: 
                        case 127: {
                            if (NamedHotKeyConfigurer.this.keyName.getText().length() == 0) {
                                NamedHotKeyConfigurer.this.named = false;
                                NamedHotKeyConfigurer.this.setValue(NamedKeyStroke.NULL_KEYSTROKE);
                                NamedHotKeyConfigurer.this.updateVisibility();
                                NamedHotKeyConfigurer.this.updateFocus();
                                break;
                            }
                            NamedHotKeyConfigurer.this.setValue(new NamedKeyStroke(NamedKeyManager.getMarkerKeyStroke(), NamedHotKeyConfigurer.this.keyName.getText()));
                            break;
                        }
                        case 16: 
                        case 17: 
                        case 18: 
                        case 157: {
                            break;
                        }
                        default: {
                            if (NamedHotKeyConfigurer.this.isPrintableAscii(e.getKeyChar())) {
                                NamedHotKeyConfigurer.this.setValue(new NamedKeyStroke(NamedKeyManager.getMarkerKeyStroke(), NamedHotKeyConfigurer.this.keyName.getText()));
                                break;
                            }
                            NamedHotKeyConfigurer.this.named = false;
                            NamedHotKeyConfigurer.this.setValue(NamedKeyStroke.getKeyStrokeForEvent(e));
                            NamedHotKeyConfigurer.this.updateVisibility();
                            NamedHotKeyConfigurer.this.updateFocus();
                        }
                    }
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyTyped(KeyEvent e) {
                }
            });
            this.p.add(this.keyName);
            this.updateVisibility();
        }
        return this.p;
    }

    private void updateFocus() {
        if (this.tf.isVisible()) {
            this.tf.requestFocus();
        } else {
            this.keyName.requestFocus();
        }
    }

    protected void updateVisibility() {
        this.tf.setVisible(!this.isNamed());
        this.keyName.setVisible(this.isNamed());
        this.lastChar = '\u0000';
        Window w = SwingUtilities.getWindowAncestor(this.p);
        if (w != null) {
            w.pack();
        }
    }

    public boolean isNamed() {
        return this.named;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        this.lastChar = e.getKeyChar();
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 8: 
            case 127: {
                this.setValue(NamedKeyStroke.NULL_KEYSTROKE);
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 157: {
                break;
            }
            default: {
                NamedKeyStroke namedStroke = this.getValueNamedKeyStroke();
                if (namedStroke != null) {
                    char thisChar = e.getKeyChar();
                    if (this.isPrintableAscii(this.lastChar) && this.isPrintableAscii((int)thisChar)) {
                        String name = "" + this.lastChar + e.getKeyChar();
                        this.named = true;
                        this.keyName.setText(name);
                        this.setValue(new NamedKeyStroke(name));
                        this.updateVisibility();
                        this.keyName.requestFocus();
                        break;
                    }
                }
                this.setValue(NamedKeyStroke.getKeyStrokeForEvent(e));
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (!this.named) {
            this.tf.setText(NamedHotKeyConfigurer.getString((NamedKeyStroke)this.getValue()));
        }
    }

    protected boolean isPrintableAscii(char c) {
        return this.isPrintableAscii((int)c);
    }

    protected boolean isPrintableAscii(int i) {
        return i >= 32 && i <= 126;
    }

    public static String getString(NamedKeyStroke k) {
        return k == null || k.isNull() ? "" : NamedHotKeyConfigurer.getString(k.getStroke());
    }

    public static String getFancyString(NamedKeyStroke k) {
        Object s = NamedHotKeyConfigurer.getString(k);
        if (((String)s).length() > 0) {
            s = "[" + (String)s + "]";
        }
        return s;
    }

    public static String getString(KeyStroke k) {
        return NamedKeyManager.isNamed(k) ? "" : HotKeyConfigurer.getString(k);
    }

    public static NamedKeyStroke decode(String s) {
        if (s == null) {
            return NamedKeyStroke.NULL_KEYSTROKE;
        }
        String[] parts = s.split(",");
        if (parts.length < 2) {
            return NamedKeyStroke.NULL_KEYSTROKE;
        }
        try {
            KeyStroke stroke = KeyStroke.getKeyStroke(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
            String name = null;
            if (parts.length > 2) {
                name = parts[2];
            }
            return new NamedKeyStroke(stroke, name);
        }
        catch (Exception e) {
            return NamedKeyStroke.NULL_KEYSTROKE;
        }
    }

    public static String encode(NamedKeyStroke stroke) {
        if (stroke == null) {
            return "";
        }
        KeyStroke key = stroke.getStroke();
        if (key == null) {
            return "";
        }
        String s = key.getKeyCode() + "," + key.getModifiers();
        if (stroke.isNamed()) {
            s = s + "," + stroke.getName();
        }
        return s;
    }
}

