/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.PieceFilter;
import VASSAL.i18n.Resources;
import VASSAL.script.ExpressionInterpreter;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.script.expression.IntExpression;
import VASSAL.script.expression.NullExpression;
import VASSAL.script.expression.StringExpression;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import java.util.Map;

public class BeanShellExpression
extends Expression {
    protected ExpressionInterpreter interpreter;

    public BeanShellExpression(String s) {
        this.setExpression("{" + s + "}");
    }

    @Override
    public String evaluate(PropertySource ps, Map<String, String> properties, boolean localized) throws ExpressionException {
        if (this.interpreter == null) {
            this.interpreter = ExpressionInterpreter.createInterpreter(BeanShellExpression.strip(this.getExpression()));
        }
        return this.interpreter.evaluate(ps, localized);
    }

    @Override
    public String toBeanShellString() {
        return BeanShellExpression.strip(this.getExpression());
    }

    protected static String strip(String expr) {
        String s = expr.trim();
        if (s.startsWith("{") && s.endsWith("}")) {
            return s.substring(1, s.length() - 1);
        }
        return expr;
    }

    protected boolean isDynamic() {
        return this.getExpression() != null && this.getExpression().indexOf(36) >= 0;
    }

    @Override
    public PieceFilter getFilter(PropertySource ps) {
        if (this.isDynamic()) {
            String s = new FormattedString(BeanShellExpression.strip(this.getExpression())).getText(ps);
            return Expression.createExpression("{" + s + "}").getFilter();
        }
        return piece -> {
            String result = null;
            try {
                result = this.evaluate(piece);
            }
            catch (ExpressionException e) {
                ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.expression_error"), "Expression=" + this.getExpression() + ", Error=" + e.getError(), e));
            }
            return "true".equals(result);
        };
    }

    public static String convertProperty(String prop) {
        if (prop == null || prop.length() == 0) {
            return "";
        }
        if (BeanShellExpression.isBeanShellExpression(prop)) {
            return BeanShellExpression.strip(prop);
        }
        boolean ok = Character.isJavaIdentifierStart(prop.charAt(0));
        if (ok) {
            for (int i = 1; i < prop.length() && ok; ++i) {
                ok = Character.isJavaIdentifierPart(prop.charAt(i));
            }
        }
        return ok ? prop : "GetProperty(\"" + prop + "\")";
    }

    public static boolean isBeanShellExpression(String expr) {
        return expr.startsWith("{") && expr.endsWith("}");
    }

    public static boolean isJavaIdentifier(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static Expression createExpression(String s) {
        return BeanShellExpression.createExpression(s, false);
    }

    public static Expression createExpression(String s, boolean dontCreateStringExpressions) {
        String t = s.trim();
        String expr = t.startsWith("{") && t.endsWith("}") ? t.substring(1, t.length() - 1).trim() : t;
        if (expr.trim().length() == 0) {
            return new NullExpression();
        }
        try {
            return new IntExpression(Integer.parseInt(expr));
        }
        catch (NumberFormatException numberFormatException) {
            if (!dontCreateStringExpressions && expr.length() > 1 && expr.startsWith("\"") && expr.endsWith("\"") && expr.indexOf(34, 1) == expr.length() - 1) {
                return new StringExpression(expr.substring(1, expr.length() - 1));
            }
            return new BeanShellExpression(expr);
        }
    }

    @Override
    public boolean equals(Object bse) {
        return super.equals(bse);
    }
}

