/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.NamedKeyStroke;
import java.util.HashMap;
import javax.swing.KeyStroke;

public class NamedKeyManager {
    protected static NamedKeyManager instance;
    protected static final int NAMED_START = 57344;
    protected static final int NAMED_END = 63742;
    protected static final int NAMED_MARKER = 63743;
    protected static int nextNamedKey;
    protected static HashMap<String, KeyStroke> strokes;

    public static NamedKeyManager getInstance() {
        if (instance == null) {
            instance = new NamedKeyManager();
        }
        return instance;
    }

    public static boolean isNamed(KeyStroke k) {
        if (k == null) {
            return false;
        }
        int code = k.getKeyCode();
        return code == 63743 || code >= 57344 && code <= 63742;
    }

    public static KeyStroke getMarkerKeyStroke() {
        return KeyStroke.getKeyStroke(63743, 0);
    }

    public KeyStroke getKeyStroke(NamedKeyStroke vkey) {
        if (!vkey.isNamed()) {
            return vkey.getStroke();
        }
        KeyStroke stroke = strokes.get(vkey.getName());
        if (stroke == null) {
            stroke = KeyStroke.getKeyStroke(this.getNextStroke(), 0);
            strokes.put(vkey.getName(), stroke);
        }
        return stroke;
    }

    public int getNextStroke() {
        if (nextNamedKey == 63742) {
            throw new IllegalStateException("Too many Named Keys");
        }
        return nextNamedKey++;
    }

    static {
        nextNamedKey = 57344;
        strokes = new HashMap();
    }
}

