/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.AbstractTiledOpImpl;
import VASSAL.tools.imageop.CropOpBitmapImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.RotateOp;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class OrthoRotateOpBitmapImpl
extends AbstractTiledOpImpl
implements RotateOp {
    private final ImageOp sop;
    private final int angle;
    private final int hash;

    public OrthoRotateOpBitmapImpl(ImageOp sop, int angle) {
        if (sop == null) {
            throw new IllegalArgumentException();
        }
        if ((angle = (360 + angle % 360) % 360) % 90 != 0) {
            throw new IllegalArgumentException();
        }
        this.sop = sop;
        this.angle = angle / 90;
        this.hash = new HashCodeBuilder().append((Object)sop).append(angle).toHashCode();
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.singletonList(this.sop);
    }

    @Override
    public BufferedImage eval() throws Exception {
        BufferedImage src = this.sop.getImage(null);
        if (this.size == null) {
            this.fixSize();
        }
        BufferedImage dst = ImageUtils.createCompatibleImage(this.size.width, this.size.height, src.getTransparency() != 1);
        Graphics2D g = dst.createGraphics();
        g.rotate(1.5707963267948966 * (double)this.angle, (double)src.getWidth() / 2.0, (double)src.getHeight() / 2.0);
        g.drawImage((Image)src, 0, 0, null);
        g.dispose();
        return dst;
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = this.sop.getSize();
            if (this.angle == 1 || this.angle == 3) {
                this.size.setSize(this.size.height, this.size.width);
            }
        }
    }

    @Override
    public double getAngle() {
        return this.angle * 90;
    }

    @Override
    public RenderingHints getHints() {
        return null;
    }

    @Override
    protected ImageOp createTileOp(int tileX, int tileY) {
        return new TileOp(this, tileX, tileY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        OrthoRotateOpBitmapImpl op = (OrthoRotateOpBitmapImpl)o;
        return this.angle == op.angle && this.sop.equals(op.sop);
    }

    public int hashCode() {
        return this.hash;
    }

    private static class TileOp
    extends AbstractTileOpImpl {
        private final ImageOp sop;
        private final int angle;
        private final int hash;

        public TileOp(OrthoRotateOpBitmapImpl rop, int tileX, int tileY) {
            int sy1;
            int sx1;
            int sy0;
            int sx0;
            if (rop == null) {
                throw new IllegalArgumentException();
            }
            if (tileX < 0 || tileX >= rop.getNumXTiles() || tileY < 0 || tileY >= rop.getNumYTiles()) {
                throw new IndexOutOfBoundsException();
            }
            this.angle = rop.angle;
            switch (this.angle) {
                case 0: {
                    sx0 = tileX * rop.tileSize.width;
                    sy0 = tileY * rop.tileSize.height;
                    sx1 = Math.min((tileX + 1) * rop.tileSize.width, rop.size.width);
                    sy1 = Math.min((tileY + 1) * rop.tileSize.height, rop.size.height);
                    break;
                }
                case 1: {
                    sx0 = tileY * rop.tileSize.height;
                    sy0 = tileX * rop.tileSize.width;
                    sx1 = Math.min((tileY + 1) * rop.tileSize.height, rop.size.height);
                    sy1 = Math.min((tileX + 1) * rop.tileSize.width, rop.size.width);
                    break;
                }
                case 2: {
                    sx1 = rop.size.width - tileX * rop.tileSize.width;
                    sy1 = rop.size.height - tileY * rop.tileSize.height;
                    sx0 = rop.size.width - Math.min((tileX + 1) * rop.tileSize.width, rop.size.width);
                    sy0 = rop.size.height - Math.min((tileY + 1) * rop.tileSize.height, rop.size.height);
                    break;
                }
                default: {
                    sx1 = rop.size.height - tileY * rop.tileSize.height;
                    sy1 = rop.size.width - tileX * rop.tileSize.width;
                    sx0 = rop.size.height - Math.min((tileY + 1) * rop.tileSize.height, rop.size.height);
                    sy0 = rop.size.width - Math.min((tileX + 1) * rop.tileSize.width, rop.size.width);
                }
            }
            this.size = new Dimension(sx1 - sx0, sy1 - sy0);
            this.sop = new CropOpBitmapImpl(rop.sop, sx0, sy0, sx1, sy1);
            this.hash = new HashCodeBuilder().append((Object)this.sop).append(this.angle).toHashCode();
        }

        @Override
        public List<Op<?>> getSources() {
            return Collections.singletonList(this.sop);
        }

        @Override
        public BufferedImage eval() throws Exception {
            BufferedImage src = this.sop.getImage(null);
            BufferedImage dst = ImageUtils.createCompatibleImage(this.size.width, this.size.height, src.getTransparency() != 1);
            Graphics2D g = dst.createGraphics();
            g.rotate(1.5707963267948966 * (double)this.angle, (double)src.getWidth() / 2.0, (double)src.getHeight() / 2.0);
            g.drawImage((Image)src, 0, 0, null);
            g.dispose();
            return dst;
        }

        @Override
        protected void fixSize() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            TileOp op = (TileOp)o;
            return this.angle == op.angle && this.sop.equals(op.sop);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

