/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.ipc;

import VASSAL.tools.concurrent.listener.DefaultMultiEventListenerSupport;
import VASSAL.tools.concurrent.listener.EventListener;
import VASSAL.tools.concurrent.listener.MultiEventListenerSupport;
import VASSAL.tools.ipc.Fin;
import VASSAL.tools.ipc.Halt;
import VASSAL.tools.ipc.IPCMessage;
import VASSAL.tools.ipc.IPCMessageDispatcher;
import VASSAL.tools.ipc.IPCMessageReceiver;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;

public class IPCMessenger {
    protected final AtomicLong next_id = new AtomicLong(0L);
    protected final Map<Long, CompletableFuture<IPCMessage>> waiting = new ConcurrentHashMap<Long, CompletableFuture<IPCMessage>>();
    protected final BlockingQueue<IPCMessage> outqueue = new LinkedBlockingQueue<IPCMessage>();
    protected final ObjectInputStream in;
    protected final ObjectOutputStream out;
    protected final MultiEventListenerSupport lsup;

    public IPCMessenger(InputStream in, OutputStream out, MultiEventListenerSupport lsup) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        if (lsup == null) {
            throw new IllegalArgumentException("lsup == null");
        }
        this.out = new ObjectOutputStream(out);
        this.in = new ObjectInputStream(in);
        this.lsup = lsup;
    }

    public IPCMessenger(Socket sock) throws IOException {
        this(sock.getInputStream(), sock.getOutputStream());
    }

    public IPCMessenger(InputStream in, OutputStream out) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException("in == null");
        }
        if (out == null) {
            throw new IllegalArgumentException("out == null");
        }
        this.out = new ObjectOutputStream(out);
        this.in = new ObjectInputStream(in);
        this.lsup = new DefaultMultiEventListenerSupport(this);
        this.lsup.addEventListener(IPCMessage.class, new EventListener<IPCMessage>(){

            @Override
            public void receive(Object src, IPCMessage msg) {
                if (msg.isReply()) {
                    CompletableFuture<IPCMessage> f = IPCMessenger.this.waiting.remove(msg.getInReplyTo());
                    if (f == null) {
                        throw new IllegalStateException(msg.toString());
                    }
                    f.complete(msg);
                }
            }
        });
        this.lsup.addEventListener(Halt.class, new EventListener<Halt>(){

            @Override
            public void receive(Object src, Halt halt) {
                try {
                    IPCMessenger.this.send(new Fin(halt));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }

    public void start() throws IOException {
        IPCMessageReceiver mr = new IPCMessageReceiver(this.in, this.lsup);
        new Thread((Runnable)mr, "IPC receiver for " + this.hashCode()).start();
        IPCMessageDispatcher md = new IPCMessageDispatcher(this.outqueue, this.out);
        new Thread((Runnable)md, "IPC dispatcher for " + this.hashCode()).start();
    }

    public void stop() throws IOException {
        Future<IPCMessage> f = this.send(new Halt());
        try {
            f.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    public Future<IPCMessage> send(IPCMessage msg) throws IOException {
        if (msg == null) {
            throw new IllegalArgumentException("msg == null");
        }
        msg.setId(this.next_id.getAndIncrement());
        CompletableFuture<IPCMessage> f = new CompletableFuture<IPCMessage>();
        if (msg.expectsReply()) {
            this.waiting.put(msg.getId(), f);
        } else {
            f.complete(null);
        }
        this.outqueue.offer(msg);
        return f;
    }

    public <T> void addEventListener(Class<T> c, EventListener<? super T> l) {
        this.lsup.addEventListener(c, l);
    }

    public <T> void removeEventListener(Class<T> c, EventListener<? super T> l) {
        this.lsup.removeEventListener(c, l);
    }

    public boolean hasEventListeners(Class<?> c) {
        return this.lsup.hasEventListeners(c);
    }

    public <T> List<EventListener<? super T>> getEventListeners(Class<T> c) {
        return this.lsup.getEventListeners(c);
    }
}

