/*
 * Decompiled with CFR 0.152.
 */
package org.litesoft.p2pchat;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Vector;
import org.litesoft.p2pchat.IllegalArgument;

public class PeerWriter
extends Thread {
    private Vector<String> zLines = new Vector();
    private boolean isOpen = true;
    private BufferedWriter zWriter;
    private long pingInterval = 900000L;

    public PeerWriter(OutputStream pOs) {
        IllegalArgument.ifNull("Os", pOs);
        this.zWriter = new BufferedWriter(new OutputStreamWriter(pOs, Charset.forName("UTF-8")));
        this.setName("Peer Writer Thread");
        this.start();
    }

    public synchronized void writeLine(String pMessage) {
        IllegalArgument.ifNull("Message", pMessage);
        if (this.isOpen) {
            this.zLines.addElement(pMessage);
        }
        this.notifyAll();
    }

    public synchronized void close() {
        this.isOpen = false;
        this.notifyAll();
    }

    public synchronized boolean isOpen() {
        return this.isOpen;
    }

    private synchronized String getLine() {
        String message;
        while (this.isOpen && this.zLines.isEmpty()) {
            try {
                this.wait(this.pingInterval);
            }
            catch (InterruptedException interruptedException) {}
        }
        String string = message = this.isOpen ? "" : null;
        if (this.isOpen && this.zLines.size() > 0) {
            message = this.zLines.elementAt(0);
            this.zLines.removeElementAt(0);
        }
        return message;
    }

    @Override
    public void run() {
        try {
            String line;
            while (null != (line = this.getLine())) {
                this.zWriter.write(line);
                this.zWriter.newLine();
                this.zWriter.flush();
            }
            this.zWriter.write("BYE");
            this.zWriter.newLine();
            this.zWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.isOpen = false;
            this.zWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

