/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.ImageItemInstance;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.ShapeItemInstance;
import VASSAL.build.module.gamepieceimage.SymbolItemInstance;
import VASSAL.build.module.gamepieceimage.TextBoxItemInstance;
import VASSAL.build.module.gamepieceimage.TextItemInstance;
import VASSAL.build.module.gamepieceimage.Visualizer;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.ScrollPane;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;

public class InstanceConfigurer
extends Configurer {
    protected GamePieceImage defn;
    protected Box visBox;
    protected Visualizer visualizer = new Visualizer();
    protected JPanel panel;
    protected SymbolPanel symbolPanel;
    protected InstanceConfigurer me;

    protected InstanceConfigurer() {
        super(null, null);
        this.me = this;
    }

    protected InstanceConfigurer(String key, String name, GamePieceImage defn) {
        super(key, name);
        this.defn = defn;
        this.setValue(defn.getInstances());
        this.me = this;
    }

    @Override
    public String getValueString() {
        return InstanceConfigurer.PropertiesToString(this.getValueList());
    }

    public List<ItemInstance> getValueList() {
        return (List)this.getValue();
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public ArrayList<ItemInstance> getValueArrayList() {
        ProblemDialog.showDeprecated("2020-08-06");
        return (ArrayList)this.getValue();
    }

    @Override
    public void setValue(String s) {
        this.setValue(InstanceConfigurer.StringToProperties(s, this.defn));
        if (this.symbolPanel != null) {
            this.symbolPanel.reset();
        }
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            Box filler = Box.createHorizontalBox();
            filler.setPreferredSize(new Dimension(50, 10));
            this.panel.add(filler);
            this.visBox = Box.createHorizontalBox();
            this.visBox.setAlignmentX(0.5f);
            this.visualizer = new Visualizer(this.defn);
            this.visBox.add(new ScrollPane(this.visualizer));
            this.panel.add(this.visBox);
            filler = Box.createHorizontalBox();
            filler.setPreferredSize(new Dimension(50, 10));
            this.panel.add(filler);
            this.symbolPanel = new SymbolPanel();
            this.panel.add(this.symbolPanel);
        }
        return this.panel;
    }

    public static String PropertiesToString(List<ItemInstance> props) {
        String[] p = new String[props.size()];
        int i = 0;
        for (ItemInstance prop : props) {
            p[i++] = prop.encode();
        }
        return StringArrayConfigurer.arrayToString(p);
    }

    public static List<ItemInstance> StringToProperties(String s, GamePieceImage defn) {
        String[] p;
        ArrayList<ItemInstance> props = new ArrayList<ItemInstance>();
        for (String item : p = StringArrayConfigurer.stringToArray(s)) {
            if (item.startsWith("Symbol")) {
                props.add(new SymbolItemInstance(item, defn));
                continue;
            }
            if (item.startsWith("TextBox")) {
                props.add(new TextBoxItemInstance(item, defn));
                continue;
            }
            if (item.startsWith("Text")) {
                props.add(new TextItemInstance(item, defn));
                continue;
            }
            if (item.startsWith("Box")) {
                props.add(new ShapeItemInstance(item, defn));
                continue;
            }
            if (!item.startsWith("Image")) continue;
            props.add(new ImageItemInstance(item, defn));
        }
        return props;
    }

    public void refresh() {
        if (this.symbolPanel != null) {
            this.symbolPanel.refresh();
        }
        this.visualizer.rebuild();
    }

    public void rebuildViz() {
        if (this.visualizer != null) {
            this.visualizer.rebuild();
        }
    }

    public void repack() {
        Window w;
        if (this.panel != null && (w = SwingUtilities.getWindowAncestor(this.panel)) != null) {
            w.pack();
        }
        this.rebuildViz();
    }

    protected class SymbolPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        protected JTable table;
        protected AbstractTableModel model;
        protected JScrollPane scrollPane;
        protected JButton addSymbolBtn;
        protected JButton addTextBtn;
        protected JButton remBtn;
        protected JPanel mainPanel;
        protected JPanel detailPanel;
        protected Component detailControls;
        protected int currentDetail;
        protected static final int NO_CURRENT_ITEM = -1;
        protected static final int NAME_COL = 0;
        protected static final int TYPE_COL = 1;
        protected static final int LOC_COL = 2;

        public SymbolPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.mainPanel = new JPanel();
            this.mainPanel.setBorder(BorderFactory.createLineBorder(Color.black));
            this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Items"));
            this.mainPanel.add(box);
            this.model = new SymbolTableModel();
            this.table = new JTable(this.model);
            this.table.setSelectionMode(0);
            if (InstanceConfigurer.this.getValueList() != null && InstanceConfigurer.this.getValueList().size() > 0) {
                this.table.getSelectionModel().setSelectionInterval(0, 0);
            }
            ListSelectionModel rowSM = this.table.getSelectionModel();
            rowSM.addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    this.showItem(-1);
                } else {
                    int selectedRow = lsm.getMinSelectionIndex();
                    this.showItem(selectedRow);
                }
            });
            this.scrollPane = new ScrollPane(this.table);
            this.table.setPreferredScrollableViewportSize(new Dimension(300, 100));
            this.mainPanel.add(this.scrollPane);
            this.detailPanel = new JPanel();
            this.mainPanel.add(new ScrollPane(this.detailPanel));
            this.add(this.mainPanel);
            this.showItem(0);
        }

        protected void showItem(int itemNo) {
            if (this.detailControls != null) {
                this.detailPanel.remove(this.detailControls);
                this.detailControls = null;
                this.currentDetail = -1;
            }
            int count = InstanceConfigurer.this.getValueList().size();
            if (itemNo != -1 && count > 0 && itemNo < count) {
                ItemInstance instance = InstanceConfigurer.this.getValueList().get(itemNo);
                instance.setConfig(InstanceConfigurer.this.me);
                Configurer c = instance.getConfigurer();
                this.detailControls = c.getControls();
                this.detailPanel.add(this.detailControls);
                this.currentDetail = itemNo;
            }
            this.reshow();
        }

        public void reset() {
            this.showItem(this.currentDetail);
        }

        public void reshow() {
            this.repack();
            this.detailPanel.repaint();
        }

        public void refresh() {
            this.showItem(this.currentDetail);
            this.reshow();
        }

        protected void repack() {
            Window w = SwingUtilities.getWindowAncestor(InstanceConfigurer.this.panel);
            if (w != null) {
                w.pack();
            }
        }

        class SymbolTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;
            private final String[] columnNames = new String[]{"Name", "Type", "Position"};

            SymbolTableModel() {
            }

            @Override
            public int getColumnCount() {
                return this.columnNames.length;
            }

            @Override
            public int getRowCount() {
                return InstanceConfigurer.this.getValueList() == null ? 0 : InstanceConfigurer.this.getValueList().size();
            }

            @Override
            public String getColumnName(int col) {
                return this.columnNames[col];
            }

            @Override
            public Object getValueAt(int row, int col) {
                if (col == 0) {
                    return InstanceConfigurer.this.getValueList().get(row).getName();
                }
                if (col == 1) {
                    return InstanceConfigurer.this.getValueList().get(row).getItem().getDisplayName();
                }
                if (col == 2) {
                    return InstanceConfigurer.this.getValueList().get(row).getLocation();
                }
                return null;
            }

            public Class<String> getColumnClass(int col) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
            }
        }
    }
}

