/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AutoConfigurable;
import VASSAL.build.module.gamepieceimage.FontManager;
import VASSAL.build.module.gamepieceimage.FontStyle;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.OutlineFont;
import VASSAL.build.module.gamepieceimage.StringEnumConfigurer;
import VASSAL.build.module.gamepieceimage.TextItemInstance;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.ArrayUtils;

public class TextItem
extends Item {
    public static final String TYPE = "Text";
    protected static final String FONT = "font";
    protected static final String SOURCE = "source";
    protected static final String TEXT = "text";
    protected static final String LEFT = "left";
    protected static final String CENTER = "center";
    protected static final String RIGHT = "right";
    protected static final String TOP = "top";
    protected static final String BOTTOM = "bottom";
    public static final String SRC_VARIABLE = "Specified in individual images";
    public static final String SRC_FIXED = "Fixed for this layout";
    protected static final String PIECE_NAME = "pieceName";
    protected static final String LABEL = "label";
    protected static final String DEFAULT_FORMAT = "$pieceName$";
    public static final int AL_CENTER = 0;
    public static final int AL_RIGHT = 1;
    public static final int AL_LEFT = 2;
    public static final int AL_TOP = 3;
    public static final int AL_BOTTOM = 4;
    protected String fontStyleName = "Default";
    protected String textSource = "Specified in individual images";
    protected String text = "";
    protected String changeCmd = "";
    protected KeyStroke changeKey;
    protected boolean lockable = false;
    protected String lockCmd = "";
    protected KeyStroke lockKey;
    private VisibilityCondition fixedCond = new VisibilityCondition(){

        @Override
        public boolean shouldBeVisible() {
            return TextItem.this.textSource.equals(TextItem.SRC_FIXED);
        }
    };

    public TextItem() {
    }

    public TextItem(GamePieceLayout l) {
        super(l);
    }

    public TextItem(GamePieceLayout l, String nam) {
        this(l);
        this.setConfigureName(nam);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.insert((int)2, (Object[])super.getAttributeDescriptions(), (Object[])new String[]{"Font style:  ", "Text is:  ", "Text:  "});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.insert((int)2, (Object[])super.getAttributeTypes(), (Object[])new Class[]{FontStyleConfig.class, TextSource.class, String.class});
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.insert((int)2, (Object[])super.getAttributeNames(), (Object[])new String[]{FONT, SOURCE, TEXT});
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (FONT.equals(key)) {
            this.fontStyleName = (String)o;
        } else if (SOURCE.equals(key)) {
            this.textSource = (String)o;
        } else if (TEXT.equals(key)) {
            this.text = (String)o;
        } else {
            super.setAttribute(key, o);
        }
        if (this.layout != null) {
            this.layout.refresh();
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (FONT.equals(key)) {
            return this.fontStyleName;
        }
        if (SOURCE.equals(key)) {
            return this.textSource;
        }
        if (TEXT.equals(key)) {
            return this.text;
        }
        return super.getAttributeValueString(key);
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (TEXT.equals(name)) {
            return this.fixedCond;
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public void draw(Graphics g, GamePieceImage defn) {
        TextItemInstance ti = null;
        FontStyle fs = FontManager.getFontManager().getFontStyle(this.fontStyleName);
        OutlineFont f = fs.getFont();
        if (defn != null) {
            ti = defn.getTextInstance(this.name);
        } else {
            defn = new GamePieceImage(this.getLayout());
            ti = defn.getTextInstance(this.name);
        }
        if (ti == null) {
            ti = new TextItemInstance();
        }
        Color fg = ti.getFgColor().getColor();
        Color bg = ti.getBgColor().getColor();
        if (fg == null && bg == null) {
            return;
        }
        boolean outline = ti.isOutline();
        Color ol = ti.getOutlineColor().getColor();
        String compass = GamePieceLayout.getCompassPoint(this.getLocation());
        int hAlign = 0;
        switch (compass.charAt(compass.length() - 1)) {
            case 'W': {
                hAlign = 2;
                break;
            }
            case 'E': {
                hAlign = 1;
            }
        }
        int vAlign = 0;
        switch (compass.charAt(0)) {
            case 'N': {
                vAlign = 3;
                break;
            }
            case 'S': {
                vAlign = 4;
            }
        }
        Point origin = this.layout.getPosition(this);
        String s = null;
        if (this.textSource.equals(SRC_FIXED)) {
            s = this.text;
        } else if (defn != null && ti != null) {
            s = ti.getValue();
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isAntialias() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        AffineTransform saveXForm = null;
        if (this.getRotation() != 0) {
            saveXForm = g2d.getTransform();
            AffineTransform newXForm = AffineTransform.getRotateInstance(Math.toRadians(this.getRotation()), this.getLayout().getVisualizerWidth() / 2, this.getLayout().getVisualizerHeight() / 2);
            g2d.transform(newXForm);
        }
        TextItem.drawLabel(g, s, origin.x, origin.y, f, hAlign, vAlign, fg, bg, null, outline, ol);
        if (saveXForm != null) {
            g2d.setTransform(saveXForm);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getDisplayName() {
        return "Label";
    }

    @Override
    public Dimension getSize() {
        return new Dimension(0, 0);
    }

    public static Item decode(GamePieceLayout l, String s) {
        TextItem item = new TextItem(l);
        TextItem.decode(item, s);
        return item;
    }

    public static void decode(TextItem item, String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ';');
        sd.nextToken();
        item.fontStyleName = sd.nextToken("Default");
        if (item.fontStyleName.length() == 0) {
            item.fontStyleName = "Default";
        }
        item.textSource = sd.nextToken(SRC_VARIABLE);
        item.text = sd.nextToken("");
        item.changeCmd = sd.nextToken("");
        item.changeKey = sd.nextKeyStroke(null);
        item.lockCmd = sd.nextToken("");
        item.lockKey = sd.nextKeyStroke(null);
        item.lockable = sd.nextBoolean(false);
    }

    @Override
    public String encode() {
        SequenceEncoder se1 = new SequenceEncoder(TYPE, ';');
        se1.append(this.fontStyleName == null ? "" : this.fontStyleName);
        se1.append(this.textSource);
        se1.append(this.text);
        se1.append(this.changeCmd);
        se1.append(this.changeKey);
        se1.append(this.lockCmd);
        se1.append(this.lockKey);
        se1.append(this.lockable);
        SequenceEncoder se2 = new SequenceEncoder(se1.getValue(), '|');
        se2.append(super.encode());
        return se2.getValue();
    }

    public boolean isOutline() {
        return FontManager.getFontManager().getFontStyle(this.fontStyleName).isOutline();
    }

    public boolean isFixed() {
        return this.textSource.equals(SRC_FIXED);
    }

    public static void drawLabel(Graphics g, String text, int x, int y, Font f, int hAlign, int vAlign, Color fgColor, Color bgColor, Color borderColor, boolean outline, Color outlineColor) {
        g.setFont(f);
        int buffer = g.getFontMetrics().getLeading();
        int width = g.getFontMetrics().stringWidth(text) + 2 * buffer;
        int height = g.getFontMetrics().getHeight();
        int x0 = x;
        int y0 = y;
        switch (hAlign) {
            case 0: {
                x0 = x - width / 2;
                break;
            }
            case 1: {
                x0 = x - width;
            }
        }
        switch (vAlign) {
            case 0: {
                y0 = y - height / 2;
                break;
            }
            case 4: {
                y0 = y - height;
            }
        }
        if (bgColor != null) {
            g.setColor(bgColor);
            g.fillRect(x0, y0, width, height);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawRect(x0, y0, width, height);
        }
        int y1 = y0 + g.getFontMetrics().getHeight() - g.getFontMetrics().getDescent();
        int x1 = x0 + buffer;
        if (outline && outlineColor != null) {
            g.setColor(outlineColor);
            g.drawString(text, x1 - 1, y1 - 1);
            g.drawString(text, x1 - 1, y1 + 1);
            g.drawString(text, x1 + 1, y1 - 1);
            g.drawString(text, x1 + 1, y1 + 1);
        }
        g.setColor(fgColor);
        g.drawString(text, x1, y1);
    }

    public static class FontStyleConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new StringEnumConfigurer(key, name, FontManager.getFontManager().getFontNames());
        }
    }

    public static class TextSource
    extends StringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{TextItem.SRC_VARIABLE, TextItem.SRC_FIXED};
        }
    }

    public static class NameFormatConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new FormattedStringConfigurer(key, name, new String[]{TextItem.PIECE_NAME, TextItem.LABEL});
        }
    }
}

