/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.widget;

import VASSAL.build.Buildable;
import VASSAL.build.Widget;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TabWidget
extends Widget
implements ChangeListener,
PropertyChangeListener {
    private JTabbedPane tab = null;
    private List<Widget> widgets = new ArrayList<Widget>();

    public static String getConfigureTypeName() {
        return "Tabbed Panel";
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        int index = this.tab.getSelectedIndex();
        if (index >= 0) {
            this.tab.setComponentAt(index, this.widgets.get(index).getComponent());
        }
    }

    @Override
    public void add(Buildable b) {
        if (b instanceof Widget) {
            Widget w = (Widget)b;
            this.widgets.add(w);
            if (this.tab != null) {
                this.tab.removeChangeListener(this);
                if (this.widgets.size() > 1) {
                    this.tab.addTab(w.getConfigureName(), new JPanel());
                } else {
                    this.tab.addTab(w.getConfigureName(), w.getComponent());
                }
                w.addPropertyChangeListener(this);
                this.tab.addChangeListener(this);
            }
        }
        super.add(b);
    }

    @Override
    public void remove(Buildable b) {
        if (b instanceof Widget) {
            Widget w = (Widget)b;
            if (this.tab != null) {
                this.tab.removeChangeListener(this);
                this.tab.removeTabAt(this.widgets.indexOf(w));
                w.removePropertyChangeListener(this);
                this.tab.addChangeListener(this);
            }
            this.widgets.remove(w);
        }
        super.remove(b);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("name".equals(evt.getPropertyName())) {
            Widget src = (Widget)evt.getSource();
            int index = this.widgets.indexOf(src);
            Object name = evt.getNewValue();
            this.tab.setTitleAt(index, name == null ? "" : name.toString());
        }
    }

    @Override
    public Component getComponent() {
        if (this.tab == null) {
            this.rebuild();
            this.tab = new JTabbedPane();
            for (Widget w : this.widgets) {
                w.addPropertyChangeListener(this);
                this.tab.addTab(w.getConfigureName(), new JPanel());
            }
            this.tab.addChangeListener(this);
            if (this.widgets.size() > 0) {
                this.tab.setSelectedIndex(0);
            }
            this.stateChanged(null);
        }
        return this.tab;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{"entryName"};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class};
    }

    @Override
    public void setAttribute(String name, Object value) {
        if ("entryName".equals(name)) {
            this.setConfigureName((String)value);
        }
    }

    @Override
    public String getAttributeValueString(String name) {
        if ("entryName".equals(name)) {
            return this.getConfigureName();
        }
        return null;
    }
}

