/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.Configurer;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ImageFileFilter;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OwningOpMultiResolutionImage;
import VASSAL.tools.imageop.SourceOp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class IconConfigurer
extends Configurer {
    private JPanel controls;
    private String imageName;
    private String defaultImage;
    private Icon icon;

    public IconConfigurer(String key, String name, String defaultImage) {
        super(key, name);
        this.defaultImage = defaultImage;
    }

    @Override
    public String getValueString() {
        return this.imageName;
    }

    @Override
    public void setValue(String s) {
        SourceOp sop;
        this.icon = null;
        String string = this.imageName = s == null ? "" : s;
        if (this.imageName.length() > 0 && (sop = Op.load(this.imageName)).getImage() != null) {
            this.icon = new ImageIcon(new OwningOpMultiResolutionImage(sop));
        }
        this.setValue((Object)this.imageName);
    }

    public Icon getIconValue() {
        return this.icon;
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel();
            this.controls.setLayout(new BoxLayout(this.controls, 0));
            this.controls.add(new JLabel(this.getName()));
            final JPanel p = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public void paint(Graphics g) {
                    g.clearRect(0, 0, this.getSize().width, this.getSize().height);
                    Icon i = IconConfigurer.this.getIconValue();
                    if (i != null) {
                        i.paintIcon(this, g, this.getSize().width / 2 - i.getIconWidth() / 2, this.getSize().height / 2 - i.getIconHeight() / 2);
                    }
                }
            };
            p.setPreferredSize(new Dimension(32, 32));
            this.controls.add(p);
            JButton reset = new JButton("Select");
            reset.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    IconConfigurer.this.selectImage();
                    p.repaint();
                }
            });
            this.controls.add(reset);
            if (this.defaultImage != null) {
                JButton useDefault = new JButton("Default");
                useDefault.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        IconConfigurer.this.setValue(IconConfigurer.this.defaultImage);
                        p.repaint();
                    }
                });
                this.controls.add(useDefault);
            }
        }
        return this.controls;
    }

    private void selectImage() {
        FileChooser fc = GameModule.getGameModule().getFileChooser();
        fc.setFileFilter(new ImageFileFilter());
        if (fc.showOpenDialog(this.getControls()) != 0) {
            this.setValue(null);
        } else {
            File f = fc.getSelectedFile();
            if (f != null && f.exists()) {
                GameModule.getGameModule().getArchiveWriter().addImage(f.getPath(), f.getName());
                this.setValue(f.getName());
            }
        }
    }
}

