/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Hideable;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.Obscurable;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.PropertyExporter;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.KeyStroke;

public class ActionButton
extends Decorator
implements EditablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "button;";
    protected NamedKeyStroke stroke;
    protected Rectangle bounds = new Rectangle();
    protected ButtonPusher pusher;
    protected String description = "";
    protected static ButtonPusher globalPusher = new ButtonPusher();

    public ActionButton() {
        this(ID, null);
    }

    public ActionButton(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
        this.pusher = globalPusher;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.stroke).append(this.bounds.x).append(this.bounds.y).append(this.bounds.width).append(this.bounds.height).append(this.description);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public void setMap(Map m) {
        this.pusher.register(m);
        this.piece.setMap(m);
    }

    @Override
    public String getDescription() {
        return this.description.length() == 0 ? "Action Button" : "Action Button - " + this.description;
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.stroke = st.nextNamedKeyStroke('A');
        this.bounds.x = st.nextInt(-20);
        this.bounds.y = st.nextInt(-20);
        this.bounds.width = st.nextInt(40);
        this.bounds.height = st.nextInt(40);
        this.description = st.nextToken("");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ActionButton.htm");
    }

    @Override
    public String getComponentName() {
        return this.piece.getName();
    }

    @Override
    public String getComponentTypeName() {
        return this.getDescription();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    protected static class ButtonPusher {
        private Set<Map> maps = new HashSet<Map>();
        private java.util.Map<Component, ComponentMouseListener> componentMouseListeners = new HashMap<Component, ComponentMouseListener>();

        protected ButtonPusher() {
        }

        public void register(Map map) {
            if (map != null && !this.maps.contains(map)) {
                map.addLocalMouseListener(new MapMouseListener(map));
                this.maps.add(map);
            }
        }

        @Deprecated(since="2020-10-26", forRemoval=true)
        public void register(Component obs, GamePiece piece, int x, int y) {
            if (obs != null) {
                ComponentMouseListener l = this.componentMouseListeners.get(obs);
                if (l == null) {
                    l = new ComponentMouseListener(piece, x, y);
                    obs.addMouseListener(l);
                    this.componentMouseListeners.put(obs, l);
                } else {
                    l.xOffset = x;
                    l.yOffset = y;
                    l.target = piece;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doClick(GamePiece p, Point point) {
            GamePiece piece = p;
            while (piece instanceof Decorator) {
                if (piece instanceof Obscurable ? ((Obscurable)piece).obscuredToMe() : piece instanceof Hideable && ((Hideable)piece).invisibleToMe()) {
                    return;
                }
                if (piece instanceof ActionButton) {
                    ActionButton action = (ActionButton)piece;
                    if (action.stroke != null && action.stroke.getKeyStroke() != null && action.bounds.contains(point)) {
                        p.setProperty("snapshot", ((PropertyExporter)((Object)p)).getProperties());
                        try {
                            RecursionLimiter.startExecution(action);
                            Command command = p.keyEvent(action.stroke.getKeyStroke());
                            GameModule.getGameModule().sendAndLog(command);
                        }
                        catch (RecursionLimitException e) {
                            RecursionLimiter.infiniteLoop(e);
                        }
                        finally {
                            RecursionLimiter.endExecution();
                        }
                    }
                }
                piece = ((Decorator)piece).getInner();
            }
        }

        protected class MapMouseListener
        extends MouseAdapter {
            private Map map;

            public MapMouseListener(Map map) {
                this.map = map;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Point point;
                GamePiece p;
                if (SwingUtils.isMainMouseButtonDown(e) && (p = this.map.findPiece(point = e.getPoint(), PieceFinder.PIECE_IN_STACK)) != null) {
                    Point rel = this.map.positionOf(p);
                    point.translate(-rel.x, -rel.y);
                    ButtonPusher.this.doClick(p, point);
                }
            }
        }

        @Deprecated(since="2020-10-26", forRemoval=true)
        protected class ComponentMouseListener
        extends MouseAdapter {
            private GamePiece target;
            private int xOffset;
            private int yOffset;

            public ComponentMouseListener(GamePiece piece, int x, int y) {
                this.target = piece;
                this.xOffset = x;
                this.yOffset = y;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtils.isMainMouseButtonDown(e)) {
                    Point point = e.getPoint();
                    point.translate(-this.xOffset, -this.yOffset);
                    ButtonPusher.this.doClick(this.target, point);
                    e.getComponent().repaint();
                }
            }
        }
    }

    public static class Ed
    implements PieceEditor {
        private Box box = Box.createVerticalBox();
        private IntConfigurer xConfig;
        private IntConfigurer yConfig;
        private IntConfigurer widthConfig;
        private IntConfigurer heightConfig;
        private NamedHotKeyConfigurer strokeConfig;
        protected StringConfigurer descConfig;

        public Ed(ActionButton p) {
            this.descConfig = new StringConfigurer(null, "Description:  ", p.description);
            this.box.add(this.descConfig.getControls());
            this.strokeConfig = new NamedHotKeyConfigurer(null, "Invoke Key Command:  ", p.stroke);
            this.box.add(this.strokeConfig.getControls());
            this.xConfig = new IntConfigurer(null, "Button X-offset:  ", (Integer)p.bounds.x);
            this.box.add(this.xConfig.getControls());
            this.yConfig = new IntConfigurer(null, "Button Y-offset:  ", (Integer)p.bounds.y);
            this.box.add(this.yConfig.getControls());
            this.widthConfig = new IntConfigurer(null, "Button Width:  ", (Integer)p.bounds.width);
            this.box.add(this.widthConfig.getControls());
            this.heightConfig = new IntConfigurer(null, "Button Height:  ", (Integer)p.bounds.height);
            this.box.add(this.heightConfig.getControls());
        }

        @Override
        public Component getControls() {
            return this.box;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.strokeConfig.getValueString()).append(this.xConfig.getValueString()).append(this.yConfig.getValueString()).append(this.widthConfig.getValueString()).append(this.heightConfig.getValueString()).append(this.descConfig.getValueString());
            return ActionButton.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

