/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.counters.BoundsTracker;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.Stack;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import javax.swing.KeyStroke;

public class GlobalCommand {
    protected KeyStroke keyStroke;
    protected boolean reportSingle;
    protected int selectFromDeck = -1;
    protected FormattedString reportFormat = new FormattedString();
    protected RecursionLimiter.Loopable owner;
    protected PropertySource source;

    public GlobalCommand(RecursionLimiter.Loopable l) {
        this(l, null);
    }

    public GlobalCommand(RecursionLimiter.Loopable l, PropertySource p) {
        this.owner = l;
        this.source = p;
    }

    public void setPropertySource(PropertySource ps) {
        this.source = ps;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
    }

    public void setKeyStroke(NamedKeyStroke keyStroke) {
        this.keyStroke = keyStroke.getKeyStroke();
    }

    public void setReportFormat(String format) {
        this.reportFormat.setFormat(format);
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public String getReportFormat() {
        return this.reportFormat.getFormat();
    }

    public boolean isReportSingle() {
        return this.reportSingle;
    }

    public void setReportSingle(boolean reportSingle) {
        this.reportSingle = reportSingle;
    }

    public Command apply(Map m, PieceFilter filter) {
        return this.apply(new Map[]{m}, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command apply(Map[] m, PieceFilter filter) {
        Command c = new NullCommand();
        try {
            if (this.reportSingle) {
                Map.setChangeReportingEnabled(false);
            }
            RecursionLimiter.startExecution(this.owner);
            String reportText = this.reportFormat.getLocalizedText(this.source);
            if (reportText.length() > 0) {
                c = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "*" + reportText);
                c.execute();
            }
            for (Map map : m) {
                GamePiece[] p;
                Visitor visitor = new Visitor(c, filter, this.keyStroke);
                DeckVisitorDispatcher dispatcher = new DeckVisitorDispatcher(visitor);
                for (GamePiece gamePiece : p = map.getPieces()) {
                    dispatcher.accept(gamePiece);
                }
                visitor.getTracker().repaint();
                c = visitor.getCommand();
            }
        }
        catch (RecursionLimitException e) {
            RecursionLimiter.infiniteLoop(e);
        }
        finally {
            RecursionLimiter.endExecution();
            if (this.reportSingle) {
                Map.setChangeReportingEnabled(true);
            }
        }
        return c;
    }

    public int getSelectFromDeck() {
        return this.selectFromDeck;
    }

    public void setSelectFromDeck(int selectFromDeck) {
        this.selectFromDeck = selectFromDeck;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.keyStroke == null ? 0 : this.keyStroke.hashCode());
        result = 31 * result + (this.reportFormat == null ? 0 : this.reportFormat.hashCode());
        result = 31 * result + (this.reportSingle ? 1231 : 1237);
        result = 31 * result + this.selectFromDeck;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GlobalCommand other = (GlobalCommand)obj;
        if (this.keyStroke == null ? other.keyStroke != null : !this.keyStroke.equals(other.keyStroke)) {
            return false;
        }
        if (this.reportFormat == null ? other.reportFormat != null : !this.reportFormat.equals(other.reportFormat)) {
            return false;
        }
        if (this.reportSingle != other.reportSingle) {
            return false;
        }
        return this.selectFromDeck == other.selectFromDeck;
    }

    protected class Visitor
    implements DeckVisitor {
        private Command command;
        private BoundsTracker tracker;
        private PieceFilter filter;
        private KeyStroke stroke;
        private int selectedCount;

        public Visitor(Command command, PieceFilter filter, KeyStroke stroke) {
            this.command = command;
            this.tracker = new BoundsTracker();
            this.filter = filter;
            this.stroke = stroke;
        }

        @Override
        public Object visitDeck(Deck d) {
            Object target = null;
            if (GlobalCommand.this.getSelectFromDeck() != 0) {
                d.setDragCount(d.getPieceCount());
                this.selectedCount = 0;
                PieceIterator it = d.drawCards();
                while (it.hasMoreElements() && (GlobalCommand.this.getSelectFromDeck() < 0 || GlobalCommand.this.getSelectFromDeck() > this.selectedCount)) {
                    this.apply(it.nextPiece(), true);
                }
            }
            return target;
        }

        @Override
        public Object visitStack(Stack s) {
            s.asList().forEach(this::apply);
            return null;
        }

        @Override
        public Object visitDefault(GamePiece p) {
            this.apply(p);
            return null;
        }

        private void apply(GamePiece p) {
            this.apply(p, false);
        }

        private void apply(GamePiece p, boolean visitingDeck) {
            if (this.filter == null || this.filter.accept(p)) {
                if (visitingDeck) {
                    p.setProperty("obs;", p.getProperty("ObscuredPreDraw"));
                }
                this.tracker.addPiece(p);
                p.setProperty("snapshot", ((PropertyExporter)((Object)p)).getProperties());
                this.command.append(p.keyEvent(this.stroke));
                this.tracker.addPiece(p);
                ++this.selectedCount;
            } else if (visitingDeck) {
                p.setProperty("obs;", p.getProperty("ObscuredPreDraw"));
            }
        }

        public Command getCommand() {
            return this.command;
        }

        public BoundsTracker getTracker() {
            return this.tracker;
        }
    }
}

