/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceFilter;
import VASSAL.tools.ProblemDialog;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Predicate;

public class PieceIterator {
    private final Iterator<? extends GamePiece> pi;
    private PieceFilter filter;
    public static final Predicate<GamePiece> VISIBLE = gamePiece -> !Boolean.TRUE.equals(gamePiece.getProperty("Invisible"));

    public PieceIterator(Iterator<? extends GamePiece> i) {
        this.pi = i;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public <T extends GamePiece> PieceIterator(Enumeration<T> e) {
        this(e.asIterator());
        ProblemDialog.showDeprecated("2020-08-06");
    }

    public PieceIterator(final Iterator<? extends GamePiece> i, PieceFilter f) {
        this.filter = f;
        this.pi = new Iterator<GamePiece>(){
            private GamePiece next;

            @Override
            public boolean hasNext() {
                if (this.next != null) {
                    return true;
                }
                while (i.hasNext()) {
                    this.next = (GamePiece)i.next();
                    if (PieceIterator.this.filter != null && !PieceIterator.this.filter.accept(this.next)) continue;
                    return true;
                }
                this.next = null;
                return false;
            }

            @Override
            public GamePiece next() {
                if (this.next != null) {
                    GamePiece ret = this.next;
                    this.next = null;
                    return ret;
                }
                while (true) {
                    if (PieceIterator.this.filter == null || PieceIterator.this.filter.accept(this.next)) {
                        GamePiece ret = this.next;
                        this.next = null;
                        return ret;
                    }
                    this.next = (GamePiece)i.next();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Deprecated
    public <T extends GamePiece> PieceIterator(Enumeration<T> e, PieceFilter f) {
        this(e.asIterator(), f);
    }

    public GamePiece nextPiece() {
        return this.pi.hasNext() ? this.pi.next() : null;
    }

    public boolean hasMoreElements() {
        return this.pi.hasNext();
    }

    public static <T extends GamePiece> PieceIterator visible(Iterator<T> i) {
        return new PieceIterator(i, VISIBLE::test);
    }

    @Deprecated
    public static <T extends GamePiece> PieceIterator visible(Enumeration<T> e) {
        return PieceIterator.visible(e.asIterator());
    }
}

