/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.MutablePropertiesContainer;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.ListConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.DynamicProperty;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;

public class SetGlobalProperty
extends DynamicProperty {
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    public static final String ID = "setprop;";
    public static final String CURRENT_ZONE = "Current Zone/Current Map/Module";
    public static final String NAMED_ZONE = "Named Zone";
    public static final String NAMED_MAP = "Named Map";
    protected String description;
    protected String propertyLevel;
    protected String searchName;
    protected Decorator dec;

    public SetGlobalProperty() {
        this(ID, null);
    }

    public SetGlobalProperty(String type, GamePiece p) {
        super(type, p);
    }

    @Override
    public String getDescription() {
        Object s = "Set Global Property";
        if (this.description.length() > 0) {
            s = (String)s + " - " + this.description;
        }
        return s;
    }

    @Override
    public void mySetType(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, ';');
        sd.nextToken();
        this.key = sd.nextToken("name");
        this.decodeConstraints(sd.nextToken(""));
        this.keyCommandListConfig.setValue(sd.nextToken(""));
        this.keyCommands = this.keyCommandListConfig.getListValue().toArray(new DynamicProperty.DynamicKeyCommand[0]);
        this.menuCommands = (KeyCommand[])Arrays.stream(this.keyCommands).filter(kc -> !StringUtils.isEmpty((CharSequence)kc.getName())).toArray(KeyCommand[]::new);
        this.description = sd.nextToken("");
        this.propertyLevel = sd.nextToken(CURRENT_ZONE);
        this.searchName = sd.nextToken("");
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.key);
        se.append(this.encodeConstraints());
        se.append(this.keyCommandListConfig.getValueString());
        se.append(this.description);
        se.append(this.propertyLevel);
        se.append(this.searchName);
        return ID + se.getValue();
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public void mySetState(String state) {
    }

    @Override
    public Object getProperty(Object key) {
        if ("KeyCommands".equals(key)) {
            return this.getKeyCommands();
        }
        if ("Inner".equals(key)) {
            return this.piece;
        }
        if ("Outer".equals(key)) {
            return this.dec;
        }
        if ("visibleState".equals(key)) {
            return this.myGetState() + this.piece.getProperty(key);
        }
        return this.piece.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ("KeyCommands".equals(key)) {
            return this.getProperty(key);
        }
        if ("Inner".equals(key)) {
            return this.getProperty(key);
        }
        if ("Outer".equals(key)) {
            return this.getProperty(key);
        }
        if ("visibleState".equals(key)) {
            return this.getProperty(key);
        }
        return this.piece.getLocalizedProperty(key);
    }

    @Override
    public void setProperty(Object key, Object val) {
        if ("Inner".equals(key)) {
            this.setInner((GamePiece)val);
        } else if ("Outer".equals(key)) {
            this.dec = (Decorator)val;
        } else {
            this.piece.setProperty(key, val);
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SetGlobalProperty.htm");
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        Command comm = new NullCommand();
        for (DynamicProperty.DynamicKeyCommand keyCommand : this.keyCommands) {
            if (!keyCommand.matches(stroke)) continue;
            MutableProperty prop = null;
            String propertyName = new FormattedString(this.key).getText(Decorator.getOutermost(this));
            ArrayList<MutablePropertiesContainer> propertyContainers = new ArrayList<MutablePropertiesContainer>();
            propertyContainers.add(0, GameModule.getGameModule());
            Map map = this.getMap();
            if (NAMED_MAP.equals(this.propertyLevel)) {
                String mapName = new FormattedString(this.searchName).getText(Decorator.getOutermost(this));
                map = Map.getMapById(mapName);
            }
            if (map != null) {
                propertyContainers.add(0, map);
            }
            Zone z = null;
            if (CURRENT_ZONE.equals(this.propertyLevel) && this.getMap() != null) {
                z = this.getMap().findZone(this.getPosition());
            } else if (NAMED_ZONE.equals(this.propertyLevel) && this.getMap() != null) {
                String zoneName = new FormattedString(this.searchName).getText(Decorator.getOutermost(this));
                z = this.getMap().findZone(zoneName);
            }
            if (z != null) {
                propertyContainers.add(0, z);
            }
            if ((prop = MutableProperty.Util.findMutableProperty(propertyName, propertyContainers)) == null) {
                String message = "Unable to locate Global Property in " + this.propertyLevel + ".";
                String data = "Property Expression=[" + this.key + "], Property Name=" + propertyName + "].";
                ErrorDialog.dataWarning(new BadDataReport(this, message, data));
                continue;
            }
            String oldValue = prop.getPropertyValue();
            String newValue = keyCommand.propChanger.getNewValue(oldValue);
            this.format.setFormat(newValue);
            newValue = this.format.getText(Decorator.getOutermost(this));
            comm = prop.setPropertyValue(newValue);
        }
        return comm;
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    protected static class Ed
    implements PieceEditor {
        protected StringConfigurer descConfig;
        protected FormattedExpressionConfigurer nameConfig;
        protected BooleanConfigurer numericConfig;
        protected IntConfigurer minConfig;
        protected IntConfigurer maxConfig;
        protected BooleanConfigurer wrapConfig;
        protected ListConfigurer keyCommandListConfig;
        protected StringEnumConfigurer levelConfig;
        protected FormattedExpressionConfigurer searchNameConfig;
        protected JLabel mapLabel = new JLabel("map");
        protected JLabel zoneLabel = new JLabel("zone");
        protected Box controls;
        protected Box nameBox;

        public Ed(final SetGlobalProperty m) {
            this.keyCommandListConfig = new ListConfigurer(null, "Key Commands"){

                @Override
                protected Configurer buildChildConfigurer() {
                    return new DynamicProperty.DynamicKeyCommandConfigurer(m);
                }
            };
            this.keyCommandListConfig.setValue(new ArrayList<DynamicProperty.DynamicKeyCommand>(Arrays.asList(m.keyCommands)));
            PropertyChangeListener l = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    boolean isNumeric = numericConfig.booleanValue();
                    minConfig.getControls().setVisible(isNumeric);
                    maxConfig.getControls().setVisible(isNumeric);
                    wrapConfig.getControls().setVisible(isNumeric);
                    keyCommandListConfig.repack();
                }
            };
            this.controls = Box.createVerticalBox();
            this.descConfig = new StringConfigurer(null, "Description:  ", m.description);
            this.controls.add(this.descConfig.getControls());
            this.nameConfig = new FormattedExpressionConfigurer(null, "Global Property Name:  ", m.getKey(), m);
            this.controls.add(this.nameConfig.getControls());
            this.levelConfig = new StringEnumConfigurer(null, "", new String[]{SetGlobalProperty.CURRENT_ZONE, SetGlobalProperty.NAMED_ZONE, SetGlobalProperty.NAMED_MAP});
            this.levelConfig.setValue(m.propertyLevel);
            this.levelConfig.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    this.updateVisibility();
                }
            });
            Box box = Box.createHorizontalBox();
            box.add(new JLabel("Locate Property starting in the:   "));
            box.add(this.levelConfig.getControls());
            this.controls.add(box);
            this.nameBox = Box.createHorizontalBox();
            this.nameBox.add(new JLabel("Name of "));
            this.nameBox.add(this.mapLabel);
            this.nameBox.add(this.zoneLabel);
            this.nameBox.add(new JLabel(" containing property:  "));
            this.searchNameConfig = new FormattedExpressionConfigurer(null, "", m.searchName, m);
            this.nameBox.add(this.searchNameConfig.getControls());
            this.controls.add(this.nameBox);
            this.numericConfig = new BooleanConfigurer(null, "Is numeric?", m.isNumeric());
            this.controls.add(this.numericConfig.getControls());
            this.minConfig = new IntConfigurer(null, "Minimum value:  ", (Integer)m.getMinimumValue());
            this.controls.add(this.minConfig.getControls());
            this.maxConfig = new IntConfigurer(null, "Maximum value:  ", (Integer)m.getMaximumValue());
            this.controls.add(this.maxConfig.getControls());
            this.wrapConfig = new BooleanConfigurer(null, "Wrap?", m.isWrap());
            this.controls.add(this.wrapConfig.getControls());
            this.controls.add(this.keyCommandListConfig.getControls());
            this.numericConfig.addPropertyChangeListener(l);
            this.numericConfig.fireUpdate();
            this.updateVisibility();
        }

        protected void updateVisibility() {
            this.mapLabel.setVisible(this.levelConfig.getValueString().equals(SetGlobalProperty.NAMED_MAP));
            this.zoneLabel.setVisible(this.levelConfig.getValueString().equals(SetGlobalProperty.NAMED_ZONE));
            this.nameBox.setVisible(!this.levelConfig.getValueString().equals(SetGlobalProperty.CURRENT_ZONE));
            Window w = SwingUtilities.getWindowAncestor(this.controls);
            if (w != null) {
                w.pack();
            }
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        protected String encodeConstraints() {
            return new SequenceEncoder(',').append(this.numericConfig.getValueString()).append(this.minConfig.getValueString()).append(this.maxConfig.getValueString()).append(this.wrapConfig.getValueString()).getValue();
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameConfig.getValueString());
            se.append(this.encodeConstraints());
            se.append(this.keyCommandListConfig.getValueString());
            se.append(this.descConfig.getValueString());
            se.append(this.levelConfig.getValueString());
            se.append(this.searchNameConfig.getValueString());
            return SetGlobalProperty.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

