/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script;

import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TextConfigurer;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;
import VASSAL.script.AbstractScript;
import VASSAL.script.BeanShell;
import VASSAL.script.CompileResult;
import VASSAL.script.JavaNameConfigurer;
import VASSAL.tools.UniqueIdManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ActionScript
extends AbstractScript
implements UniqueIdManager.Identifyable,
ValidityChecker {
    private static UniqueIdManager idMgr = new UniqueIdManager("Action-");

    public static String getConfigureTypeName() {
        return "Action Script";
    }

    public String evaluate(PropertySource target) {
        return "";
    }

    @Override
    public String getId() {
        return null;
    }

    @Override
    public void setId(String id) {
    }

    protected String buildHeaderLine() {
        return "void " + this.getConfigureName() + "() {";
    }

    public String getFullScript() {
        return this.buildHeaderLine() + "\n" + this.getScript() + "\n}";
    }

    @Override
    public CompileResult compile() {
        String fullScript = this.getFullScript();
        return BeanShell.getInstance().compile(new StringReader(fullScript));
    }

    @Override
    public Configurer getConfigurer() {
        return new ScriptConfigurer(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Script.htm");
    }

    @Override
    public void removeFrom(Buildable parent) {
        idMgr.remove(this);
    }

    @Override
    public void addTo(Buildable parent) {
        idMgr.add(this);
    }

    @Override
    public void validate(Buildable target, ValidationReport report) {
        idMgr.validate(this, report);
    }

    class ScriptConfigurer
    extends Configurer
    implements ActionListener {
        protected ActionScript script;
        protected JPanel panel;
        protected JavaNameConfigurer nameConfig;
        protected StringConfigurer descConfig;
        protected TextConfigurer scriptConfig;
        protected JButton compileButton;
        protected JLabel error;
        protected JLabel headerLine;

        public ScriptConfigurer(ActionScript s) {
            super(null, s.getConfigureName());
            this.error = new JLabel();
            this.headerLine = new JLabel();
            this.script = s;
            this.setValue(this.script);
            this.script.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    if ("name".equals(evt.getPropertyName())) {
                        ScriptConfigurer.this.setName((String)evt.getNewValue());
                    }
                }
            });
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.setPreferredSize(new Dimension(800, 600));
            this.nameConfig = new JavaNameConfigurer("name", "Name:  ", this.script.getConfigureName());
            this.nameConfig.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    ScriptConfigurer.this.script.setAttribute("name", e.getNewValue());
                    ScriptConfigurer.this.updateHeader();
                }
            });
            this.descConfig = new StringConfigurer("desc", "Description:  ", this.script.getDescription());
            this.descConfig.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    ScriptConfigurer.this.script.setAttribute("desc", e.getNewValue());
                }
            });
            this.headerLine.setText(ActionScript.this.buildHeaderLine());
            this.scriptConfig = new TextConfigurer("script", "Script:  ", this.script.getScript());
            this.scriptConfig.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    ScriptConfigurer.this.script.setAttribute("script", e.getNewValue());
                }
            });
            this.panel.add(this.nameConfig.getControls());
            this.panel.add(this.descConfig.getControls());
            this.panel.add(this.headerLine);
            this.panel.add(this.scriptConfig.getControls());
            Box compileBox = Box.createHorizontalBox();
            this.compileButton = new JButton("Compile");
            this.compileButton.addActionListener(this);
            compileBox.add(this.compileButton);
            compileBox.add(this.error);
            this.panel.add(compileBox);
        }

        public void updateHeader() {
            this.headerLine.setText(ActionScript.this.buildHeaderLine());
        }

        public ActionScript getScript() {
            return this.script;
        }

        @Override
        public Component getControls() {
            return this.panel;
        }

        @Override
        public String getValueString() {
            return this.script.getConfigureName();
        }

        @Override
        public void setValue(String s) {
            throw new RuntimeException("Can't set ScriptConfigurable from String");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CompileResult r = this.script.compile();
            if (r.isSuccess()) {
                this.error.setText("");
            } else {
                this.error.setText(r.getMessage());
            }
        }
    }
}

