/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.script.expression;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.BeanShellExpressionConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.counters.EditablePiece;
import VASSAL.script.expression.Expression;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.ButtonFactory;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ExpressionBuilder
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected BeanShellExpressionConfigurer expression;
    protected String save;
    protected Configurer target;
    protected EditablePiece pieceTarget;

    public ExpressionBuilder(Configurer c, JDialog parent) {
        this(c, parent, null);
    }

    public ExpressionBuilder(Configurer c, JDialog parent, EditablePiece piece) {
        super(parent, "Expression Builder", true);
        this.target = c;
        this.pieceTarget = piece;
        this.save = this.target.getValueString();
        JPanel p = new JPanel((LayoutManager)new MigLayout("wrap 1,fill"));
        String value = this.target.getValueString();
        if (value.startsWith("{") && value.endsWith("}")) {
            this.setExpression(value.substring(1, value.length() - 1));
        } else {
            this.setExpression(this.convert(value));
        }
        p.add(this.expression.getControls(), "growx");
        JPanel buttonBox = new JPanel((LayoutManager)new MigLayout("", "[]rel[]rel[]"));
        JButton okButton = ButtonFactory.getOkButton();
        okButton.addActionListener(e -> this.save());
        buttonBox.add(okButton);
        JButton cancelButton = ButtonFactory.getCancelButton();
        cancelButton.addActionListener(e -> this.cancel());
        buttonBox.add(cancelButton);
        JButton helpButton = ButtonFactory.getHelpButton();
        helpButton.addActionListener(e -> BrowserSupport.openURL(HelpFile.getReferenceManualPage("ExpressionBuilder.htm").getContents().toString()));
        buttonBox.add(helpButton);
        p.add((Component)buttonBox, "align center");
        this.add(p);
        this.pack();
        this.setLocationRelativeTo(this.getParent());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ExpressionBuilder.this.cancel();
            }
        });
    }

    public void save() {
        String expr = this.expression.getValueString().trim();
        if (expr.startsWith("{") && expr.endsWith("}")) {
            this.target.setValue(expr);
        } else {
            this.target.setValue("{" + expr + "}");
        }
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public String convert(String s) {
        return Expression.createExpression(s).toBeanShellString();
    }

    public void setExpression(String value) {
        if (this.expression == null) {
            String prompt = this.target.getName().length() == 0 ? "Expression:  " : this.target.getName();
            this.expression = new BeanShellExpressionConfigurer(null, prompt, value, this.pieceTarget);
        }
        this.expression.setValue(value);
    }

    public String getExpression() {
        return this.expression == null ? "" : this.expression.getValueString();
    }
}

