/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image;

import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class LabelUtils {
    public static final int CENTER = 0;
    public static final int RIGHT = 1;
    public static final int LEFT = 2;
    public static final int TOP = 3;
    public static final int BOTTOM = 4;

    private LabelUtils() {
    }

    public static void drawLabel(Graphics g, String text, int x, int y, int hAlign, int vAlign, Color fgColor, Color bgColor) {
        LabelUtils.drawLabel(g, text, x, y, new Font("Dialog", 0, 10), hAlign, vAlign, fgColor, bgColor, null);
    }

    public static void drawLabel(Graphics g, String text, int x, int y, Font f, int hAlign, int vAlign, Color fgColor, Color bgColor, Color borderColor) {
        ((Graphics2D)g).addRenderingHints(SwingUtils.FONT_HINTS);
        ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(f);
        int width = g.getFontMetrics().stringWidth(text + "  ");
        int height = g.getFontMetrics().getHeight();
        int x0 = x;
        int y0 = y;
        switch (hAlign) {
            case 0: {
                x0 = x - width / 2;
                break;
            }
            case 2: {
                x0 = x - width;
            }
        }
        switch (vAlign) {
            case 0: {
                y0 = y - height / 2;
                break;
            }
            case 4: {
                y0 = y - height;
            }
        }
        if (bgColor != null) {
            g.setColor(bgColor);
            g.fillRect(x0, y0, width, height);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawRect(x0, y0, width, height);
        }
        g.setColor(fgColor);
        g.drawString(" " + text + " ", x0, y0 + g.getFontMetrics().getHeight() - g.getFontMetrics().getDescent());
    }
}

