/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.build.module.BasicLogger;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GameSetupStep;
import VASSAL.build.module.Map;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.MetaDataFactory;
import VASSAL.build.module.metadata.SaveMetaData;
import VASSAL.command.AddPiece;
import VASSAL.command.AlertCommand;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.CommandFilter;
import VASSAL.command.ConditionalCommand;
import VASSAL.command.NullCommand;
import VASSAL.configure.DirectoryConfigurer;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.Resources;
import VASSAL.launch.Launcher;
import VASSAL.launch.PlayerWindow;
import VASSAL.tools.ComponentSplitter;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.WarningDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.LogAndSaveFileFilter;
import VASSAL.tools.io.DeobfuscatingInputStream;
import VASSAL.tools.io.IOUtils;
import VASSAL.tools.io.ObfuscatingOutputStream;
import VASSAL.tools.io.ZipArchive;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.Dialogs;
import VASSAL.tools.version.VersionUtils;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GameState
implements CommandEncoder {
    private static final Logger log = LoggerFactory.getLogger(GameState.class);
    protected java.util.Map<String, GamePiece> pieces = new HashMap<String, GamePiece>();
    protected List<GameComponent> gameComponents = new ArrayList<GameComponent>();
    protected List<GameSetupStep> setupSteps = new ArrayList<GameSetupStep>();
    protected Action loadGame;
    protected Action saveGame;
    protected Action saveGameAs;
    protected Action newGame;
    protected Action closeGame;
    protected String lastSave;
    protected File lastSaveFile = null;
    protected DirectoryConfigurer savedGameDirectoryPreference;
    protected String loadComments;
    private boolean gameStarting = false;
    private boolean gameStarted = false;
    private volatile boolean gameUpdating = false;
    public static final String SAVEFILE_ZIP_ENTRY = "savedGame";
    public static final String BEGIN_SAVE = "begin_save";
    public static final String END_SAVE = "end_save";

    public void addTo(GameModule mod) {
        this.loadGame = new AbstractAction(Resources.getString("GameState.load_game")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GameState.this.loadGame();
            }
        };
        this.loadGame.putValue("MnemonicKey", Resources.getString("GameState.load_game.shortcut").charAt(0));
        this.saveGame = new AbstractAction(Resources.getString("GameState.save_game")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GameState.this.saveGame();
            }
        };
        this.saveGame.putValue("MnemonicKey", Resources.getString("GameState.save_game.shortcut").charAt(0));
        this.saveGameAs = new AbstractAction(Resources.getString("GameState.save_game_as")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GameState.this.saveGameAs();
            }
        };
        this.saveGameAs.putValue("MnemonicKey", Resources.getString("GameState.save_game_as.shortcut").charAt(0));
        this.newGame = new AbstractAction(Resources.getString("GameState.new_game")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GameState.this.setup(false);
                GameState.this.setup(true);
            }
        };
        this.newGame.putValue("MnemonicKey", Resources.getString("GameState.new_game.shortcut").charAt(0));
        this.closeGame = new AbstractAction(Resources.getString("GameState.close_game")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                GameState.this.setup(false);
            }
        };
        this.closeGame.putValue("MnemonicKey", Resources.getString("GameState.close_game.shortcut").charAt(0));
        MenuManager mm = MenuManager.getInstance();
        mm.addAction("GameState.new_game", this.newGame);
        mm.addAction("GameState.load_game", this.loadGame);
        mm.addAction("GameState.save_game", this.saveGame);
        mm.addAction("GameState.save_game_as", this.saveGameAs);
        mm.addAction("GameState.close_game", this.closeGame);
        this.saveGame.setEnabled(this.gameStarting);
        this.saveGameAs.setEnabled(this.gameStarting);
        this.closeGame.setEnabled(this.gameStarting);
    }

    public boolean isModified() {
        String s = this.saveString();
        return s != null && !s.equals(this.lastSave);
    }

    public void addGameComponent(GameComponent theComponent) {
        this.gameComponents.add(theComponent);
    }

    public void removeGameComponent(GameComponent theComponent) {
        this.gameComponents.remove(theComponent);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Enumeration<GameComponent> getGameComponentsEnum() {
        ProblemDialog.showDeprecated("2020-08-06");
        return Collections.enumeration(this.gameComponents);
    }

    public Collection<GameComponent> getGameComponents() {
        return Collections.unmodifiableCollection(this.gameComponents);
    }

    public void addGameSetupStep(GameSetupStep step) {
        this.setupSteps.add(step);
    }

    public void removeGameSetupStep(GameSetupStep step) {
        this.setupSteps.remove(step);
    }

    public Iterator<GameSetupStep> getUnfinishedSetupSteps() {
        ArrayList<GameSetupStep> l = new ArrayList<GameSetupStep>();
        for (GameSetupStep step : this.setupSteps) {
            if (step.isFinished()) continue;
            l.add(step);
        }
        return l.iterator();
    }

    public void setup(boolean gameStarting, boolean gameUpdating) {
        this.gameUpdating = gameUpdating;
        this.setup(gameStarting);
    }

    public void updateDone() {
        this.gameUpdating = false;
    }

    public boolean isUpdating() {
        return this.gameUpdating;
    }

    public void setup(boolean gameStarting) {
        GameModule g = GameModule.getGameModule();
        if (!gameStarting && this.gameStarted && this.isModified()) {
            switch (JOptionPane.showConfirmDialog(g.getPlayerWindow(), Resources.getString("GameState.save_game_query"), Resources.getString("GameState.game_modified"), 1)) {
                case 0: {
                    this.saveGame();
                    break;
                }
                case -1: 
                case 2: {
                    return;
                }
            }
        }
        this.gameStarting = gameStarting;
        if (!gameStarting) {
            this.pieces.clear();
        }
        this.newGame.setEnabled(!gameStarting);
        this.saveGame.setEnabled(gameStarting);
        this.saveGameAs.setEnabled(gameStarting);
        this.closeGame.setEnabled(gameStarting);
        if (gameStarting) {
            this.loadGame.putValue("Name", Resources.getString("GameState.load_continuation"));
            g.getWizardSupport().showGameSetupWizard();
        } else {
            this.loadGame.putValue("Name", Resources.getString("GameState.load_game"));
            g.appendToTitle(null);
        }
        this.gameStarted &= this.gameStarting;
        for (GameComponent gc : this.gameComponents) {
            gc.setup(this.gameStarting);
        }
        this.gameStarted |= this.gameStarting;
        this.lastSave = gameStarting ? this.saveString() : null;
        this.lastSaveFile = null;
        if (this.gameStarted) {
            this.adjustSplitter();
            if (gameStarting) {
                SwingUtilities.invokeLater(() -> {
                    VASSAL.command.Logger logger = GameModule.getGameModule().getLogger();
                    if (logger instanceof BasicLogger && !((BasicLogger)logger).isReplaying()) {
                        ((BasicLogger)logger).queryNewLogFile(true);
                    }
                });
            }
        }
    }

    private void adjustSplitter() {
        GameModule g = GameModule.getGameModule();
        for (Map m : g.getComponentsOf(Map.class)) {
            if (!m.shouldDockIntoMainWindow()) continue;
            Container c = SwingUtilities.getAncestorOfClass(ComponentSplitter.SplitPane.class, m.getView());
            if (c instanceof ComponentSplitter.SplitPane) {
                ComponentSplitter.SplitPane sp = (ComponentSplitter.SplitPane)c;
                SwingUtilities.invokeLater(() -> sp.setDividerLocation(g.getChatter().getPreferredSize().height));
            }
            return;
        }
    }

    public boolean isGameStarted() {
        return this.gameStarted;
    }

    public void loadGame() {
        GameModule g = GameModule.getGameModule();
        this.loadComments = "";
        FileChooser fc = g.getFileChooser();
        fc.addChoosableFileFilter(new LogAndSaveFileFilter());
        if (fc.showOpenDialog() != 0) {
            return;
        }
        File f = fc.getSelectedFile();
        try {
            if (!f.exists()) {
                throw new FileNotFoundException("Unable to locate " + f.getPath());
            }
            AbstractMetaData metaData = MetaDataFactory.buildMetaData(f);
            if (!(metaData instanceof SaveMetaData)) {
                WarningDialog.show("GameState.invalid_save_file", f.getPath());
                return;
            }
            SaveMetaData saveData = (SaveMetaData)metaData;
            String saveModuleVersion = "?";
            if (saveData.getModuleData() != null) {
                this.loadComments = saveData.getLocalizedDescription();
                String saveModuleName = saveData.getModuleName();
                saveModuleVersion = saveData.getModuleVersion();
                String moduleName = g.getGameName();
                String moduleVersion = g.getGameVersion();
                String message = null;
                if (!saveModuleName.equals(moduleName)) {
                    message = Resources.getString("GameState.load_module_mismatch", f.getName(), saveModuleName, moduleName);
                } else if (!saveModuleVersion.equals(moduleVersion)) {
                    message = Resources.getString("GameState.load_version_mismatch", f.getName(), saveModuleVersion, moduleVersion);
                }
                if (message != null && JOptionPane.showConfirmDialog(null, message, Resources.getString("GameState.load_mismatch"), 0, 3) != 0) {
                    g.warn(Resources.getString("GameState.cancel_load", f.getName()));
                    return;
                }
            }
            log.info("Loading save game " + f.getPath() + ", created with module version " + saveModuleVersion);
            if (this.gameStarted) {
                this.loadContinuation(f);
            } else {
                this.loadGameInBackground(f);
            }
            this.lastSaveFile = f;
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, f);
        }
    }

    protected String saveString() {
        return GameModule.getGameModule().encode(this.getRestoreCommand());
    }

    protected boolean checkForOldSaveFile(File f) {
        AbstractMetaData md;
        if (f.exists() && (md = MetaDataFactory.buildMetaData(f)) instanceof SaveMetaData && Info.hasOldFormat(md.getVassalVersion())) {
            return Dialogs.showConfirmDialog(GameModule.getGameModule().getPlayerWindow(), Resources.getString("Warning.save_will_be_updated_title"), Resources.getString("Warning.save_will_be_updated_heading"), Resources.getString("Warning.save_will_be_updated_message", f.getPath(), VersionUtils.truncateToMinorVersion(Info.getVersion())), 2, 2) != 2;
        }
        return true;
    }

    public void saveGame() {
        GameModule g = GameModule.getGameModule();
        if (this.lastSaveFile != null) {
            if (!this.checkForOldSaveFile(this.lastSaveFile)) {
                return;
            }
            try {
                this.saveGame(this.lastSaveFile);
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, this.lastSaveFile);
            }
        } else {
            this.saveGameAs();
        }
    }

    public void saveGameAs() {
        GameModule g = GameModule.getGameModule();
        File saveFile = this.getSaveFile();
        if (saveFile == null) {
            g.warn(Resources.getString("GameState.save_canceled"));
        } else {
            if (!this.checkForOldSaveFile(saveFile)) {
                return;
            }
            try {
                this.saveGame(saveFile);
                this.lastSaveFile = saveFile;
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, saveFile);
            }
        }
    }

    public void setModified(boolean modified) {
        this.lastSave = modified ? null : this.saveString();
    }

    private File getSaveFile() {
        FileChooser fc = GameModule.getGameModule().getFileChooser();
        fc.selectDotSavFile();
        fc.addChoosableFileFilter(new LogAndSaveFileFilter());
        if (fc.showSaveDialog() != 0) {
            return null;
        }
        File file = fc.getSelectedFile();
        if (file.getName().indexOf(46) == -1) {
            file = new File(file.getParent(), file.getName() + ".vsav");
        }
        return file;
    }

    public void addPiece(GamePiece p) {
        if (p.getId() == null) {
            p.setId(this.getNewPieceId());
        }
        this.pieces.put(p.getId(), p);
    }

    public GamePiece getPieceForId(String id) {
        return id == null ? null : this.pieces.get(id);
    }

    public void removePiece(String id) {
        if (id != null) {
            this.pieces.remove(id);
        }
    }

    public String getNewPieceId() {
        long time = System.currentTimeMillis();
        String id = Long.toString(time);
        while (this.pieces.get(id) != null) {
            id = Long.toString(++time);
        }
        return id;
    }

    public void loadContinuation(File f) throws IOException {
        GameModule.getGameModule().warn(Resources.getString("GameState.loading", f.getName()));
        Command c = this.decodeSavedGame(f);
        CommandFilter filter = new CommandFilter(){

            @Override
            protected boolean accept(Command c) {
                return c instanceof BasicLogger.LogCommand;
            }
        };
        c = filter.apply(c);
        if (c != null) {
            c.execute();
        }
        Object msg = Resources.getString("GameState.loaded", f.getName());
        if (this.loadComments != null && this.loadComments.length() > 0) {
            msg = (String)msg + ": " + this.loadComments;
        }
        GameModule.getGameModule().warn((String)msg);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Enumeration<GamePiece> getPieces() {
        ProblemDialog.showDeprecated("2020-08-06");
        return Collections.enumeration(this.pieces.values());
    }

    public Collection<GamePiece> getAllPieces() {
        return this.pieces.values();
    }

    public Command getRestoreCommand() {
        if (!this.saveGame.isEnabled()) {
            return null;
        }
        SetupCommand c = new SetupCommand(false);
        c.append(this.checkVersionCommand());
        c.append(this.getRestorePiecesCommand());
        for (GameComponent gc : this.gameComponents) {
            c.append(gc.getRestoreCommand());
        }
        c.append(new SetupCommand(true));
        return c;
    }

    private Command checkVersionCommand() {
        String runningVersion = GameModule.getGameModule().getAttributeValueString("runningVassalVersion");
        ConditionalCommand.Lt cond = new ConditionalCommand.Lt("runningVassalVersion", runningVersion);
        ConditionalCommand c = new ConditionalCommand(new ConditionalCommand.Condition[]{cond}, new AlertCommand(Resources.getString("GameState.version_mismatch", runningVersion)));
        String moduleName = GameModule.getGameModule().getAttributeValueString("name");
        String moduleVersion = GameModule.getGameModule().getAttributeValueString("version");
        cond = new ConditionalCommand.Lt("version", moduleVersion);
        c.append(new ConditionalCommand(new ConditionalCommand.Condition[]{cond}, new AlertCommand(Resources.getString("GameState.version_mismatch2", moduleName, moduleVersion))));
        return c;
    }

    @Override
    public String encode(Command c) {
        if (c instanceof SetupCommand) {
            return ((SetupCommand)c).isGameStarting() ? END_SAVE : BEGIN_SAVE;
        }
        return null;
    }

    @Override
    public Command decode(String theCommand) {
        if (BEGIN_SAVE.equals(theCommand)) {
            return new SetupCommand(false);
        }
        if (END_SAVE.equals(theCommand)) {
            return new SetupCommand(true);
        }
        return null;
    }

    public void saveGame(File f) throws IOException {
        GameModule.getGameModule().warn(Resources.getString("GameState.saving_game"));
        String save = this.saveString();
        try (ZipArchive archive = new ZipArchive(f);){
            try (OutputStream zout = archive.getOutputStream(SAVEFILE_ZIP_ENTRY);
                 BufferedOutputStream bout = new BufferedOutputStream(zout);
                 ObfuscatingOutputStream out = new ObfuscatingOutputStream(bout);){
                ((OutputStream)out).write(save.getBytes(StandardCharsets.UTF_8));
            }
            new SaveMetaData().save(archive);
        }
        Launcher.getInstance().sendSaveCmd(f);
        this.lastSave = save;
        GameModule.getGameModule().warn(Resources.getString("GameState.game_saved"));
    }

    public void loadGameInBackground(File f) {
        try {
            this.loadGameInBackground(f.getName(), new BufferedInputStream(new FileInputStream(f)));
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, f);
        }
    }

    public void loadGameInBackground(final String shortName, final InputStream in) {
        GameModule.getGameModule().warn(Resources.getString("GameState.loading", shortName));
        final PlayerWindow frame = GameModule.getGameModule().getPlayerWindow();
        frame.setCursor(Cursor.getPredefinedCursor(3));
        new SwingWorker<Command, Void>(){

            @Override
            public Command doInBackground() throws Exception {
                try (InputStream inputStream = in;){
                    Command command = GameState.this.decodeSavedGame(in);
                    return command;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    Command loadCommand = null;
                    Object msg = null;
                    try {
                        loadCommand = (Command)this.get();
                        if (loadCommand != null) {
                            msg = Resources.getString("GameState.loaded", shortName);
                            if (GameState.this.loadComments != null && GameState.this.loadComments.length() > 0) {
                                msg = (String)msg + ": " + GameState.this.loadComments;
                            }
                        } else {
                            msg = Resources.getString("GameState.invalid_savefile", shortName);
                        }
                    }
                    catch (InterruptedException e) {
                        ErrorDialog.bug(e);
                    }
                    catch (ExecutionException e) {
                        OutOfMemoryError oom = ThrowableUtils.getAncestor(OutOfMemoryError.class, e);
                        if (oom != null) {
                            ErrorDialog.bug(e);
                        } else {
                            log.error("", (Throwable)e);
                        }
                        msg = Resources.getString("GameState.error_loading", shortName);
                    }
                    if (loadCommand != null) {
                        loadCommand.execute();
                    }
                    GameModule.getGameModule().warn((String)msg);
                }
                finally {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        }.execute();
    }

    public Command getRestorePiecesCommand() {
        ArrayList<GamePiece> pieceList = new ArrayList<GamePiece>(this.pieces.values());
        pieceList.sort(new Comparator<GamePiece>(){
            private final java.util.Map<GamePiece, Integer> indices = new HashMap<GamePiece, Integer>();

            private int indexOf(GamePiece p, Map m) {
                Integer pi = this.indices.get(p);
                if (pi == null) {
                    pi = m.getPieceCollection().indexOf(p);
                    this.indices.put(p, pi);
                }
                return pi;
            }

            @Override
            public int compare(GamePiece a, GamePiece b) {
                Map amap = a.getMap();
                Map bmap = b.getMap();
                if (amap == null) {
                    return bmap == null ? a.getId().compareTo(b.getId()) : -1;
                }
                if (bmap == null) {
                    return 1;
                }
                if (amap == bmap) {
                    return this.indexOf(a, amap) - this.indexOf(b, bmap);
                }
                return amap.getId().compareTo(bmap.getId());
            }
        });
        NullCommand c = new NullCommand();
        for (GamePiece p : pieceList) {
            c.append(new AddPiece(p));
        }
        return c;
    }

    public Command decodeSavedGame(File saveFile) throws IOException {
        return this.decodeSavedGame(new BufferedInputStream(new FileInputStream(saveFile)));
    }

    public Command decodeSavedGame(InputStream in) throws IOException {
        try (ZipInputStream zipInput = new ZipInputStream(in);){
            ZipEntry entry = zipInput.getNextEntry();
            while (entry != null) {
                if (SAVEFILE_ZIP_ENTRY.equals(entry.getName())) {
                    try (DeobfuscatingInputStream din = new DeobfuscatingInputStream(zipInput);){
                        Command c;
                        Command command = c = GameModule.getGameModule().decode(IOUtils.toString((InputStream)din, (Charset)StandardCharsets.UTF_8));
                        return command;
                    }
                }
                entry = zipInput.getNextEntry();
            }
        }
        throw new IOException("Invalid saveFile format");
    }

    public DirectoryConfigurer getSavedGameDirectoryPreference() {
        if (this.savedGameDirectoryPreference == null) {
            this.savedGameDirectoryPreference = new DirectoryConfigurer("savedGameDir", null);
            GameModule.getGameModule().getPrefs().addOption(null, this.savedGameDirectoryPreference);
        }
        return this.savedGameDirectoryPreference;
    }

    public static class SetupCommand
    extends Command {
        private final boolean gameStarting;

        public SetupCommand(boolean gameStarting) {
            this.gameStarting = gameStarting;
        }

        public boolean isGameStarting() {
            return this.gameStarting;
        }

        @Override
        protected void executeCommand() {
            GameModule.getGameModule().getGameState().setup(this.gameStarting);
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

