/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;

public class NewGameIndicator
implements GameComponent,
CommandEncoder {
    private String command;
    private boolean isNewGame;

    public NewGameIndicator(String command) {
        this.command = command;
        GameModule.getGameModule().getGameState().addGameComponent(this);
        GameModule.getGameModule().addCommandEncoder(this);
    }

    @Override
    public Command getRestoreCommand() {
        return new MarkGameNotNew(this);
    }

    public boolean isNewGame() {
        return this.isNewGame;
    }

    @Override
    public void setup(boolean gameStarting) {
        if (!gameStarting) {
            this.isNewGame = true;
        }
    }

    @Override
    public Command decode(String command) {
        Command c = null;
        if (command.startsWith(this.command)) {
            return new MarkGameNotNew(this);
        }
        return c;
    }

    @Override
    public String encode(Command c) {
        String s = null;
        if (c instanceof MarkGameNotNew && ((MarkGameNotNew)c).indicator == this) {
            s = this.command;
        }
        return s;
    }

    public static class MarkGameNotNew
    extends Command {
        private NewGameIndicator indicator;

        public MarkGameNotNew(NewGameIndicator indicator) {
            this.indicator = indicator;
        }

        @Override
        protected void executeCommand() {
            this.indicator.isNewGame = false;
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

