/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.SpecialDiceButton;
import VASSAL.build.module.SpecialDieFace;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecialDie
extends AbstractConfigurable {
    private static final Logger logger = LoggerFactory.getLogger(SpecialDie.class);
    private List<SpecialDieFace> dieFaceList = new ArrayList<SpecialDieFace>();
    private FormattedString format = new FormattedString("$result$");
    public static final String NAME = "name";
    public static final String FORMAT = "format";
    public static final String RESULT = "result";
    public static final String NUMERICAL_VALUE = "numericalValue";

    public void addFace(SpecialDieFace f) {
        this.dieFaceList.add(f);
    }

    public void removeFace(SpecialDieFace f) {
        this.dieFaceList.remove(f);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.SpecialDie.component_type");
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.SpecialDie.result_format")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, ResultFormatConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, FORMAT};
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)o);
        } else if (FORMAT.equals(key)) {
            this.format.setFormat((String)o);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (FORMAT.equals(key)) {
            return this.format.getFormat();
        }
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GameModule.htm", "SpecialDiceButton");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{SpecialDieFace.class};
    }

    @Override
    public void addTo(Buildable parent) {
        ((SpecialDiceButton)parent).addSpecialDie(this);
    }

    @Override
    public void removeFrom(Buildable parent) {
        ((SpecialDiceButton)parent).removeSpecialDie(this);
    }

    public int getFaceCount() {
        return this.dieFaceList.size();
    }

    public String getTextValue(int face) {
        this.format.setProperty(NAME, this.getLocalizedConfigureName());
        int faceCount = this.getFaceCount();
        if (face < 0 || face >= faceCount) {
            this.format.setProperty(RESULT, "undefined");
            this.format.setProperty(NUMERICAL_VALUE, "0");
            logger.warn("Special Die (" + this.getConfigureName() + "): no such face " + face);
        } else {
            SpecialDieFace aFace = this.dieFaceList.get(face);
            this.format.setProperty(RESULT, aFace.getTextValue());
            this.format.setProperty(NUMERICAL_VALUE, "" + aFace.getIntValue());
        }
        return this.format.getLocalizedText();
    }

    public int getIntValue(int face) {
        int faceCount = this.getFaceCount();
        if (face < 0 || face >= faceCount) {
            logger.warn("Special Die (" + this.getConfigureName() + "): no such face " + face);
            return 0;
        }
        return this.dieFaceList.get(face).getIntValue();
    }

    public String getImageName(int face) {
        int faceCount = this.getFaceCount();
        if (face < 0 || face >= faceCount) {
            logger.warn("Special Die (" + this.getConfigureName() + "): no such face " + face);
            return "";
        }
        return this.dieFaceList.get(face).getImageName();
    }

    public static class ResultFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new FormattedStringConfigurer(key, name, new String[]{SpecialDie.NAME, SpecialDie.RESULT, SpecialDie.NUMERICAL_VALUE});
        }
    }
}

