/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class PieceRecenterer
extends AbstractConfigurable
implements DeckVisitor {
    public static final String BUTTON_TEXT = "text";
    public static final String ICON = "icon";
    public static final String HOTKEY = "hotkey";
    public static final String TOOLTIP = "tooltip";
    protected LaunchButton launch;
    protected Map map;
    protected DeckVisitorDispatcher dispatcher;

    public PieceRecenterer() {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GameModule.getGameModule().sendAndLog(PieceRecenterer.this.recenter(PieceRecenterer.this.map));
            }
        };
        this.launch = new LaunchButton("Recenter", TOOLTIP, BUTTON_TEXT, HOTKEY, ICON, al);
        this.dispatcher = new DeckVisitorDispatcher(this);
    }

    public Command recenter(Map map) {
        NullCommand c = new NullCommand();
        GamePiece[] pieces = map.getPieces();
        Rectangle r = new Rectangle(0, 0, -1, -1);
        for (GamePiece p : pieces) {
            if (!Boolean.TRUE.equals(this.dispatcher.accept(p))) continue;
            Point pt = p.getPosition();
            Rectangle pRect = p.getShape().getBounds();
            pRect.translate(pt.x, pt.y);
            r.add(pRect);
        }
        if (r.height >= 0 && r.width >= 0) {
            int dx = map.mapSize().width / 2 - (r.x + r.width / 2);
            int dy = map.mapSize().height / 2 - (r.y + r.height / 2);
            for (GamePiece p : pieces) {
                if (!Boolean.TRUE.equals(this.dispatcher.accept(p))) continue;
                ChangeTracker tracker = new ChangeTracker(p);
                Point pt = p.getPosition();
                pt.translate(dx, dy);
                p.setPosition(pt);
                c.append(tracker.getChangeCommand());
            }
        }
        map.repaint();
        return c;
    }

    @Override
    public Object visitDeck(Deck d) {
        return Boolean.TRUE;
    }

    @Override
    public Object visitDefault(GamePiece p) {
        return Boolean.TRUE;
    }

    @Override
    public Object visitStack(Stack s) {
        return s.getPieceCount() > 0 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.PieceRecenter.component_type");
    }

    @Override
    public void addTo(Buildable parent) {
        this.map = (Map)parent;
        this.map.getToolBar().add(this.launch);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.button_text_label"), Resources.getString("Editor.tooltip_text_label"), Resources.getString("Editor.button_icon_label"), Resources.getString("Editor.hotkey_label")};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, TOOLTIP, ICON, HOTKEY};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, IconConfig.class, NamedKeyStroke.class};
    }

    @Override
    public String getAttributeValueString(String key) {
        return this.launch.getAttributeValueString(key);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.htm", "PieceRecenterer");
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.map.getToolBar().remove(this.launch);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.launch.setAttribute(key, value);
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, "/images/recenter.gif");
        }
    }
}

