/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board.mapgrid;

import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.SwingUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Point2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.MouseInputAdapter;

public class PolygonEditor
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Polygon polygon;
    private int selected = -1;
    protected JScrollPane myScroll;

    public PolygonEditor(Polygon p) {
        this.polygon = p;
    }

    protected void reset() {
        MouseMotionListener[] mml;
        MouseListener[] ml;
        for (MouseListener i : ml = this.getMouseListeners()) {
            this.removeMouseListener(i);
        }
        for (MouseMotionListener i : mml = this.getMouseMotionListeners()) {
            this.removeMouseMotionListener(i);
        }
        if (this.polygon == null || this.polygon.npoints == 0) {
            this.setupForCreate();
        } else {
            this.setupForEdit();
        }
    }

    public Polygon getPolygon() {
        return this.polygon;
    }

    public Polygon clonePolygon() {
        return new Polygon(this.polygon.xpoints, this.polygon.ypoints, this.polygon.npoints);
    }

    public void setPolygon(Polygon polygon) {
        this.polygon = polygon;
    }

    public void setScroll(JScrollPane scroll) {
        this.myScroll = scroll;
    }

    private void setupForCreate() {
        DefineRectangle dr = new DefineRectangle();
        this.addMouseListener(dr);
    }

    private void setupForEdit() {
        ModifyPolygon mp = new ModifyPolygon();
        this.addMouseListener(mp);
        this.addMouseMotionListener(mp);
        ActionListener l = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PolygonEditor.this.selected >= 0) {
                    for (int i = PolygonEditor.this.selected; i < PolygonEditor.this.polygon.npoints - 1; ++i) {
                        PolygonEditor.this.polygon.xpoints[i] = PolygonEditor.this.polygon.xpoints[i + 1];
                        PolygonEditor.this.polygon.ypoints[i] = PolygonEditor.this.polygon.ypoints[i + 1];
                    }
                    --PolygonEditor.this.polygon.npoints;
                    PolygonEditor.this.selected = -1;
                    PolygonEditor.this.repaint();
                }
            }
        };
        this.registerKeyboardAction(l, KeyStroke.getKeyStroke(127, 0), 2);
        this.registerKeyboardAction(l, KeyStroke.getKeyStroke(8, 0), 2);
        this.requestFocus();
        this.selected = 2;
        this.repaint();
    }

    public void center(Point p) {
        Rectangle r = this.getVisibleRect();
        if (r.width == 0) {
            r.width = 600;
            r.height = 600;
        }
        int x = p.x - r.width / 2;
        int y = p.y - r.height / 2;
        if (x < 0) {
            x = 0;
        }
        if (y < 0) {
            y = 0;
        }
        this.scrollRectToVisible(new Rectangle(x, y, r.width, r.height));
    }

    public static void reset(Polygon p, String path) {
        p.reset();
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(path, ';');
        while (sd.hasMoreTokens()) {
            String s = sd.nextToken();
            SequenceEncoder.Decoder pd = new SequenceEncoder.Decoder(s, ',');
            if (!pd.hasMoreTokens()) continue;
            try {
                int x = Integer.parseInt(pd.nextToken().trim());
                if (!pd.hasMoreTokens()) continue;
                int y = Integer.parseInt(pd.nextToken().trim());
                p.addPoint(x, y);
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    public static String polygonToString(Polygon p) {
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < p.npoints; ++i) {
            s.append(Math.round(p.xpoints[i])).append(',').append(Math.round(p.ypoints[i]));
            if (i >= p.npoints - 1) continue;
            s.append(';');
        }
        return s.toString();
    }

    @Override
    public void paint(Graphics g) {
        this.paintBackground(g);
        if (this.polygon == null || this.polygon.npoints == 0) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setColor(Color.white);
        g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        g2d.fill(this.polygon);
        if (this.selected >= 0 && this.selected < this.polygon.xpoints.length) {
            g2d.setColor(Color.red);
            int x = this.polygon.xpoints[this.selected];
            int y = this.polygon.ypoints[this.selected];
            g2d.fillOval(x - 10, y - 10, 20, 20);
        }
        g2d.setComposite(AlphaComposite.SrcAtop);
        g2d.setColor(Color.black);
        g2d.setStroke(new BasicStroke(2.0f));
        g2d.drawPolygon(this.polygon);
    }

    protected void paintBackground(Graphics g) {
        super.paint(g);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.add(new PolygonEditor(null));
        f.setSize(500, 500);
        f.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        f.setVisible(true);
    }

    private class DefineRectangle
    extends MouseInputAdapter {
        private DefineRectangle() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtils.isMainMouseButtonDown(e)) {
                PolygonEditor.this.polygon = new Polygon();
                PolygonEditor.this.polygon.addPoint(e.getX(), e.getY());
                PolygonEditor.this.polygon.addPoint(e.getX(), e.getY());
                PolygonEditor.this.polygon.addPoint(e.getX(), e.getY());
                PolygonEditor.this.polygon.addPoint(e.getX(), e.getY());
                PolygonEditor.this.addMouseMotionListener(this);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtils.isMainMouseButtonDown(e)) {
                PolygonEditor.this.polygon.xpoints[1] = e.getX();
                PolygonEditor.this.polygon.xpoints[2] = e.getX();
                PolygonEditor.this.polygon.ypoints[2] = e.getY();
                PolygonEditor.this.polygon.ypoints[3] = e.getY();
                PolygonEditor.this.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtils.isMainMouseButtonDown(e)) {
                PolygonEditor.this.removeMouseListener(this);
                PolygonEditor.this.removeMouseMotionListener(this);
                PolygonEditor.this.setupForEdit();
            }
        }
    }

    private class ModifyPolygon
    extends MouseInputAdapter {
        private ModifyPolygon() {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtils.isMainMouseButtonDown(e)) {
                this.moveSelectedPoint(e);
                this.scrollAtEdge(e.getPoint(), 15);
                PolygonEditor.this.repaint();
            }
        }

        private void moveSelectedPoint(MouseEvent e) {
            if (PolygonEditor.this.selected >= 0 && PolygonEditor.this.selected < PolygonEditor.this.polygon.xpoints.length) {
                PolygonEditor.this.polygon.xpoints[PolygonEditor.this.selected] = e.getX();
                PolygonEditor.this.polygon.ypoints[PolygonEditor.this.selected] = e.getY();
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (SwingUtils.isMainMouseButtonDown(e)) {
                this.moveSelectedPoint(e);
                PolygonEditor.this.repaint();
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int i;
            if (!SwingUtils.isContextMouseButtonDown(e)) {
                return;
            }
            PolygonEditor.this.selected = -1;
            double minDist = 3.4028234663852886E38;
            boolean isVertex = false;
            int x0 = e.getX();
            int y0 = e.getY();
            for (i = 0; i < PolygonEditor.this.polygon.npoints; ++i) {
                double dist;
                int y2;
                int x2;
                int x1 = PolygonEditor.this.polygon.xpoints[i];
                int y1 = PolygonEditor.this.polygon.ypoints[i];
                if (i == PolygonEditor.this.polygon.npoints - 1) {
                    x2 = PolygonEditor.this.polygon.xpoints[0];
                    y2 = PolygonEditor.this.polygon.ypoints[0];
                } else {
                    x2 = PolygonEditor.this.polygon.xpoints[i + 1];
                    y2 = PolygonEditor.this.polygon.ypoints[i + 1];
                }
                if (y2 == y1 && x2 == x1) continue;
                double d = Point2D.distance(x1, y1, x2, y2);
                double comp = (double)((x2 - x1) * (x0 - x1) + (y2 - y1) * (y0 - y1)) / d;
                if (comp <= 0.0) {
                    dist = Point2D.distance(x1, y1, x0, y0);
                    if (!(dist < minDist)) continue;
                    isVertex = true;
                    minDist = dist;
                    PolygonEditor.this.selected = i;
                    continue;
                }
                if (comp >= d) {
                    dist = Point2D.distance(x0, y0, x2, y2);
                    if (!(dist < minDist)) continue;
                    isVertex = true;
                    minDist = dist;
                    PolygonEditor.this.selected = i + 1;
                    continue;
                }
                dist = (double)Math.abs((y2 - y1) * e.getX() - (x2 - x1) * e.getY() + x2 * y1 - y2 * x1) / Math.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1));
                if (!(dist < minDist)) continue;
                isVertex = false;
                minDist = dist;
                PolygonEditor.this.selected = i + 1;
            }
            if (!isVertex) {
                PolygonEditor.this.polygon.addPoint(e.getX(), e.getY());
                if (PolygonEditor.this.selected >= 0) {
                    for (i = PolygonEditor.this.polygon.npoints - 1; i > PolygonEditor.this.selected; --i) {
                        PolygonEditor.this.polygon.xpoints[i] = PolygonEditor.this.polygon.xpoints[i - 1];
                        PolygonEditor.this.polygon.ypoints[i] = PolygonEditor.this.polygon.ypoints[i - 1];
                    }
                    PolygonEditor.this.polygon.xpoints[PolygonEditor.this.selected] = e.getX();
                    PolygonEditor.this.polygon.ypoints[PolygonEditor.this.selected] = e.getY();
                }
            }
            PolygonEditor.this.repaint();
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (SwingUtils.isMainMouseButtonDown(e)) {
                PolygonEditor.this.selected = -1;
                double minDist = 3.4028234663852886E38;
                for (int i = 0; i < PolygonEditor.this.polygon.npoints; ++i) {
                    double dist = Point2D.distance(PolygonEditor.this.polygon.xpoints[i], PolygonEditor.this.polygon.ypoints[i], e.getX(), e.getY());
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    PolygonEditor.this.selected = i;
                }
                PolygonEditor.this.repaint();
            }
        }

        public void scrollAtEdge(Point evtPt, int dist) {
            Point p = new Point(evtPt.x - PolygonEditor.this.myScroll.getViewport().getViewPosition().x, evtPt.y - PolygonEditor.this.myScroll.getViewport().getViewPosition().y);
            int dx = 0;
            int dy = 0;
            if (p.x < dist && p.x >= 0) {
                dx = -1;
            }
            if (p.x >= PolygonEditor.this.myScroll.getViewport().getSize().width - dist && p.x < PolygonEditor.this.myScroll.getViewport().getSize().width) {
                dx = 1;
            }
            if (p.y < dist && p.y >= 0) {
                dy = -1;
            }
            if (p.y >= PolygonEditor.this.myScroll.getViewport().getSize().height - dist && p.y < PolygonEditor.this.myScroll.getViewport().getSize().height) {
                dy = 1;
            }
            if (dx != 0 || dy != 0) {
                Rectangle r = new Rectangle(PolygonEditor.this.myScroll.getViewport().getViewRect());
                r.translate(2 * dist * dx, 2 * dist * dy);
                r = r.intersection(new Rectangle(new Point(0, 0), PolygonEditor.this.getPreferredSize()));
                PolygonEditor.this.scrollRectToVisible(r);
            }
        }
    }
}

