/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.metadata;

import VASSAL.build.module.ModuleExtension;
import VASSAL.build.module.metadata.AbstractMetaData;
import VASSAL.build.module.metadata.ModuleMetaData;
import VASSAL.tools.ArchiveWriter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class ExtensionMetaData
extends AbstractMetaData {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionMetaData.class);
    public static final String ZIP_ENTRY_NAME = "extensiondata";
    public static final String DATA_VERSION = "1";
    protected static final String UNIVERSAL_ELEMENT = "universal";
    protected static final String UNIVERSAL_ATTR = "anyModule";
    protected ModuleMetaData moduleData;
    protected boolean universal;

    public ExtensionMetaData(ModuleExtension ext) {
        this.setVersion(ext.getVersion());
        this.setDescription(new AbstractMetaData.Attribute("description", ext.getDescription()));
        this.universal = ext.getUniversal();
    }

    public ExtensionMetaData(ZipFile zip) {
        this.read(zip);
    }

    public String getModuleName() {
        return this.moduleData == null ? "" : this.moduleData.getName();
    }

    public String getModuleVersion() {
        return this.moduleData == null ? "" : this.moduleData.getVersion();
    }

    @Override
    public String getZipEntryName() {
        return ZIP_ENTRY_NAME;
    }

    @Override
    public String getMetaDataVersion() {
        return DATA_VERSION;
    }

    @Override
    public void save(ArchiveWriter archive) throws IOException {
        super.save(archive);
        this.copyModuleMetadata(archive);
    }

    @Override
    protected void addElements(Document doc, Element root) {
        Element e = doc.createElement(UNIVERSAL_ELEMENT);
        e.appendChild(doc.createTextNode(String.valueOf(this.universal)));
        root.appendChild(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(ZipFile zip) {
        try (ZipFile zipFile = zip;){
            DefaultHandler handler = null;
            ZipEntry data = zip.getEntry(this.getZipEntryName());
            if (data == null) {
                data = zip.getEntry("buildFile");
                if (data == null) {
                    data = zip.getEntry("buildFile.xml");
                }
                handler = new ExtensionBuildFileXMLHandler();
            } else {
                handler = new MetadataXMLHandler();
            }
            try (InputStream zin = zip.getInputStream(data);
                 BufferedInputStream in = new BufferedInputStream(zin);){
                XMLReader xMLReader = parser;
                synchronized (xMLReader) {
                    parser.setContentHandler(handler);
                    parser.setDTDHandler(handler);
                    parser.setEntityResolver(handler);
                    parser.setErrorHandler(handler);
                    parser.parse(new InputSource(in));
                }
            }
            ModuleMetaData buildFileModuleData = this.moduleData;
            this.moduleData = new ModuleMetaData(zip);
            if (this.moduleData == null) {
                this.moduleData = buildFileModuleData;
            }
        }
        catch (AbstractMetaData.SAXEndException sAXEndException) {
        }
        catch (IOException | SAXException e) {
            logger.error("", (Throwable)e);
        }
    }

    private class ExtensionBuildFileXMLHandler
    extends AbstractMetaData.BuildFileXMLHandler {
        private ExtensionBuildFileXMLHandler() {
            super(ExtensionMetaData.this);
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws AbstractMetaData.SAXEndException {
            super.startElement(uri, localName, qName, attrs);
            if ("VASSAL.build.module.ModuleExtension".equals(qName)) {
                ExtensionMetaData.this.setVersion(this.getAttr(attrs, "version"));
                ExtensionMetaData.this.setVassalVersion(this.getAttr(attrs, "vassalVersion"));
                ExtensionMetaData.this.setDescription(this.getAttr(attrs, "description"));
                ExtensionMetaData.this.universal = "true".equals(this.getAttr(attrs, ExtensionMetaData.UNIVERSAL_ATTR));
                String moduleName = this.getAttr(attrs, "moduleName");
                String moduleVersion = this.getAttr(attrs, "moduleVersion");
                ExtensionMetaData.this.moduleData = new ModuleMetaData(moduleName, moduleVersion);
                throw new AbstractMetaData.SAXEndException();
            }
        }
    }

    private class MetadataXMLHandler
    extends AbstractMetaData.XMLHandler {
        private MetadataXMLHandler() {
            super(ExtensionMetaData.this);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (ExtensionMetaData.UNIVERSAL_ELEMENT.equals(qName)) {
                ExtensionMetaData.this.universal = "true".equals(this.accumulator.toString().trim());
            } else {
                super.endElement(uri, localName, qName);
            }
        }
    }
}

