/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.noteswindow;

import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.noteswindow.PrivateText;
import VASSAL.build.module.noteswindow.SetPrivateTextCommand;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.TextConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.JLabel;

public class PrivateNotesController
implements GameComponent,
CommandEncoder,
SetPrivateTextCommand.Interface {
    public static final String COMMAND_PREFIX = "PNOTE\t";
    private Set<PrivateText> notes = new HashSet<PrivateText>();
    private String myLastSavedNotes;
    private Component controls;
    private TextConfigurer text;

    public Component getControls() {
        if (this.controls == null) {
            Box b = Box.createVerticalBox();
            b.add(new JLabel(Resources.getString("Notes.invisible")));
            this.text = new TextConfigurer(null, null);
            b.add(this.text.getControls());
            this.controls = b;
        }
        return this.controls;
    }

    @Override
    public void addPrivateText(PrivateText p) {
        this.notes.remove(p);
        this.notes.add(p);
        if (p.getOwner().equals(GameModule.getUserId())) {
            this.text.setValue(p.getText());
        }
    }

    @Override
    public Command decode(String command) {
        Command c = null;
        if (command.startsWith(COMMAND_PREFIX)) {
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command.substring(COMMAND_PREFIX.length()), '\t');
            String owner = st.nextToken();
            String text = st.hasMoreTokens() ? TextConfigurer.restoreNewlines(st.nextToken()) : "";
            return new SetPrivateTextCommand(this, new PrivateText(owner, text));
        }
        return c;
    }

    @Override
    public String encode(Command c) {
        String s = null;
        if (c instanceof SetPrivateTextCommand) {
            PrivateText t = ((SetPrivateTextCommand)c).getPrivateText();
            SequenceEncoder se = new SequenceEncoder('\t');
            s = COMMAND_PREFIX + se.append(t.getOwner()).append(TextConfigurer.escapeNewlines(t.getText())).getValue();
        }
        return s;
    }

    @Override
    public Command getRestoreCommand() {
        SetPrivateTextCommand comm = null;
        for (PrivateText privateText : this.notes) {
            SetPrivateTextCommand c = new SetPrivateTextCommand(this, privateText);
            if (comm == null) {
                comm = c;
                continue;
            }
            comm.append(c);
        }
        return comm;
    }

    @Override
    public void setup(boolean gameStarting) {
        if (!gameStarting) {
            this.notes.clear();
            this.text.setValue("");
        }
    }

    public Command save() {
        SetPrivateTextCommand comm = null;
        if (!this.myLastSavedNotes.equals(this.text.getValue())) {
            comm = new SetPrivateTextCommand(this, new PrivateText(GameModule.getUserId(), (String)this.text.getValue()));
            comm.execute();
        }
        return comm;
    }

    public void captureState() {
        this.myLastSavedNotes = (String)this.text.getValue();
    }

    public void restoreState() {
        this.text.setValue((Object)this.myLastSavedNotes);
    }
}

