/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MapShader;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.GeometricGrid;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ChooseComponentDialog;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class AreaOfEffect
extends Decorator
implements TranslatablePiece,
MapShader.ShadedPiece {
    public static final String ID = "AreaOfEffect;";
    protected static final Color defaultTransparencyColor = Color.GRAY;
    protected static final float defaultTransparencyLevel = 0.3f;
    protected static final int defaultRadius = 1;
    protected Color transparencyColor;
    protected float transparencyLevel;
    protected int radius;
    protected boolean alwaysActive;
    protected boolean active;
    protected String activateCommand;
    protected NamedKeyStroke activateKey;
    protected KeyCommand[] commands;
    protected String mapShaderName;
    protected MapShader shader;
    protected KeyCommand keyCommand;
    protected boolean fixedRadius = true;
    protected String radiusMarker = "";
    protected String description = "";

    public AreaOfEffect() {
        this(ID + ColorConfigurer.colorToString(defaultTransparencyColor), null);
    }

    public AreaOfEffect(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public String getDescription() {
        Object d = "Area Of Effect";
        if (this.description.length() > 0) {
            d = (String)d + " - " + this.description;
        }
        return d;
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.transparencyColor);
        se.append((int)(this.transparencyLevel * 100.0f));
        se.append(this.radius);
        se.append(this.alwaysActive);
        se.append(this.activateCommand);
        se.append(this.activateKey);
        se.append(this.mapShaderName == null ? "" : this.mapShaderName);
        se.append(this.fixedRadius);
        se.append(this.radiusMarker);
        se.append(this.description);
        return ID + se.getValue();
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.transparencyColor = st.nextColor(defaultTransparencyColor);
        this.transparencyLevel = (float)st.nextInt(30) / 100.0f;
        this.radius = st.nextInt(1);
        this.alwaysActive = st.nextBoolean(true);
        this.activateCommand = st.nextToken("Show Area");
        this.activateKey = st.nextNamedKeyStroke(null);
        this.keyCommand = new KeyCommand(this.activateCommand, this.activateKey, Decorator.getOutermost(this), (TranslatablePiece)this);
        this.mapShaderName = st.nextToken("");
        if (this.mapShaderName.length() == 0) {
            this.mapShaderName = null;
        }
        this.fixedRadius = st.nextBoolean(true);
        this.radiusMarker = st.nextToken("");
        this.description = st.nextToken("");
        this.shader = null;
        this.commands = null;
    }

    @Override
    public String myGetState() {
        return this.alwaysActive ? "" : String.valueOf(this.active);
    }

    @Override
    public void mySetState(String newState) {
        if (!this.alwaysActive) {
            this.active = "true".equals(newState);
        }
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        Area a;
        if ((this.alwaysActive || this.active) && this.mapShaderName == null && obs instanceof Map.View && this.getMap() != null && (a = this.getArea()) != null) {
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            g2d.setColor(this.transparencyColor);
            Composite oldComposite = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, this.transparencyLevel));
            if (zoom != 1.0) {
                a = new Area(AffineTransform.getScaleInstance(zoom, zoom).createTransformedShape(a));
            }
            g2d.fill(a);
            g2d.setColor(oldColor);
            g2d.setComposite(oldComposite);
        }
        this.piece.draw(g, x, y, obs, zoom);
    }

    protected Area getArea() {
        Area a;
        MapGrid grid;
        Map map = this.getMap();
        if (map == null) {
            return null;
        }
        Point mapPosition = this.getPosition();
        int myRadius = this.getRadius();
        Board board = map.findBoard(mapPosition);
        MapGrid mapGrid = grid = board == null ? null : board.getGrid();
        if (grid instanceof GeometricGrid) {
            GeometricGrid gGrid = (GeometricGrid)grid;
            Rectangle boardBounds = board.bounds();
            Point boardPosition = new Point(mapPosition.x - boardBounds.x, mapPosition.y - boardBounds.y);
            a = gGrid.getGridShape(boardPosition, myRadius);
            AffineTransform t = AffineTransform.getTranslateInstance(boardBounds.x, boardBounds.y);
            double mag = board.getMagnification();
            if (mag != 1.0) {
                t.translate(boardPosition.x, boardPosition.y);
                t.scale(mag, mag);
                t.translate(-boardPosition.x, -boardPosition.y);
            }
            a = a.createTransformedArea(t);
        } else {
            a = new Area(new Ellipse2D.Double(mapPosition.x - myRadius, mapPosition.y - myRadius, myRadius * 2, myRadius * 2));
        }
        return a;
    }

    protected int getRadius() {
        if (this.fixedRadius) {
            return this.radius;
        }
        String r = (String)Decorator.getOutermost(this).getProperty(this.radiusMarker);
        try {
            return Integer.parseInt(r);
        }
        catch (NumberFormatException e) {
            AreaOfEffect.reportDataError(this, Resources.getString("Error.non_number_error"), "radius[" + this.radiusMarker + "]=" + r, e);
            return 0;
        }
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.commands = this.alwaysActive || this.activateCommand.length() == 0 ? new KeyCommand[0] : new KeyCommand[]{this.keyCommand};
        }
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        Command c = null;
        this.myGetKeyCommands();
        if (!this.alwaysActive && this.keyCommand.matches(stroke)) {
            ChangeTracker t = new ChangeTracker(this);
            this.active = !this.active;
            c = t.getChangeCommand();
        }
        return c;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("AreaOfEffect.htm");
    }

    @Override
    public PieceEditor getEditor() {
        return new TraitEditor(this);
    }

    @Override
    public Area getArea(MapShader shader) {
        Area a = null;
        MapShader.ShadedPiece shaded = (MapShader.ShadedPiece)((Object)Decorator.getDecorator(this.piece, MapShader.ShadedPiece.class));
        if (shaded != null) {
            a = shaded.getArea(shader);
        }
        if ((this.alwaysActive || this.active) && shader.getConfigureName().equals(this.mapShaderName)) {
            Area myArea = this.getArea();
            if (a == null) {
                a = myArea;
            } else {
                a.add(myArea);
            }
        }
        return a;
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.activateCommand, this.getCommandDescription(this.description, "Toggle Visible command"));
    }

    protected static class TraitEditor
    implements PieceEditor {
        protected JPanel panel = new JPanel();
        protected ColorConfigurer transparencyColorValue;
        protected IntConfigurer transparencyValue;
        protected IntConfigurer radiusValue;
        protected BooleanConfigurer alwaysActive;
        protected StringConfigurer activateCommand;
        protected NamedHotKeyConfigurer activateKey;
        protected BooleanConfigurer useMapShader;
        protected BooleanConfigurer fixedRadius;
        protected StringConfigurer radiusMarker;
        protected StringConfigurer descConfig;
        protected Box selectShader;
        protected String mapShaderId;

        protected TraitEditor(AreaOfEffect trait) {
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            this.panel.add(new JLabel("Contributed by Scott Giese (sgiese@sprintmail.com)", 0));
            this.panel.add(new JSeparator());
            this.panel.add(new JLabel(" "));
            this.descConfig = new StringConfigurer(null, "Description:  ", trait.description);
            this.panel.add(this.descConfig.getControls());
            this.useMapShader = new BooleanConfigurer(null, "Use Map Shading?", trait.mapShaderName != null);
            this.mapShaderId = trait.mapShaderName;
            this.panel.add(this.useMapShader.getControls());
            this.selectShader = Box.createHorizontalBox();
            this.panel.add(this.selectShader);
            JLabel l = new JLabel("Map Shading:  ");
            this.selectShader.add(l);
            final JTextField tf = new JTextField(12);
            tf.setEditable(false);
            this.selectShader.add(tf);
            tf.setText(trait.mapShaderName);
            JButton b = new JButton("Select");
            this.selectShader.add(b);
            b.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ChooseComponentDialog d = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, panel), MapShader.class);
                    d.setVisible(true);
                    if (d.getTarget() != null) {
                        mapShaderId = d.getTarget().getConfigureName();
                        tf.setText(mapShaderId);
                    } else {
                        mapShaderId = null;
                        tf.setText("");
                    }
                }
            });
            this.transparencyColorValue = new ColorConfigurer(null, "Fill Color:  ", trait.transparencyColor);
            this.panel.add(this.transparencyColorValue.getControls());
            this.transparencyValue = new IntConfigurer(null, "Opacity (%):  ", (Integer)((int)(trait.transparencyLevel * 100.0f)));
            this.panel.add(this.transparencyValue.getControls());
            this.fixedRadius = new BooleanConfigurer(null, "Fixed Radius?", (Boolean)trait.fixedRadius);
            this.fixedRadius.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    this.updateRangeVisibility();
                }
            });
            this.panel.add(this.fixedRadius.getControls());
            this.radiusValue = new IntConfigurer(null, "Radius: ", (Integer)trait.radius);
            this.panel.add(this.radiusValue.getControls());
            this.radiusMarker = new StringConfigurer(null, "Radius Marker: ", trait.radiusMarker);
            this.panel.add(this.radiusMarker.getControls());
            this.alwaysActive = new BooleanConfigurer(null, "Always visible?", trait.alwaysActive ? Boolean.TRUE : Boolean.FALSE);
            this.activateCommand = new StringConfigurer(null, "Toggle visible command:  ", trait.activateCommand);
            this.activateKey = new NamedHotKeyConfigurer(null, "Toggle visible keyboard shortcut:  ", trait.activateKey);
            this.updateRangeVisibility();
            this.alwaysActive.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    this.updateCommandVisibility();
                }
            });
            this.updateCommandVisibility();
            this.useMapShader.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    this.updateFillVisibility();
                }
            });
            this.updateFillVisibility();
            this.panel.add(this.alwaysActive.getControls());
            this.panel.add(this.activateCommand.getControls());
            this.panel.add(this.activateKey.getControls());
        }

        protected void updateFillVisibility() {
            boolean useShader = Boolean.TRUE.equals(this.useMapShader.getValue());
            this.transparencyColorValue.getControls().setVisible(!useShader);
            this.transparencyValue.getControls().setVisible(!useShader);
            this.selectShader.setVisible(useShader);
            this.repack();
        }

        protected void updateRangeVisibility() {
            boolean fixedRange = this.fixedRadius.booleanValue();
            this.radiusValue.getControls().setVisible(fixedRange);
            this.radiusMarker.getControls().setVisible(!fixedRange);
            this.repack();
        }

        protected void updateCommandVisibility() {
            boolean alwaysActiveSelected = Boolean.TRUE.equals(this.alwaysActive.getValue());
            this.activateCommand.getControls().setVisible(!alwaysActiveSelected);
            this.activateKey.getControls().setVisible(!alwaysActiveSelected);
            this.repack();
        }

        protected void repack() {
            Window w = SwingUtilities.getWindowAncestor(this.alwaysActive.getControls());
            if (w != null) {
                w.pack();
            }
        }

        @Override
        public Component getControls() {
            return this.panel;
        }

        @Override
        public String getState() {
            return "false";
        }

        @Override
        public String getType() {
            boolean alwaysActiveSelected = Boolean.TRUE.equals(this.alwaysActive.getValue());
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.transparencyColorValue.getValueString());
            se.append(this.transparencyValue.getValueString());
            se.append(this.radiusValue.getValueString());
            se.append(alwaysActiveSelected);
            se.append(this.activateCommand.getValueString());
            se.append(this.activateKey.getValueString());
            if (Boolean.TRUE.equals(this.useMapShader.getValue()) && this.mapShaderId != null) {
                se.append(this.mapShaderId);
            } else {
                se.append("");
            }
            se.append(this.fixedRadius.getValueString());
            se.append(this.radiusMarker.getValueString());
            se.append(this.descConfig.getValueString());
            return AreaOfEffect.ID + se.getValue();
        }
    }
}

