/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.BadDataReport;
import VASSAL.build.module.Map;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.build.module.properties.PropertyNameSource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.SimplePieceEditor;
import VASSAL.counters.Stack;
import VASSAL.counters.StateMergeable;
import VASSAL.i18n.Localization;
import VASSAL.i18n.PieceI18nData;
import VASSAL.property.PersistentPropertyContainer;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;

public abstract class Decorator
implements GamePiece,
StateMergeable,
PropertyNameSource,
PersistentPropertyContainer,
PropertyExporter {
    protected GamePiece piece;
    private Decorator dec;
    private boolean selected = false;

    public void setInner(GamePiece p) {
        this.piece = p;
        if (p != null) {
            p.setProperty("Outer", this);
        }
    }

    @Override
    public void setMap(Map m) {
        this.piece.setMap(m);
    }

    public GamePiece getInner() {
        return this.piece;
    }

    @Override
    public Map getMap() {
        return this.piece.getMap();
    }

    @Override
    public void setParent(Stack s) {
        this.piece.setParent(s);
    }

    @Override
    public Stack getParent() {
        return this.piece.getParent();
    }

    @Override
    public Object getProperty(Object key) {
        if ("KeyCommands".equals(key)) {
            return this.getKeyCommands();
        }
        if ("Inner".equals(key)) {
            return this.piece;
        }
        if ("Outer".equals(key)) {
            return this.dec;
        }
        if ("visibleState".equals(key)) {
            return this.myGetState() + this.piece.getProperty(key);
        }
        if ("Selected".equals(key)) {
            return this.selected;
        }
        return this.piece.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (List.of("KeyCommands", "Inner", "Outer", "visibleState").contains(key)) {
            return this.getProperty(key);
        }
        if ("Selected".equals(key)) {
            return this.isSelected();
        }
        return this.piece.getLocalizedProperty(key);
    }

    @Override
    public void setProperty(Object key, Object val) {
        if ("Inner".equals(key)) {
            this.setInner((GamePiece)val);
        } else if ("Outer".equals(key)) {
            this.dec = (Decorator)val;
        } else if ("Selected".equals(key)) {
            if (val instanceof Boolean) {
                this.setSelected((Boolean)val);
            } else {
                this.setSelected(false);
            }
            this.piece.setProperty(key, val);
        } else {
            this.piece.setProperty(key, val);
        }
    }

    @Override
    public Command setPersistentProperty(Object key, Object val) {
        if (this.piece instanceof PersistentPropertyContainer) {
            return ((PersistentPropertyContainer)((Object)this.piece)).setPersistentProperty(key, val);
        }
        return null;
    }

    @Override
    public Object getPersistentProperty(Object key) {
        return this.piece.getProperty(key);
    }

    public Decorator getOuter() {
        return this.dec;
    }

    @Override
    public void setPosition(Point p) {
        this.piece.setPosition(p);
    }

    @Override
    public Point getPosition() {
        return this.piece.getPosition();
    }

    public abstract void mySetState(String var1);

    @Override
    public void setState(String newState) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(newState, '\t');
        this.mySetState(st.nextToken());
        try {
            this.piece.setState(st.nextToken());
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("No state for Decorator=" + this.myGetType());
        }
    }

    @Override
    public void mergeState(String newState, String oldState) {
        SequenceEncoder.Decoder stNew = new SequenceEncoder.Decoder(newState, '\t');
        String myNewState = stNew.nextToken();
        String innerNewState = stNew.nextToken();
        SequenceEncoder.Decoder stOld = new SequenceEncoder.Decoder(oldState, '\t');
        String myOldState = stOld.nextToken();
        String innerOldState = stOld.nextToken();
        if (!myOldState.equals(myNewState)) {
            this.mySetState(myNewState);
        }
        if (this.piece instanceof StateMergeable) {
            ((StateMergeable)((Object)this.piece)).mergeState(innerNewState, innerOldState);
        } else {
            this.piece.setState(innerNewState);
        }
    }

    public abstract String myGetState();

    @Override
    public String getState() {
        SequenceEncoder se = new SequenceEncoder(this.myGetState(), '\t');
        se.append(this.piece.getState());
        return se.getValue();
    }

    public abstract String myGetType();

    @Override
    public String getType() {
        SequenceEncoder se = new SequenceEncoder(this.myGetType(), '\t');
        se.append(this.piece.getType());
        return se.getValue();
    }

    protected abstract KeyCommand[] myGetKeyCommands();

    protected KeyCommand[] getKeyCommands() {
        Object[] myC = this.myGetKeyCommands();
        Object[] c = (KeyCommand[])this.piece.getProperty("KeyCommands");
        if (c == null) {
            return myC;
        }
        if (myC == null) {
            return c;
        }
        return (KeyCommand[])ArrayUtils.addAll((Object[])myC, (Object[])c);
    }

    public abstract Command myKeyEvent(KeyStroke var1);

    @Override
    public Command keyEvent(KeyStroke stroke) {
        Command c = this.myKeyEvent(stroke);
        return c == null ? this.piece.keyEvent(stroke) : c.append(this.piece.keyEvent(stroke));
    }

    @Override
    public String getId() {
        return this.piece.getId();
    }

    @Override
    public void setId(String id) {
        this.piece.setId(id);
    }

    public static GamePiece getOutermost(GamePiece p) {
        while (p.getProperty("Outer") != null) {
            p = (GamePiece)p.getProperty("Outer");
        }
        return p;
    }

    public static GamePiece getInnermost(GamePiece p) {
        while (p instanceof Decorator) {
            p = ((Decorator)p).piece;
        }
        return p;
    }

    public static GamePiece getDecorator(GamePiece p, Class<?> type) {
        while (p instanceof Decorator) {
            if (type.isInstance(p)) {
                return p;
            }
            p = ((Decorator)p).piece;
        }
        return null;
    }

    public PieceEditor getEditor() {
        return new SimplePieceEditor(this);
    }

    public String toString() {
        if (this.piece == null) {
            return super.toString();
        }
        return super.toString() + "[name=" + this.getName() + ",type=" + this.getType() + ",state=" + this.getState() + "]";
    }

    @Override
    public String getLocalizedName() {
        return this.piece.getLocalizedName();
    }

    public PieceI18nData getI18nData() {
        return new PieceI18nData(this);
    }

    protected PieceI18nData getI18nData(String command, String description) {
        PieceI18nData data = new PieceI18nData(this);
        data.add(command, description);
        return data;
    }

    protected PieceI18nData getI18nData(String[] commands, String[] descriptions) {
        PieceI18nData data = new PieceI18nData(this);
        for (int i = 0; i < commands.length; ++i) {
            data.add(commands[i], descriptions[i]);
        }
        return data;
    }

    protected String getCommandDescription(String description, String command) {
        Object s = "";
        if (description != null && description.length() > 0) {
            s = (String)s + description + ": ";
        }
        return (String)s + command;
    }

    protected String getTranslation(String key) {
        String fullKey = "Piece." + key;
        return Localization.getInstance().translate(fullKey, key);
    }

    protected static void reportDataError(EditablePiece piece, String message, String data, Throwable e) {
        ErrorDialog.dataWarning(new BadDataReport(piece, message, data, e));
    }

    protected static void reportDataError(EditablePiece piece, String message, String data) {
        ErrorDialog.dataWarning(new BadDataReport(piece, message, data));
    }

    protected static void reportDataError(EditablePiece piece, String message) {
        ErrorDialog.dataWarning(new BadDataReport(piece, message));
    }

    @Override
    public List<String> getPropertyNames() {
        return new ArrayList<String>(0);
    }

    @Deprecated(since="20200906", forRemoval=true)
    public static void setOldProperties(GamePiece p) {
        ProblemDialog.showDeprecated("20200906");
        Decorator.putOldProperties(p);
    }

    public static Command putOldProperties(GamePiece p) {
        if (!(p instanceof PersistentPropertyContainer)) {
            return null;
        }
        PersistentPropertyContainer container = (PersistentPropertyContainer)((Object)p);
        String mapName = "";
        String boardName = "";
        String zoneName = "";
        String locationName = "";
        Map m = p.getMap();
        Point pos = p.getPosition();
        Command comm = new NullCommand();
        if (m != null) {
            Zone z;
            mapName = m.getConfigureName();
            Board b = m.findBoard(pos);
            if (b != null) {
                boardName = b.getName();
            }
            if ((z = m.findZone(pos)) != null) {
                zoneName = z.getName();
            }
            locationName = m.locationName(pos);
        }
        comm = comm.append(container.setPersistentProperty("OldX", String.valueOf(pos.x)));
        comm = comm.append(container.setPersistentProperty("OldY", String.valueOf(pos.y)));
        comm = comm.append(container.setPersistentProperty("OldMap", mapName));
        comm = comm.append(container.setPersistentProperty("OldBoard", boardName));
        comm = comm.append(container.setPersistentProperty("OldZone", zoneName));
        comm = comm.append(container.setPersistentProperty("OldLocationName", locationName));
        return comm;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void setOldProperties() {
        ProblemDialog.showDeprecated("2020-08-06");
        Decorator.putOldProperties(this);
    }

    public static void repack(Component c) {
        Window w = SwingUtilities.getWindowAncestor(c);
        if (w != null) {
            w.pack();
        }
    }

    protected void setSelected(boolean b) {
        this.selected = b;
    }

    protected boolean isSelected() {
        return this.selected;
    }

    @Override
    public java.util.Map<String, Object> getProperties(java.util.Map<String, Object> result) {
        for (String propertyName : this.getPropertyNames()) {
            result.computeIfAbsent(propertyName, pn -> this.getLocalizedProperty(pn));
        }
        return this.piece == null ? result : ((PropertyExporter)((Object)this.piece)).getProperties(result);
    }
}

