/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Box;
import javax.swing.KeyStroke;

public class GlobalHotKey
extends Decorator
implements TranslatablePiece {
    public static final String ID = "globalhotkey;";
    protected NamedKeyStroke commandKey;
    protected NamedKeyStroke globalHotKey;
    protected String commandName = "Hotkey";
    protected KeyCommand[] commands;
    protected KeyCommand command;
    protected String description = "";

    public GlobalHotKey() {
        this(ID, null);
    }

    public GlobalHotKey(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.command = new KeyCommand(this.commandName, this.commandKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.command.setEnabled(this.getMap() != null);
            this.commands = this.commandName != null && this.commandName.length() > 0 && this.commandKey != null && !this.commandKey.isNull() ? new KeyCommand[]{this.command} : new KeyCommand[0];
        }
        return this.commands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.commandName).append(this.commandKey).append(this.globalHotKey).append(this.description);
        return ID + se.getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        if (this.command.matches(stroke)) {
            GameModule gm = GameModule.getGameModule();
            boolean loggingPausedByMe = gm.pauseLogging();
            GameModule.getGameModule().fireKeyStroke(this.globalHotKey);
            if (loggingPausedByMe) {
                return gm.resumeLogging();
            }
        }
        return null;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getDescription() {
        return this.description == null || this.description.length() == 0 ? "Global Hotkey" : "Global Hotkey:  " + this.description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalHotKey.htm");
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(type.substring(ID.length()), ';');
        this.commandName = sd.nextToken();
        this.commandKey = sd.nextNamedKeyStroke('H');
        this.globalHotKey = sd.nextNamedKeyStroke(null);
        this.description = sd.nextToken("");
        this.commands = null;
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.commandName, this.getDescription() + " command");
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer commandConfig;
        private NamedHotKeyConfigurer commandKeyConfig;
        private NamedHotKeyConfigurer hotKeyConfig;
        protected StringConfigurer descConfig;
        private Box controls = Box.createVerticalBox();

        public Ed(GlobalHotKey k) {
            this.descConfig = new StringConfigurer(null, "Description:  ", k.description);
            this.controls.add(this.descConfig.getControls());
            this.commandConfig = new StringConfigurer(null, "Menu text:  ", k.commandName);
            this.controls.add(this.commandConfig.getControls());
            this.commandKeyConfig = new NamedHotKeyConfigurer(null, "Keyboard Command:  ", k.commandKey);
            this.controls.add(this.commandKeyConfig.getControls());
            this.hotKeyConfig = new NamedHotKeyConfigurer(null, "Global Hotkey:  ", k.globalHotKey);
            this.controls.add(this.hotKeyConfig.getControls());
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.commandConfig.getValueString()).append(this.commandKeyConfig.getValueString()).append(this.hotKeyConfig.getValueString()).append(this.descConfig.getValueString());
            return GlobalHotKey.ID + se.getValue();
        }
    }
}

