/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class MenuSeparator
extends Decorator
implements TranslatablePiece {
    public static final String ID = "menuSeparator;";
    public static final String SEPARATOR_NAME = "<separator>";
    protected KeyCommand[] command;
    protected String desc;
    protected NamedKeyStroke key;
    protected KeyCommand separatorCommand;

    public MenuSeparator() {
        this("menuSeparator;;", null);
    }

    public MenuSeparator(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.desc = st.nextToken();
        this.key = st.nextNamedKeyStroke(null);
        this.command = null;
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.desc).append(this.key);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.command == null) {
            this.separatorCommand = new KeyCommand(SEPARATOR_NAME, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.command = new KeyCommand[]{this.separatorCommand};
        }
        if (this.command.length > 0) {
            this.command[0].setEnabled(this.getMap() != null);
        }
        return this.command;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        if (this.desc != null && !this.desc.isEmpty()) {
            return "Menu Separator - " + this.desc;
        }
        return "Menu Separator";
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("MenuSeparator.htm");
    }

    public static class Ed
    implements PieceEditor {
        private StringConfigurer descInput;
        private NamedHotKeyConfigurer keyInput;
        private JPanel controls = new JPanel();

        public Ed(MenuSeparator p) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.descInput = new StringConfigurer(null, "Separator Description:  ", p.desc);
            this.controls.add(this.descInput.getControls());
            this.keyInput = new NamedHotKeyConfigurer(null, "If this keystroke is hidden, hide separator:  ", p.key);
            this.controls.add(this.keyInput.getControls());
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.descInput.getValueString()).append(this.keyInput.getValueString());
            return MenuSeparator.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

