/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MovementReporter;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.Decorator;
import VASSAL.counters.FreeRotator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Translate
extends Decorator
implements TranslatablePiece {
    private static final String _0 = "0";
    public static final String ID = "translate;";
    protected KeyCommand[] commands;
    protected String commandName;
    protected NamedKeyStroke keyCommand;
    protected FormattedString xDist = new FormattedString("");
    protected FormattedString xIndex = new FormattedString("");
    protected FormattedString xOffset = new FormattedString("");
    protected FormattedString yDist = new FormattedString("");
    protected FormattedString yIndex = new FormattedString("");
    protected FormattedString yOffset = new FormattedString("");
    protected String description;
    protected boolean moveStack;
    protected KeyCommand moveCommand;
    protected static MoveExecuter mover;

    public Translate() {
        this("translate;Move Forward", null);
    }

    public Translate(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public String getDescription() {
        Object d = "Move fixed distance";
        if (this.description.length() > 0) {
            d = (String)d + " - " + this.description;
        }
        return d;
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.commandName = st.nextToken("Move Forward");
        this.keyCommand = st.nextNamedKeyStroke('M');
        this.xDist.setFormat(st.nextToken(_0));
        this.yDist.setFormat(st.nextToken("60"));
        this.moveStack = st.nextBoolean(false);
        this.xIndex.setFormat(st.nextToken(_0));
        this.yIndex.setFormat(st.nextToken(_0));
        this.xOffset.setFormat(st.nextToken(_0));
        this.yOffset.setFormat(st.nextToken(_0));
        this.description = st.nextToken("");
        this.commands = null;
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.moveCommand = new KeyCommand(this.commandName, this.keyCommand, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.commandName.length() > 0 && this.keyCommand != null && !this.keyCommand.isNull() ? new KeyCommand[]{this.moveCommand} : new KeyCommand[0];
        }
        this.moveCommand.setEnabled(this.getMap() != null);
        return this.commands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.commandName).append(this.keyCommand).append(this.xDist.getFormat()).append(this.yDist.getFormat()).append(this.moveStack).append(this.xIndex.getFormat()).append(this.yIndex.getFormat()).append(this.xOffset.getFormat()).append(this.yOffset.getFormat()).append(this.description);
        return ID + se.getValue();
    }

    @Override
    public Command keyEvent(KeyStroke stroke) {
        if (GlobalOptions.getInstance().isUseClassicMoveFixedDistance()) {
            this.myGetKeyCommands();
            if (this.moveCommand.matches(stroke)) {
                return this.myKeyEvent(stroke);
            }
        }
        return super.keyEvent(stroke);
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        if (this.moveCommand.matches(stroke)) {
            return GlobalOptions.getInstance().isUseClassicMoveFixedDistance() ? this.classicTranslate(stroke) : this.newTranslate(stroke);
        }
        return null;
    }

    protected Command newTranslate(KeyStroke stroke) {
        GamePiece target = this.findTarget(stroke);
        if (target == null) {
            return null;
        }
        Point p = this.getPosition();
        this.translate(p);
        FreeRotator myRotation = (FreeRotator)Decorator.getDecorator(this, FreeRotator.class);
        if (myRotation != null) {
            Point myPosition = this.getPosition().getLocation();
            Point2D p2d = p.getLocation();
            p2d = AffineTransform.getRotateInstance(myRotation.getCumulativeAngleInRadians(), ((Point2D)myPosition).getX(), ((Point2D)myPosition).getY()).transform(p2d, null);
            p = new Point((int)Math.round(p2d.getX()), (int)Math.round(p2d.getY()));
        }
        if (!Boolean.TRUE.equals(Decorator.getOutermost(this).getProperty("IgnoreGrid"))) {
            p = this.getMap().snapTo(p);
        }
        Command c = new NullCommand();
        if (target instanceof Stack) {
            for (GamePiece gp : ((Stack)target).asList()) {
                boolean pieceSelected = Boolean.TRUE.equals(gp.getProperty("Selected"));
                if (!pieceSelected && !this.moveStack) continue;
                c = c.append(this.movePiece(gp, p));
            }
        } else {
            c = c.append(this.movePiece(target, p));
        }
        return c;
    }

    protected Command movePiece(GamePiece gp, Point dest) {
        Stack parent;
        Map map = gp.getMap();
        if (map == null) {
            return null;
        }
        Command c = Translate.putOldProperties(this);
        GamePiece outer = Decorator.getOutermost(gp);
        ChangeTracker comm = new ChangeTracker(outer);
        outer.setProperty("Moved", Boolean.TRUE);
        c = c.append(comm.getChangeCommand());
        c = c.append(map.placeOrMerge(outer, dest));
        if (map.getMoveKey() != null) {
            c = c.append(outer.keyEvent(map.getMoveKey()));
        }
        if ((parent = outer.getParent()) != null) {
            c = c.append(parent.pieceRemoved(outer));
        }
        return c;
    }

    protected Command classicTranslate(KeyStroke stroke) {
        GamePiece target;
        Command c = new NullCommand();
        if (mover == null) {
            mover = new MoveExecuter();
            mover.setKeyEvent(stroke);
            mover.setAdditionalCommand(Translate.putOldProperties(this));
            SwingUtilities.invokeLater(mover);
        }
        if ((target = this.findTarget(stroke)) != null) {
            c = c.append(this.moveTarget(target));
        }
        mover.addKeyEventTarget(this.piece);
        c = new NullCommand(){

            @Override
            public boolean isNull() {
                return false;
            }
        };
        return c;
    }

    protected Command moveTarget(GamePiece target) {
        Point p = mover.getUpdatedPosition(target);
        if (p == null) {
            p = new Point(this.getPosition());
        }
        this.translate(p);
        FreeRotator myRotation = (FreeRotator)Decorator.getDecorator(this, FreeRotator.class);
        if (myRotation != null) {
            Point myPosition = this.getPosition().getLocation();
            Point2D p2d = p.getLocation();
            p2d = AffineTransform.getRotateInstance(myRotation.getCumulativeAngleInRadians(), ((Point2D)myPosition).getX(), ((Point2D)myPosition).getY()).transform(p2d, null);
            p = new Point((int)p2d.getX(), (int)p2d.getY());
        }
        if (!Boolean.TRUE.equals(Decorator.getOutermost(this).getProperty("IgnoreGrid"))) {
            p = this.getMap().snapTo(p);
        }
        mover.add(target.getMap(), target, p);
        return null;
    }

    protected void translate(Point p) {
        int x = 0;
        int y = 0;
        GamePiece outer = Decorator.getOutermost(this);
        Board b = outer.getMap().findBoard(p);
        int Xdist = this.xDist.getTextAsInt((PropertySource)outer, "Xdistance", this);
        int Xindex = this.xIndex.getTextAsInt((PropertySource)outer, "Xindex", this);
        int Xoffset = this.xOffset.getTextAsInt((PropertySource)outer, "Xoffset", this);
        x = Xdist + Xindex * Xoffset;
        if (b != null) {
            x = (int)Math.round(b.getMagnification() * (double)x);
        }
        int Ydist = this.yDist.getTextAsInt((PropertySource)outer, "Ydistance", this);
        int Yindex = this.yIndex.getTextAsInt((PropertySource)outer, "Yindex", this);
        int Yoffset = this.yOffset.getTextAsInt((PropertySource)outer, "Yoffset", this);
        y = Ydist + Yindex * Yoffset;
        if (b != null) {
            y = (int)Math.round(b.getMagnification() * (double)y);
        }
        p.translate(x, -y);
    }

    protected GamePiece findTarget(KeyStroke stroke) {
        GamePiece outer;
        GamePiece target = outer = Decorator.getOutermost(this);
        if (this.moveStack && outer.getParent() != null && !outer.getParent().isExpanded()) {
            target = outer != outer.getParent().topPiece(GameModule.getUserId()) ? null : outer.getParent();
        }
        return target;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.getInner().boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.getInner().draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.getInner().getName();
    }

    @Override
    public Shape getShape() {
        return this.getInner().getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Editor(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Translate.htm");
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.commandName, this.getCommandDescription(this.description, "Move Fixed Distance command"));
    }

    public static class MoveExecuter
    implements Runnable {
        private List<Move> moves = new ArrayList<Move>();
        private Set<GamePiece> pieces = new HashSet<GamePiece>();
        private KeyStroke stroke;
        private List<GamePiece> innerPieces = new ArrayList<GamePiece>();
        private Command additionalCommand;

        @Override
        public void run() {
            mover = null;
            Command comm = new NullCommand();
            comm = comm.append(this.additionalCommand);
            Iterator<Move> iterator = this.moves.iterator();
            while (iterator.hasNext()) {
                Move move;
                final Map.Merger merger = new Map.Merger(move.map, move.pos, move.piece);
                move = iterator.next();
                DeckVisitor v = new DeckVisitor(){

                    @Override
                    public Object visitDeck(Deck d) {
                        return merger.visitDeck(d);
                    }

                    @Override
                    public Object visitStack(Stack s) {
                        if (!pieces.contains(s) && move.map.getPieceCollection().canMerge(s, move.piece)) {
                            return merger.visitStack(s);
                        }
                        return null;
                    }

                    @Override
                    public Object visitDefault(GamePiece p) {
                        if (!pieces.contains(p) && move.map.getPieceCollection().canMerge(p, move.piece)) {
                            return merger.visitDefault(p);
                        }
                        return null;
                    }
                };
                DeckVisitorDispatcher dispatch = new DeckVisitorDispatcher(v);
                Command c = move.map.apply(dispatch);
                if (c == null) {
                    c = move.map.placeAt(move.piece, move.pos);
                    if (move.map.getMoveKey() != null) {
                        c.append(Decorator.getOutermost(move.piece).keyEvent(move.map.getMoveKey()));
                    }
                }
                comm.append(c);
                if (move.piece.getMap() == move.map) {
                    move.map.ensureVisible(move.map.selectionBoundsOf(move.piece));
                }
                this.pieces.remove(move.piece);
                move.map.repaint();
            }
            MovementReporter r = new MovementReporter(comm);
            if (GlobalOptions.getInstance().autoReportEnabled()) {
                Command reportCommand = r.getReportCommand();
                if (reportCommand != null) {
                    reportCommand.execute();
                }
                comm.append(reportCommand);
            }
            comm.append(r.markMovedPieces());
            if (this.stroke != null) {
                for (GamePiece gamePiece : this.innerPieces) {
                    comm.append(gamePiece.keyEvent(this.stroke));
                }
            }
            GameModule.getGameModule().sendAndLog(comm);
        }

        public void add(Map map, GamePiece piece, Point pos) {
            this.moves.add(new Move(map, piece, pos));
            this.pieces.add(piece);
        }

        public void addKeyEventTarget(GamePiece piece) {
            this.innerPieces.add(piece);
        }

        public void setKeyEvent(KeyStroke stroke) {
            this.stroke = stroke;
        }

        public void setAdditionalCommand(Command c) {
            this.additionalCommand = c;
        }

        public Command getAdditionalCommand() {
            return this.additionalCommand;
        }

        public Point getUpdatedPosition(GamePiece target) {
            Point p = null;
            for (Move move : this.moves) {
                if (move.piece != target) continue;
                p = move.pos;
            }
            return p;
        }

        private static class Move {
            private Map map;
            private GamePiece piece;
            private Point pos;

            public Move(Map map, GamePiece piece, Point pos) {
                this.map = map;
                this.piece = piece;
                this.pos = pos;
            }
        }
    }

    public static class Editor
    implements PieceEditor {
        private FormattedExpressionConfigurer xDist;
        private FormattedExpressionConfigurer yDist;
        private StringConfigurer name;
        private NamedHotKeyConfigurer key;
        private JPanel controls = new JPanel();
        private BooleanConfigurer moveStack;
        protected BooleanConfigurer advancedInput;
        protected FormattedExpressionConfigurer xIndexInput;
        protected FormattedExpressionConfigurer xOffsetInput;
        protected FormattedExpressionConfigurer yIndexInput;
        protected FormattedExpressionConfigurer yOffsetInput;
        protected StringConfigurer descInput;

        public Editor(Translate t) {
            this.controls.setLayout(new BoxLayout(this.controls, 1));
            this.descInput = new StringConfigurer(null, "Description:  ", t.description);
            this.controls.add(this.descInput.getControls());
            this.name = new StringConfigurer(null, "Command Name:  ", t.commandName);
            this.controls.add(this.name.getControls());
            this.key = new NamedHotKeyConfigurer(null, "Keyboard shortcut:  ", t.keyCommand);
            this.controls.add(this.key.getControls());
            this.xDist = new FormattedExpressionConfigurer(null, "Distance to the right:  ", t.xDist.getFormat(), t);
            this.controls.add(this.xDist.getControls());
            this.yDist = new FormattedExpressionConfigurer(null, "Distance upwards:  ", t.yDist.getFormat(), t);
            this.controls.add(this.yDist.getControls());
            this.moveStack = new BooleanConfigurer(null, "Move entire stack? (Not Recommended)", (Boolean)t.moveStack);
            this.controls.add(this.moveStack.getControls());
            this.advancedInput = new BooleanConfigurer(null, "Advanced Options", false);
            this.advancedInput.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent e) {
                    this.updateAdvancedVisibility();
                }
            });
            this.controls.add(this.advancedInput.getControls());
            Box b = Box.createHorizontalBox();
            this.xIndexInput = new FormattedExpressionConfigurer(null, "Additional offset to the right:  ", t.xIndex.getFormat(), t);
            b.add(this.xIndexInput.getControls());
            this.xOffsetInput = new FormattedExpressionConfigurer(null, " times ", t.xOffset.getFormat(), t);
            b.add(this.xOffsetInput.getControls());
            this.controls.add(b);
            b = Box.createHorizontalBox();
            this.yIndexInput = new FormattedExpressionConfigurer(null, "Additional offset upwards:  ", t.yIndex.getFormat(), t);
            b.add(this.yIndexInput.getControls());
            this.yOffsetInput = new FormattedExpressionConfigurer(null, " times ", t.yOffset.getFormat(), t);
            b.add(this.yOffsetInput.getControls());
            this.controls.add(b);
            this.updateAdvancedVisibility();
        }

        private void updateAdvancedVisibility() {
            boolean visible = this.advancedInput.booleanValue();
            this.xIndexInput.getControls().setVisible(visible);
            this.xOffsetInput.getControls().setVisible(visible);
            this.yIndexInput.getControls().setVisible(visible);
            this.yOffsetInput.getControls().setVisible(visible);
            Window w = SwingUtilities.getWindowAncestor(this.controls);
            if (w != null) {
                w.pack();
            }
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.name.getValueString()).append(this.key.getValueString()).append(this.xDist.getValueString()).append(this.yDist.getValueString()).append(this.moveStack.getValueString()).append(this.xIndexInput.getValueString()).append(this.yIndexInput.getValueString()).append(this.xOffsetInput.getValueString()).append(this.yOffsetInput.getValueString()).append(this.descInput.getValueString());
            return Translate.ID + se.getValue();
        }
    }
}

