/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.launch.ModuleManagerWindow;
import VASSAL.tools.DataArchive;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.tilecache.ImageTileDiskCache;
import VASSAL.tools.image.tilecache.TileUtils;
import VASSAL.tools.io.FileArchive;
import VASSAL.tools.io.FileStore;
import VASSAL.tools.io.InputOutputStreamPump;
import VASSAL.tools.io.ProcessLauncher;
import VASSAL.tools.io.ProcessWrapper;
import VASSAL.tools.lang.Pair;
import VASSAL.tools.swing.EDT;
import VASSAL.tools.swing.ProgressDialog;
import VASSAL.tools.swing.Progressor;
import java.awt.Dimension;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TilingHandler {
    private static final Logger logger = LoggerFactory.getLogger(TilingHandler.class);
    protected final String aname;
    protected final File cdir;
    protected final Dimension tdim;
    protected final int maxheap_limit;
    protected final int pid;

    public TilingHandler(String aname, File cdir, Dimension tdim, int mhlim, int pid) {
        this.aname = aname;
        this.cdir = cdir;
        this.tdim = tdim;
        this.maxheap_limit = mhlim;
        this.pid = pid;
    }

    protected boolean isFresh(FileArchive archive, FileStore tcache, String ipath) throws IOException {
        String tpath = TileUtils.tileName(ipath, 0, 0, 1);
        long imtime = archive.getMTime(ipath);
        return imtime > 0L && imtime <= tcache.getMTime(tpath);
    }

    protected Dimension getImageSize(DataArchive archive, String ipath) throws IOException {
        try (InputStream in = archive.getInputStream(ipath);){
            Dimension id;
            Dimension dimension = id = ImageUtils.getImageSize(ipath, in);
            return dimension;
        }
    }

    protected Pair<Integer, Integer> findImages(DataArchive archive, FileStore tcache, List<String> multi, List<Pair<String, IOException>> failed) throws IOException {
        SortedSet<String> images = archive.getImageNameSet();
        int maxpix = 0;
        int tcount = 0;
        FileArchive fa = archive.getArchive();
        for (String iname : images) {
            int t;
            Dimension idim;
            String ipath = "images/" + iname;
            if (this.isFresh(fa, tcache, ipath)) continue;
            try {
                idim = this.getImageSize(archive, ipath);
            }
            catch (IOException e) {
                failed.add(Pair.of(ipath, e));
                continue;
            }
            int n = t = TileUtils.tileCountAtScale(idim, this.tdim, 1) > 1 ? TileUtils.tileCount(idim, this.tdim) : 0;
            if (t == 0) continue;
            tcount += t;
            multi.add(ipath);
            if (idim.width * idim.height <= maxpix) continue;
            maxpix = idim.width * idim.height;
        }
        return new Pair<Integer, Integer>(tcount, maxpix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runSlicer(List<String> multi, int tcount, int maxheap) throws CancellationException, IOException {
        InetAddress lo = InetAddress.getByName(null);
        ServerSocket ssock = new ServerSocket(0, 0, lo);
        int port = ssock.getLocalPort();
        List<String> args = Arrays.asList(Info.getJavaBinPath().getAbsolutePath(), "-classpath", System.getProperty("java.class.path"), "-Xmx" + maxheap + "M", "-DVASSAL.id=" + this.pid, "-Duser.home=" + System.getProperty("user.home"), "-DVASSAL.port=" + port, "VASSAL.tools.image.tilecache.ZipFileImageTiler", this.aname, this.cdir.getAbsolutePath(), String.valueOf(this.tdim.width), String.valueOf(this.tdim.height));
        final ProgressDialog pd = ProgressDialog.createOnEDT(ModuleManagerWindow.getInstance(), "Processing Image Tiles", " ");
        InputOutputStreamPump outP = new InputOutputStreamPump(null, System.out);
        InputOutputStreamPump errP = new InputOutputStreamPump(null, System.err);
        final ProcessWrapper proc = new ProcessLauncher().launch(null, outP, errP, args.toArray(new String[0]));
        try (PrintWriter stdin = new PrintWriter(proc.stdin, true, StandardCharsets.UTF_8);){
            multi.forEach(stdin::println);
        }
        try (Socket csock = ssock.accept();){
            csock.shutdownOutput();
            try (DataInputStream in = new DataInputStream(csock.getInputStream());){
                Progressor progressor = new Progressor(0, tcount){

                    @Override
                    protected void run(Pair<Integer, Integer> prog) {
                        pd.setProgress(100 * (Integer)prog.second / this.max);
                    }
                };
                EDT.execute(new Runnable(){

                    @Override
                    public void run() {
                        pd.addActionListener(e -> {
                            pd.setVisible(false);
                            proc2.future.cancel(true);
                        });
                    }
                });
                boolean done = false;
                block33: while (!done) {
                    byte type = in.readByte();
                    switch (type) {
                        case 1: {
                            String ipath = in.readUTF();
                            EDT.execute(() -> {
                                pd.setLabel("Tiling " + ipath);
                                if (!pd.isVisible()) {
                                    pd.setVisible(true);
                                }
                            });
                            continue block33;
                        }
                        case 2: {
                            progressor.increment();
                            if (progressor.get() < tcount) continue block33;
                            pd.setVisible(false);
                            continue block33;
                        }
                        case 3: {
                            done = true;
                            continue block33;
                        }
                    }
                    throw new IllegalStateException("bad type: " + type);
                }
            }
        }
        catch (IOException e) {
            logger.error("Error during tiling", (Throwable)e);
        }
        finally {
            try {
                ssock.close();
            }
            catch (IOException e) {
                logger.error("Error while closing the server socket", (Throwable)e);
            }
        }
        try {
            int retval = proc.future.get();
            if (retval != 0) {
                throw new IOException("return value == " + retval);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void makeHashDirs() throws IOException {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                File d = new File(String.format("%s/%1x/%1x%1x", this.cdir, i, i, j));
                FileUtils.forceMkdir((File)d);
            }
        }
    }

    protected void cleanup() throws IOException {
        FileUtils.forceDelete((File)this.cdir);
    }

    public void sliceTiles() throws CancellationException, IOException {
        Pair<Integer, Integer> s;
        ArrayList<String> multi = new ArrayList<String>();
        ArrayList<Pair<String, IOException>> failed = new ArrayList<Pair<String, IOException>>();
        try (DataArchive archive = new DataArchive(this.aname);){
            ImageTileDiskCache tcache = new ImageTileDiskCache(this.cdir.getAbsolutePath());
            s = this.findImages(archive, tcache, multi, failed);
        }
        if (multi.isEmpty()) {
            logger.info("No images to tile.");
            return;
        }
        this.makeHashDirs();
        int tcount = (Integer)s.first;
        int max_data_mbytes = 4 * (Integer)s.second >> 20;
        int maxheap_estimated = (int)(1.66 * (double)max_data_mbytes + 150.0);
        int maxheap = Math.min(maxheap_estimated, this.maxheap_limit);
        try {
            this.runSlicer(multi, (Integer)s.first, maxheap);
        }
        catch (IOException | CancellationException e) {
            this.cleanup();
            throw e;
        }
    }
}

