/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.configure.PasswordConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.WriteErrorDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class UsernameAndPasswordDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public UsernameAndPasswordDialog(Frame parent) {
        super(parent, "Set Your Username and Password", true);
        this.setLocationRelativeTo(parent);
        this.setDefaultCloseOperation(2);
        final StringConfigurer nameConfig = new StringConfigurer(null, Resources.getString("WizardSupport.RealName"));
        final PasswordConfigurer pwd = new PasswordConfigurer(null, Resources.getString("WizardSupport.Password"));
        final PasswordConfigurer pwd2 = new PasswordConfigurer(null, Resources.getString("WizardSupport.ConfirmPassword"));
        Component nc = nameConfig.getControls();
        Component p1 = pwd.getControls();
        Component p2 = pwd2.getControls();
        JLabel note = new JLabel(Resources.getString("WizardSupport.NameAndPasswordDetails"));
        final JLabel error = new JLabel(Resources.getString("WizardSupport.EnterNameAndPassword"));
        final JButton ok = new JButton(Resources.getString("General.ok"));
        ok.setEnabled(false);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Prefs p = GameModule.getGameModule().getPrefs();
                p.getOption("RealName").setValue(nameConfig.getValueString());
                p.getOption("SecretName").setValue(pwd.getValueString());
                try {
                    p.write();
                }
                catch (IOException ex) {
                    WriteErrorDialog.error(ex, p.getFile());
                }
                UsernameAndPasswordDialog.this.dispose();
            }
        });
        JButton cancel = new JButton(Resources.getString("General.cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsernameAndPasswordDialog.this.dispose();
            }
        });
        JPanel panel = new JPanel();
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, true).addComponent(nc).addComponent(p1).addComponent(p2).addComponent(note).addGroup(layout.createSequentialGroup().addGap(0, 0, Integer.MAX_VALUE).addComponent(error).addGap(0, 0, Integer.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(0, 0, Integer.MAX_VALUE).addComponent(ok).addComponent(cancel)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(nc).addComponent(p1).addComponent(p2).addComponent(note).addComponent(error).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Integer.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE, false).addComponent(ok).addComponent(cancel)));
        layout.linkSize(ok, cancel);
        this.add(panel);
        this.pack();
        this.setMinimumSize(this.getSize());
        PropertyChangeListener pl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (nameConfig.getValue() == null || "".equals(nameConfig.getValue())) {
                    if (pwd.getValue() == null || "".equals(pwd.getValue())) {
                        error.setText(Resources.getString("WizardSupport.EnterNameAndPassword"));
                    } else {
                        error.setText(Resources.getString("WizardSupport.EnterYourName"));
                    }
                    error.setForeground(Color.black);
                    ok.setEnabled(false);
                } else if (pwd.getValue() == null || "".equals(pwd.getValue())) {
                    error.setText(Resources.getString("WizardSupport.EnterYourPassword"));
                    error.setForeground(Color.black);
                    ok.setEnabled(false);
                } else if (pwd2.getValue() == null || "".equals(pwd2.getValue())) {
                    error.setText("Please confirm your password");
                    error.setForeground(Color.black);
                    ok.setEnabled(false);
                } else if (!pwd.getValue().equals(pwd2.getValue())) {
                    error.setText(Resources.getString("WizardSupport.PasswordsDontMatch"));
                    error.setForeground(Color.red);
                    ok.setEnabled(false);
                } else {
                    error.setText("");
                    error.setForeground(Color.black);
                    ok.setEnabled(true);
                }
            }
        };
        nameConfig.addPropertyChangeListener(pl);
        pwd.addPropertyChangeListener(pl);
        pwd2.addPropertyChangeListener(pl);
    }
}

