/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.imageop;

import VASSAL.tools.image.GeneralFilter;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.AbstractTiledOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.ScaleOp;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ScaleOpBitmapImpl
extends AbstractTiledOpImpl
implements ScaleOp {
    protected final ImageOp sop;
    protected final double scale;
    protected final RenderingHints hints;
    protected final int hash;
    protected static final RenderingHints defaultHints = ImageUtils.getDefaultHints();

    public ScaleOpBitmapImpl(ImageOp sop, double scale) {
        this(sop, scale, defaultHints);
    }

    public ScaleOpBitmapImpl(ImageOp sop, double scale, RenderingHints hints) {
        if (sop == null) {
            throw new IllegalArgumentException("Attempt to scale null image");
        }
        if (scale <= 0.0) {
            throw new IllegalArgumentException("Cannot scale image at " + scale);
        }
        this.sop = sop;
        this.scale = scale;
        this.hints = hints;
        this.hash = new HashCodeBuilder().append((Object)sop).append(scale).append((Object)hints).toHashCode();
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.singletonList(this.sop);
    }

    @Override
    public BufferedImage eval() throws Exception {
        return ImageUtils.transform(this.sop.getImage(null), this.scale, 0.0, this.hints);
    }

    @Override
    protected void fixSize() {
        this.size = this.getSizeFromCache();
        if (this.size == null) {
            this.size = ImageUtils.transform(new Rectangle(this.sop.getSize()), this.scale, 0.0).getSize();
        }
    }

    @Override
    protected ImageOp createTileOp(int tileX, int tileY) {
        return new TileOp(this, tileX, tileY);
    }

    @Override
    public RenderingHints getHints() {
        return this.hints;
    }

    @Override
    public double getScale() {
        return this.scale;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        ScaleOpBitmapImpl op = (ScaleOpBitmapImpl)o;
        return this.scale == op.scale && this.sop.equals(op.sop) && this.hints.equals(op.hints);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.getClass().getName() + "[sop=" + this.sop + ",scale=" + this.scale + ",hints=" + this.hints + "]";
    }

    private static class TileOp
    extends AbstractTileOpImpl {
        private final ImageOp sop;
        private final int dx0;
        private final int dy0;
        private final int dw;
        private final int dh;
        private final double scale;
        private final RenderingHints hints;
        private final int hash;
        private static final GeneralFilter.Filter downFilter = new GeneralFilter.Lanczos3Filter();
        private static final GeneralFilter.Filter upFilter = new GeneralFilter.MitchellFilter();

        public TileOp(ScaleOpBitmapImpl rop, int tileX, int tileY) {
            if (rop == null) {
                throw new IllegalArgumentException();
            }
            if (tileX < 0 || tileX >= rop.getNumXTiles() || tileY < 0 || tileY >= rop.getNumYTiles()) {
                throw new IndexOutOfBoundsException();
            }
            this.sop = rop.sop;
            this.scale = rop.getScale();
            this.hints = rop.getHints();
            Rectangle sr = new Rectangle(0, 0, (int)((double)this.sop.getWidth() * this.scale), (int)((double)this.sop.getHeight() * this.scale));
            this.dx0 = tileX * rop.getTileWidth();
            this.dy0 = tileY * rop.getTileHeight();
            this.dw = Math.min(rop.getTileWidth(), sr.width - this.dx0);
            this.dh = Math.min(rop.getTileHeight(), sr.height - this.dy0);
            this.size = new Dimension(this.dw, this.dh);
            this.hash = new HashCodeBuilder().append((Object)this.sop).append(this.dx0).append(this.dy0).append(this.dw).append(this.dh).toHashCode();
        }

        @Override
        public List<Op<?>> getSources() {
            return Collections.singletonList(this.sop);
        }

        @Override
        public BufferedImage eval() throws Exception {
            if (this.dw < 1 || this.dh < 1) {
                return ImageUtils.NULL_IMAGE;
            }
            BufferedImage src = ImageUtils.coerceToIntType(this.sop.getImage(null));
            Rectangle sr = new Rectangle(0, 0, (int)((double)this.sop.getWidth() * this.scale), (int)((double)this.sop.getHeight() * this.scale));
            WritableRaster dstR = src.getColorModel().createCompatibleWritableRaster(this.dw, this.dh).createWritableTranslatedChild(this.dx0, this.dy0);
            GeneralFilter.zoom(dstR, sr, src, this.scale < 1.0 ? downFilter : upFilter);
            return ImageUtils.toCompatibleImage(new BufferedImage(src.getColorModel(), dstR.createWritableTranslatedChild(0, 0), src.isAlphaPremultiplied(), null));
        }

        @Override
        protected void fixSize() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            TileOp op = (TileOp)o;
            return this.dx0 == op.dx0 && this.dy0 == op.dy0 && this.dw == op.dw && this.dh == op.dh && this.scale == op.scale && this.sop.equals(op.sop);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.getClass().getName() + "[sop=" + this.sop + ",scale=" + this.scale + ",dx0=" + this.dx0 + ",dy0=" + this.dy0 + ",dw=" + this.dw + ",dy=" + this.dh + "]";
        }
    }
}

