/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build;

import VASSAL.build.GameModule;
import VASSAL.build.GpIdSupport;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.PrototypeDefinition;
import VASSAL.build.widget.PieceSlot;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Marker;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.PlaceMarker;
import java.util.ArrayList;
import java.util.HashMap;

public class GpIdChecker {
    protected GpIdSupport gpIdSupport;
    protected int maxId;
    protected boolean useName = false;
    protected boolean extensionsLoaded = false;
    final HashMap<String, SlotElement> goodSlots = new HashMap();
    final ArrayList<SlotElement> errorSlots = new ArrayList();
    private Chatter chatter;

    public GpIdChecker() {
        this(null);
    }

    public GpIdChecker(GpIdSupport gpIdSupport) {
        this.gpIdSupport = gpIdSupport;
        this.maxId = -1;
    }

    public GpIdChecker(boolean useName) {
        this();
        this.useName = useName;
        this.extensionsLoaded = true;
    }

    public void add(PieceSlot pieceSlot) {
        this.testGpId(pieceSlot.getGpId(), new SlotElement(pieceSlot));
        this.checkTrait(pieceSlot.getPiece());
    }

    public void add(PrototypeDefinition prototype) {
        GamePiece gp = prototype.getPiece();
        this.checkTrait(gp, prototype, gp);
    }

    protected void checkTrait(GamePiece gp) {
        if (gp == null || gp instanceof BasicPiece) {
            return;
        }
        if (gp instanceof PlaceMarker) {
            PlaceMarker pm = (PlaceMarker)gp;
            this.testGpId(pm.getGpId(), new SlotElement(pm));
        }
        this.checkTrait(((Decorator)gp).getInner());
    }

    protected void checkTrait(GamePiece gp, PrototypeDefinition prototype, GamePiece definition) {
        if (gp == null || gp instanceof BasicPiece) {
            return;
        }
        if (gp instanceof PlaceMarker) {
            PlaceMarker pm = (PlaceMarker)gp;
            this.testGpId(pm.getGpId(), new SlotElement(pm, prototype, definition));
        }
        this.checkTrait(((Decorator)gp).getInner(), prototype, definition);
    }

    protected void testGpId(String id, SlotElement element) {
        if (!this.extensionsLoaded && id.contains(":")) {
            id = id.split(":")[1];
        }
        if (id == null || id.length() == 0) {
            this.errorSlots.add(element);
        } else {
            if (this.goodSlots.get(id) != null) {
                this.errorSlots.add(element);
            }
            try {
                if (this.extensionsLoaded) {
                    this.goodSlots.put(id, element);
                } else {
                    int iid = Integer.parseInt(id);
                    this.goodSlots.put(id, element);
                    if (iid > this.maxId) {
                        this.maxId = iid;
                    }
                }
            }
            catch (Exception e) {
                this.errorSlots.add(element);
            }
        }
    }

    public boolean hasErrors() {
        return this.errorSlots.size() > 0;
    }

    private void chat(String text) {
        if (this.chatter == null) {
            this.chatter = GameModule.getGameModule().getChatter();
        }
        Chatter.DisplayText mess = new Chatter.DisplayText(this.chatter, "- " + text);
        mess.execute();
    }

    public void fixErrors() {
        if (this.maxId >= this.gpIdSupport.getNextGpId()) {
            this.chat("Next GPID updated from " + this.gpIdSupport.getNextGpId() + "  to " + (this.maxId + 1));
            this.gpIdSupport.setNextGpId(this.maxId + 1);
        }
        for (SlotElement slotElement : this.errorSlots) {
            String before = slotElement.getGpId();
            slotElement.updateGpId();
            this.chat(slotElement.toString() + " GPID updated from " + before + " to " + slotElement.getGpId());
        }
    }

    public GamePiece createUpdatedPiece(GamePiece oldPiece) {
        SlotElement element;
        String gpid = (String)oldPiece.getProperty("PieceId");
        if (gpid != null && gpid.length() > 0 && (element = this.goodSlots.get(gpid)) != null) {
            return element.createPiece(oldPiece);
        }
        if (this.useName) {
            String oldPieceName = Decorator.getInnermost(oldPiece).getName();
            for (SlotElement el : this.goodSlots.values()) {
                GamePiece newPiece = el.getPiece();
                String newPieceName = Decorator.getInnermost(newPiece).getName();
                if (!oldPieceName.equals(newPieceName)) continue;
                return el.createPiece(oldPiece);
            }
        }
        return oldPiece;
    }

    public boolean findUpdatedPiece(GamePiece oldPiece) {
        SlotElement element;
        String gpid = (String)oldPiece.getProperty("PieceId");
        if (gpid != null && gpid.length() > 0 && (element = this.goodSlots.get(gpid)) != null) {
            return true;
        }
        if (this.useName) {
            String oldPieceName = Decorator.getInnermost(oldPiece).getName();
            for (SlotElement el : this.goodSlots.values()) {
                GamePiece newPiece = el.getPiece();
                String newPieceName = Decorator.getInnermost(newPiece).getName();
                if (!oldPieceName.equals(newPieceName)) continue;
                return true;
            }
        }
        return false;
    }

    static class SlotElement {
        private PieceSlot slot = null;
        private PlaceMarker marker = null;
        private String id;
        private PrototypeDefinition prototype = null;
        private GamePiece expandedPrototype = null;

        public SlotElement() {
        }

        public SlotElement(PieceSlot ps) {
            this();
            this.slot = ps;
            this.id = ps.getGpId();
        }

        public SlotElement(PlaceMarker pm) {
            this();
            this.marker = pm;
            this.id = pm.getGpId();
        }

        public SlotElement(PlaceMarker pm, PrototypeDefinition pd, GamePiece definition) {
            this();
            this.marker = pm;
            this.prototype = pd;
            this.expandedPrototype = definition;
            this.id = pm.getGpId();
        }

        public String getGpId() {
            return this.id;
        }

        public String toString() {
            return this.marker == null ? "PieceSlot " + this.slot.getConfigureName() : "Place/Replace trait " + this.marker.getDescription();
        }

        public void updateGpId() {
            if (this.marker == null) {
                this.slot.updateGpId();
                this.id = this.slot.getGpId();
            } else {
                this.marker.updateGpId();
                this.id = this.marker.getGpId();
                if (this.prototype != null) {
                    this.prototype.setPiece(this.expandedPrototype);
                }
            }
        }

        public GamePiece getPiece() {
            if (this.slot == null) {
                return this.marker;
            }
            return this.slot.getPiece();
        }

        public GamePiece createPiece(GamePiece oldPiece) {
            GamePiece newPiece = this.slot != null ? this.slot.getPiece() : this.marker.createMarker();
            newPiece = PieceCloner.getInstance().clonePiece(newPiece);
            this.copyState(oldPiece, newPiece);
            newPiece.setProperty("PieceId", this.getGpId());
            return newPiece;
        }

        protected void copyState(GamePiece oldPiece, GamePiece newPiece) {
            GamePiece p = newPiece;
            while (p != null) {
                if (p instanceof BasicPiece) {
                    p.setState(Decorator.getInnermost(oldPiece).getState());
                    p = null;
                    continue;
                }
                Decorator decorator = (Decorator)p;
                String type = decorator.myGetType();
                String newState = this.findStateFromType(oldPiece, type, p.getClass());
                if (newState != null && newState.length() > 0 && !(decorator instanceof Marker)) {
                    decorator.mySetState(newState);
                }
                p = decorator.getInner();
            }
        }

        protected String findStateFromType(GamePiece oldPiece, String typeToFind, Class<? extends GamePiece> classToFind) {
            GamePiece p = oldPiece;
            while (p != null && !(p instanceof BasicPiece)) {
                Decorator d = (Decorator)Decorator.getDecorator(p, classToFind);
                if (d != null) {
                    if (d.getClass().equals(classToFind) && d.myGetType().equals(typeToFind)) {
                        return d.myGetState();
                    }
                    p = d.getInner();
                    continue;
                }
                p = null;
            }
            return null;
        }
    }
}

