/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module;

import VASSAL.build.AbstractBuildable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.StringConfigurer;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.SequenceEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class EventLog
extends AbstractBuildable
implements CommandEncoder,
GameComponent {
    public static final String EVENT_LIST = "Events";
    private List<Event> myEvents;
    private List<Event> savedEvents;

    @Override
    public void addTo(Buildable b) {
        GameModule mod = GameModule.getGameModule();
        mod.addCommandEncoder(this);
        mod.getGameState().addGameComponent(this);
        mod.getPrefs().addOption(new StringConfigurer(EVENT_LIST, null));
        this.myEvents = new ArrayList<Event>();
        this.savedEvents = new ArrayList<Event>();
        for (Event e : EventLog.decodedEvents((String)mod.getPrefs().getValue(EVENT_LIST))) {
            this.myEvents.add(e);
        }
    }

    public void clearSaved() {
        this.savedEvents.clear();
    }

    public void store(Event e) {
        this.savedEvents.add(e);
    }

    public void log(Event e) {
        this.myEvents.add(e);
        GameModule.getGameModule().getPrefs().getOption(EVENT_LIST).setValue(EventLog.encodedEvents(this.myEvents));
    }

    @Override
    public Command decode(String s) {
        if (s.startsWith(EVENT_LIST)) {
            return new StoreEvents(this, s.substring(EVENT_LIST.length()));
        }
        return null;
    }

    @Override
    public String encode(Command c) {
        if (c instanceof StoreEvents) {
            return EVENT_LIST + ((StoreEvents)c).getEvents();
        }
        return null;
    }

    @Override
    public void setup(boolean starting) {
        if (!starting) {
            this.clearSaved();
        }
    }

    @Override
    public Command getRestoreCommand() {
        return new StoreEvents(this, EventLog.encodedEvents(this.savedEvents));
    }

    public static Iterable<Event> decodedEvents(final String s) {
        return () -> new Iterator<Event>(){
            private final SequenceEncoder.Decoder se;
            {
                this.se = new SequenceEncoder.Decoder(s, '|');
            }

            @Override
            public boolean hasNext() {
                return this.se.hasMoreTokens();
            }

            @Override
            public Event next() {
                SequenceEncoder.Decoder sub = new SequenceEncoder.Decoder(this.se.nextToken(), ',');
                return new Event(Long.parseLong(sub.nextToken()), sub.nextToken(), sub.nextToken());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static Enumeration<Event> decodeEvents(String s) {
        ProblemDialog.showDeprecated("2020-08-06");
        ArrayList<Event> l = new ArrayList<Event>();
        SequenceEncoder.Decoder se = new SequenceEncoder.Decoder(s, '|');
        while (se.hasMoreTokens()) {
            SequenceEncoder.Decoder sub = new SequenceEncoder.Decoder(se.nextToken(), ',');
            l.add(new Event(Long.parseLong(sub.nextToken()), sub.nextToken(), sub.nextToken()));
        }
        return Collections.enumeration(l);
    }

    public static String encodedEvents(Iterable<Event> events) {
        SequenceEncoder se = new SequenceEncoder('|');
        for (Event e : events) {
            SequenceEncoder sub = new SequenceEncoder(',');
            sub.append(e.getTime()).append(e.getUser()).append(e.getAction());
            se.append(sub.getValue());
        }
        return se.getValue();
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static String encodeEvents(Enumeration<?> e) {
        ProblemDialog.showDeprecated("2020-08-06");
        SequenceEncoder se = new SequenceEncoder('|');
        while (e.hasMoreElements()) {
            Event evt = (Event)e.nextElement();
            SequenceEncoder sub = new SequenceEncoder(',');
            sub.append(evt.getTime()).append(evt.getUser()).append(evt.getAction());
            se.append(sub.getValue());
        }
        return se.getValue();
    }

    @Override
    public String[] getAttributeNames() {
        return new String[0];
    }

    @Override
    public void setAttribute(String name, Object value) {
    }

    @Override
    public String getAttributeValueString(String name) {
        return null;
    }

    public static class Event {
        private final long time;
        private final String user;
        private final String action;

        public Event(long time, String user, String action) {
            this.time = time;
            this.user = user;
            this.action = action;
        }

        public long getTime() {
            return this.time;
        }

        public String getUser() {
            return this.user;
        }

        public String getAction() {
            return this.action;
        }
    }

    public static class StoreEvents
    extends Command {
        private final EventLog log;
        private final String events;

        public StoreEvents(EventLog log, String events) {
            this.log = log;
            this.events = events;
        }

        public String getEvents() {
            return this.events;
        }

        @Override
        public void executeCommand() {
            this.log.clearSaved();
            for (Event e : EventLog.decodedEvents(this.events)) {
                this.log.store(e);
            }
        }

        @Override
        public Command myUndoCommand() {
            return null;
        }
    }
}

