/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.FontConfigurer;
import VASSAL.build.module.gamepieceimage.FontManager;
import VASSAL.build.module.gamepieceimage.FontStyle;
import VASSAL.configure.Configurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FontStyleConfigurer
extends Configurer {
    protected JPanel p;
    protected JPanel fontPanel;
    protected JComboBox fonts;

    public FontStyleConfigurer(String key, String name) {
        super(key, name);
    }

    public FontStyleConfigurer(String key, String name, FontStyle fontStyle) {
        this(key, name);
        this.setValue(fontStyle);
    }

    public FontStyleConfigurer(String key, String name, String styleName) {
        this(key, name, FontManager.getFontManager().getFontStyle(styleName));
    }

    @Override
    public String getValueString() {
        return "";
    }

    public Font getValueFont() {
        return ((FontStyle)this.value).getFont();
    }

    public FontStyle getValueFontStyle() {
        return (FontStyle)this.value;
    }

    @Override
    public Component getControls() {
        if (this.p == null) {
            this.p = new JPanel();
            this.fontPanel = new JPanel();
            this.p.setLayout(new BoxLayout(this.p, 1));
            Box box = Box.createHorizontalBox();
            box.add(new JLabel(this.name));
            box.add(this.fontPanel);
            this.p.add(box);
        }
        this.buildFonts();
        return this.p;
    }

    protected void buildFonts() {
        String[] s;
        if (this.fontPanel == null) {
            return;
        }
        if (this.fonts != null) {
            this.fontPanel.remove(this.fonts);
        }
        this.fonts = new JComboBox();
        for (String item : s = FontManager.getFontManager().getFontNames()) {
            this.fonts.addItem(item);
        }
        this.fonts.setSelectedItem(this.value == null ? "Default" : ((FontStyle)this.value).getConfigureName());
        this.fontPanel.add(this.fonts);
        ItemListener l = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                FontStyleConfigurer.this.updateValue();
            }
        };
        this.fonts.addItemListener(l);
    }

    protected void updateValue() {
        this.setValue(FontManager.getFontManager().getFontStyle((String)this.fonts.getSelectedItem()));
    }

    @Override
    public void setValue(String s) {
        this.setValue(FontManager.getFontManager().getFontStyle(s));
        this.buildFonts();
    }

    public static FontStyle decode(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s, '|');
        return new FontStyle(sd.nextToken("Default"), FontConfigurer.decode(sd.nextToken("")));
    }

    public static String encode(FontStyle f) {
        SequenceEncoder se = new SequenceEncoder(f.getConfigureName(), '|');
        se.append(FontConfigurer.encode(f.getFont()));
        return se.getValue();
    }
}

