/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.ImageItem;
import VASSAL.build.module.gamepieceimage.ShapeItem;
import VASSAL.build.module.gamepieceimage.SymbolItem;
import VASSAL.build.module.gamepieceimage.TextBoxItem;
import VASSAL.build.module.gamepieceimage.TextItem;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.StringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.SequenceEncoder;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.List;

public abstract class Item
extends AbstractConfigurable {
    public static final String TYPE = "";
    protected static final String NAME = "name";
    protected static final String LOCATION = "location";
    protected static final String ADVANCED = "advanced";
    protected static final String ROTATION = "rotation";
    protected static final String X_OFFSET = "xoffset";
    protected static final String Y_OFFSET = "yoffset";
    protected static final String ANTIALIAS = "antialias";
    String location = "Center";
    protected int xoffset;
    protected int yoffset;
    protected boolean advanced = false;
    protected int rotation = 0;
    protected boolean antialias = true;
    protected GamePieceLayout layout;
    private VisibilityCondition advancedCond = new VisibilityCondition(){

        @Override
        public boolean shouldBeVisible() {
            return Item.this.advanced;
        }
    };

    public Item() {
        this.setConfigureName(TYPE);
    }

    public Item(GamePieceLayout l) {
        this();
        this.layout = l;
    }

    public Item(String name) {
        this();
        this.setConfigureName(name);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Name:  ", "Location:  ", "Advanced Options", "X Offset:  ", "Y Offset:  ", "Rotation (Degrees):  ", "Anti-alias?"};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, LocationConfig.class, Boolean.class, Integer.class, Integer.class, Integer.class, Boolean.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, LOCATION, ADVANCED, X_OFFSET, Y_OFFSET, ROTATION, ANTIALIAS};
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)o);
        } else if (LOCATION.equals(key)) {
            this.location = (String)o;
        } else if (X_OFFSET.equals(key)) {
            if (o instanceof String) {
                o = Integer.valueOf((String)o);
            }
            this.xoffset = (Integer)o;
        } else if (Y_OFFSET.equals(key)) {
            if (o instanceof String) {
                o = Integer.valueOf((String)o);
            }
            this.yoffset = (Integer)o;
        } else if (ADVANCED.equals(key)) {
            if (o instanceof String) {
                o = Boolean.valueOf((String)o);
            }
            this.advanced = (Boolean)o;
        } else if (ROTATION.equals(key)) {
            if (o instanceof String) {
                o = Integer.valueOf((String)o);
            }
            this.rotation = (Integer)o;
        } else if (ANTIALIAS.equals(key)) {
            if (o instanceof String) {
                o = Boolean.valueOf((String)o);
            }
            this.antialias = (Boolean)o;
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (LOCATION.equals(key)) {
            return this.location;
        }
        if (X_OFFSET.equals(key)) {
            return TYPE + this.xoffset;
        }
        if (Y_OFFSET.equals(key)) {
            return TYPE + this.yoffset;
        }
        if (ADVANCED.equals(key)) {
            return TYPE + this.advanced;
        }
        if (ROTATION.equals(key)) {
            return TYPE + this.rotation;
        }
        if (ANTIALIAS.equals(key)) {
            return TYPE + this.antialias;
        }
        return null;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (List.of(ROTATION, X_OFFSET, Y_OFFSET, ANTIALIAS).contains(name)) {
            return this.advancedCond;
        }
        return null;
    }

    @Override
    public void removeFrom(Buildable parent) {
    }

    @Override
    public HelpFile getHelpFile() {
        return null;
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable parent) {
        this.setAllAttributesUntranslatable();
    }

    public abstract void draw(Graphics var1, GamePieceImage var2);

    public abstract String getType();

    public abstract Dimension getSize();

    public String getDisplayName() {
        return this.getType();
    }

    public String getLocation() {
        return this.location;
    }

    public int getXoffset() {
        return this.xoffset;
    }

    public int getYoffset() {
        return this.yoffset;
    }

    public int getRotation() {
        return this.rotation;
    }

    public boolean isAntialias() {
        return this.antialias;
    }

    protected GamePieceLayout getLayout() {
        return this.layout;
    }

    public static Item decode(GamePieceLayout layout, String s) {
        Item item;
        SequenceEncoder.Decoder sd1 = new SequenceEncoder.Decoder(s, '|');
        String t1 = sd1.nextToken(TYPE);
        String t2 = sd1.nextToken(TYPE);
        if (t1.startsWith("Symbol")) {
            item = SymbolItem.decode(layout, t1);
        } else if (t1.startsWith("TextBox")) {
            item = TextBoxItem.decode(layout, t1);
        } else if (t1.startsWith("Text")) {
            item = TextItem.decode(layout, t1);
        } else if (t1.startsWith("Image")) {
            item = ImageItem.decode(layout, t1);
        } else if (t1.startsWith("Box")) {
            item = ShapeItem.decode(layout, t1);
        } else {
            return null;
        }
        SequenceEncoder.Decoder sd2 = new SequenceEncoder.Decoder(t2, ';');
        item.setConfigureName(sd2.nextToken());
        item.location = sd2.nextToken();
        item.xoffset = sd2.nextInt(0);
        item.yoffset = sd2.nextInt(0);
        item.rotation = sd2.nextInt(0);
        item.antialias = sd2.nextBoolean(true);
        return item;
    }

    public String encode() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.getConfigureName());
        se.append(this.location);
        se.append(this.xoffset);
        se.append(this.yoffset);
        se.append(this.rotation);
        se.append(this.antialias);
        return se.getValue();
    }

    public static class LocationConfig
    extends StringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return GamePieceLayout.LOCATIONS;
        }
    }

    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, Item.TYPE);
        }
    }
}

