/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.module.gamepieceimage.FontManager;
import VASSAL.build.module.gamepieceimage.FontStyle;
import VASSAL.build.module.gamepieceimage.GamePieceImage;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.OutlineFont;
import VASSAL.build.module.gamepieceimage.TextBoxItemInstance;
import VASSAL.build.module.gamepieceimage.TextItem;
import VASSAL.configure.TextConfigurer;
import VASSAL.configure.VisibilityCondition;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JTextPane;
import org.apache.commons.lang3.ArrayUtils;

public class TextBoxItem
extends TextItem {
    public static final String TYPE = "TextBox";
    protected static final String WIDTH = "width";
    protected static final String HEIGHT = "height";
    protected static final String USE_HTML = "use_html";
    protected int height = 30;
    protected int width = 40;
    protected boolean isHTML = false;

    public TextBoxItem() {
    }

    public TextBoxItem(GamePieceLayout l) {
        super(l);
    }

    public TextBoxItem(GamePieceLayout l, String n) {
        this(l);
        this.setConfigureName(n);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.insert((int)2, (Object[])super.getAttributeDescriptions(), (Object[])new String[]{"Width:  ", "Height:  ", "Use HTML:  "});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        Class[] c = (Class[])ArrayUtils.insert((int)2, (Object[])super.getAttributeTypes(), (Object[])new Class[]{Integer.class, Integer.class, Boolean.class});
        String[] names = this.getAttributeNames();
        for (int i = 0; i < names.length; ++i) {
            if (!"text".equals(names[i])) continue;
            c[i] = TextConfigurer.class;
            break;
        }
        return c;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if ("font".equals(name)) {
            return new VisibilityCondition(){

                @Override
                public boolean shouldBeVisible() {
                    return !TextBoxItem.this.isHTML;
                }
            };
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.insert((int)2, (Object[])super.getAttributeNames(), (Object[])new String[]{WIDTH, HEIGHT, USE_HTML});
    }

    @Override
    public void setAttribute(String key, Object o) {
        if (WIDTH.equals(key)) {
            if (o instanceof String) {
                o = Integer.valueOf((String)o);
            }
            this.width = (Integer)o;
            if (this.width < 1) {
                this.width = 1;
            }
        } else if (HEIGHT.equals(key)) {
            if (o instanceof String) {
                o = Integer.valueOf((String)o);
            }
            this.height = (Integer)o;
            if (this.height < 1) {
                this.height = 1;
            }
        } else if (USE_HTML.equals(key)) {
            if (o instanceof String) {
                o = Boolean.valueOf((String)o);
            }
            this.isHTML = Boolean.TRUE.equals(o);
        } else {
            super.setAttribute(key, o);
        }
        if (this.layout != null) {
            this.layout.refresh();
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (WIDTH.equals(key)) {
            return String.valueOf(this.width);
        }
        if (HEIGHT.equals(key)) {
            return String.valueOf(this.height);
        }
        if (USE_HTML.equals(key)) {
            return String.valueOf(this.isHTML);
        }
        return super.getAttributeValueString(key);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Override
    public void draw(Graphics g, GamePieceImage defn) {
        ItemInstance tbi = null;
        if (defn != null) {
            tbi = defn.getTextBoxInstance(this.getConfigureName());
        }
        if (tbi == null) {
            tbi = new TextBoxItemInstance();
        }
        Color fg = tbi.getFgColor().getColor();
        Color bg = tbi.getBgColor().getColor();
        Point origin = this.layout.getPosition(this);
        Rectangle r = new Rectangle(origin.x, origin.y, this.getWidth(), this.getHeight());
        String s = null;
        if (this.textSource.equals("Fixed for this layout")) {
            s = this.text;
        } else if (defn != null && tbi != null) {
            s = ((TextBoxItemInstance)tbi).getValue();
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.isAntialias() ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        AffineTransform saveXForm = null;
        if (this.getRotation() != 0) {
            saveXForm = g2d.getTransform();
            AffineTransform newXForm = AffineTransform.getRotateInstance(Math.toRadians(this.getRotation()), this.getLayout().getVisualizerWidth() / 2, this.getLayout().getVisualizerHeight() / 2);
            g2d.transform(newXForm);
        }
        if (bg != null) {
            g.setColor(bg);
            g.fillRect(r.x, r.y, r.width, r.height);
        }
        JTextPane l = new JTextPane();
        if (this.isHTML) {
            l.setContentType("text/html");
        }
        l.setText(s);
        l.setSize(this.width - 2, this.height - 2);
        l.setBackground(bg != null ? bg : new Color(0, true));
        l.setForeground(fg != null ? fg : new Color(0, true));
        FontStyle fs = FontManager.getFontManager().getFontStyle(this.fontStyleName);
        OutlineFont f = fs.getFont();
        l.setFont(f);
        BufferedImage img = ImageUtils.createCompatibleTranslucentImage(Math.max(l.getWidth(), 1), Math.max(l.getHeight(), 1));
        Graphics2D big = img.createGraphics();
        l.paint(big);
        big.dispose();
        g2d.drawImage((Image)img, origin.x + 1, origin.y + 1, null);
        if (saveXForm != null) {
            g2d.setTransform(saveXForm);
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public String getDisplayName() {
        return "Text Box";
    }

    @Override
    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public static Item decode(GamePieceLayout l, String s) {
        TextBoxItem item = new TextBoxItem(l);
        SequenceEncoder.Decoder sd1 = new SequenceEncoder.Decoder(s, ',');
        String s1 = sd1.nextToken("");
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s1, ';');
        sd.nextToken();
        item.width = sd.nextInt(30);
        item.height = sd.nextInt(40);
        item.isHTML = sd.nextBoolean(false);
        TextItem.decode(item, sd1.nextToken(""));
        return item;
    }

    @Override
    public String encode() {
        SequenceEncoder se1 = new SequenceEncoder(TYPE, ';');
        se1.append(this.width);
        se1.append(this.height);
        se1.append(this.isHTML);
        SequenceEncoder se2 = new SequenceEncoder(se1.getValue(), ',');
        se2.append(super.encode());
        return se2.getValue();
    }
}

