/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.GlobalProperty;
import VASSAL.build.module.properties.PropertyChanger;
import VASSAL.build.module.properties.PropertyChangerConfigurer;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.NamedKeyStroke;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;

public class ChangePropertyButton
extends AbstractConfigurable
implements PropertyChangerConfigurer.Constraints {
    public static final String BUTTON_TEXT = "text";
    public static final String BUTTON_TOOLTIP = "tooltip";
    public static final String BUTTON_ICON = "icon";
    public static final String HOTKEY = "hotkey";
    public static final String PROPERTY_CHANGER = "propChanger";
    public static final String REPORT_FORMAT = "reportFormat";
    public static final String OLD_VALUE_FORMAT = "oldValue";
    public static final String NEW_VALUE_FORMAT = "newValue";
    public static final String DESCRIPTION_FORMAT = "description";
    protected LaunchButton launch;
    protected FormattedString report = new FormattedString();
    protected GlobalProperty property;
    protected PropertyChangerConfigurer propChangeConfig = new PropertyChangerConfigurer(null, null, this);
    protected FormattedString format = new FormattedString();

    public ChangePropertyButton() {
        this.launch = new LaunchButton("Change", BUTTON_TOOLTIP, BUTTON_TEXT, HOTKEY, BUTTON_ICON, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ChangePropertyButton.this.launch();
            }
        });
    }

    public void launch() {
        String oldValue = this.property.getPropertyValue();
        String newValue = this.getNewValue();
        if (newValue != null && !newValue.equals(oldValue)) {
            Command c = this.property.setPropertyValue(newValue);
            if (this.report.getFormat().length() > 0) {
                this.report.setProperty(OLD_VALUE_FORMAT, oldValue);
                this.report.setProperty(NEW_VALUE_FORMAT, this.property.getPropertyValue());
                this.report.setProperty(DESCRIPTION_FORMAT, this.property.getDescription());
                Chatter.DisplayText chatCommand = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), "* " + this.report.getLocalizedText());
                chatCommand.execute();
                c.append(chatCommand);
            }
            GameModule.getGameModule().sendAndLog(c);
        }
    }

    protected String getNewValue() {
        String newValue = this.getPropertyChanger().getNewValue(this.property.getPropertyValue());
        this.format.setFormat(newValue);
        newValue = this.format.getText(this.property);
        return newValue;
    }

    public PropertyChanger getPropertyChanger() {
        return this.propChangeConfig.getPropertyChanger();
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{"Button text:  ", "Tooltip Text:  ", "Button icon:  ", "Hotkey:  ", "Report format:  ", "Options:  "};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String.class, Icon.class, NamedKeyStroke.class, ReportFormatConfig.class, PropChangerOptions.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{BUTTON_TEXT, BUTTON_TOOLTIP, BUTTON_ICON, HOTKEY, REPORT_FORMAT, PROPERTY_CHANGER};
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (PROPERTY_CHANGER.equals(key)) {
            if (value instanceof String) {
                this.propChangeConfig.setValue((String)value);
            } else {
                this.propChangeConfig.setValue(value);
            }
        } else if (REPORT_FORMAT.equals(key)) {
            this.report.setFormat((String)value);
        } else {
            if (BUTTON_TEXT.equals(key)) {
                this.setConfigureName((String)value);
            }
            this.launch.setAttribute(key, value);
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (PROPERTY_CHANGER.equals(key)) {
            return this.propChangeConfig.getValueString();
        }
        if (REPORT_FORMAT.equals(key)) {
            return this.report.getFormat();
        }
        return this.launch.getAttributeValueString(key);
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.property.getToolBar().remove(this.launch);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalProperties.htm", "ChangePropertyToolbarButton");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable parent) {
        this.property = (GlobalProperty)parent;
        this.property.getToolBar().add(this.launch);
        this.propChangeConfig.setName(this.property.getConfigureName());
    }

    public static String getConfigureTypeName() {
        return "Change-property Toolbar Button";
    }

    @Override
    public Component getComponent() {
        return this.launch.getTopLevelAncestor();
    }

    @Override
    public int getMaximumValue() {
        return this.property.getMaxValue();
    }

    @Override
    public int getMinimumValue() {
        return this.property.getMinValue();
    }

    @Override
    public boolean isNumeric() {
        return this.property.isNumeric();
    }

    @Override
    public boolean isWrap() {
        return this.property.isWrap();
    }

    @Override
    public Object getProperty(Object key) {
        return this.property.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        return this.property.getLocalizedProperty(key);
    }

    @Override
    public PropertySource getPropertySource() {
        return this.property;
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedStringConfigurer(key, name, new String[]{ChangePropertyButton.OLD_VALUE_FORMAT, ChangePropertyButton.NEW_VALUE_FORMAT, ChangePropertyButton.DESCRIPTION_FORMAT});
        }
    }

    public static class PropChangerOptions
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return ((ChangePropertyButton)c).propChangeConfig;
        }
    }
}

