/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.peer2peer;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.ChatServerFactory;
import VASSAL.chat.CommandDecoder;
import VASSAL.chat.HttpMessageServer;
import VASSAL.chat.messageboard.Message;
import VASSAL.chat.peer2peer.DirectPeerPool;
import VASSAL.chat.peer2peer.P2PClient;
import VASSAL.chat.peer2peer.PeerPoolInfo;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.i18n.Resources;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P2PClientFactory
extends ChatServerFactory {
    private static final Logger logger = LoggerFactory.getLogger(ChatServerFactory.class);
    public static final String P2P_TYPE = "peer2peer";
    public static final String P2P_LISTEN_PORT = "listenPort";
    public static final String P2P_SERVER_IP = "serverIp";
    public static final String P2P_SERVER_PORT = "serverPort";
    public static final String P2P_SERVER_NAME = "serverName";
    public static final String P2P_SERVER_PW = "serverPw";
    @Deprecated(since="2020-08-17", forRemoval=true)
    public static final String P2P_MODE_KEY = "mode";
    @Deprecated(since="2020-08-17", forRemoval=true)
    public static final String P2P_SERVER_MODE = "server";
    @Deprecated(since="2020-08-16", forRemoval=true)
    public static final String P2P_CLIENT_MODE = "client";

    @Override
    public ChatServerConnection buildServer(Properties param) {
        P2PMessageServer httpMessageServer = new P2PMessageServer();
        P2PClient server = new P2PClient(GameModule.getGameModule(), httpMessageServer, httpMessageServer, new DirectPeerPool(param), param);
        server.addPropertyChangeListener("Status", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String mess = (String)evt.getNewValue();
                GameModule.getGameModule().warn(mess);
                logger.info(mess);
            }
        });
        server.addPropertyChangeListener("Msg", new CommandDecoder());
        return server;
    }

    class P2PMessageServer
    extends HttpMessageServer {
        public P2PMessageServer() {
            super(new PeerPoolInfo(){

                @Override
                public String getModuleName() {
                    return GameModule.getGameModule() == null ? Resources.getString("Chat.unknown_module") : GameModule.getGameModule().getGameName();
                }

                @Override
                public String getUserName() {
                    return GameModule.getUserId();
                }
            });
        }

        @Override
        public Command getWelcomeMessage() {
            return new NullCommand();
        }

        @Override
        public Message[] getMessages() {
            return null;
        }

        @Override
        public void postMessage(String content) {
        }
    }
}

