/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.PrivateChatManager;
import VASSAL.chat.PrivateChatter;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.ui.PlayerActionFactory;
import VASSAL.i18n.Resources;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;

public class PrivateMessageAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private Player p;
    private PrivateChatManager mgr;

    public PrivateMessageAction(Player p, ChatServerConnection client, PrivateChatManager mgr) {
        super(Resources.getString("Chat.private_msg"));
        this.p = p;
        this.mgr = mgr;
        this.setEnabled(p != null && client != null && mgr != null && !p.equals(client.getUserInfo()));
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        PrivateChatter chat = this.mgr.getChatterFor(this.p);
        if (chat != null) {
            Window f = (Window)chat.getTopLevelAncestor();
            f.setVisible(true);
            f.toFront();
        }
    }

    public static PlayerActionFactory factory(final ChatServerConnection client, final PrivateChatManager chatMgr) {
        return new PlayerActionFactory(){

            @Override
            public Action getAction(SimplePlayer p, JTree tree) {
                return new PrivateMessageAction(p, client, chatMgr);
            }
        };
    }
}

