/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.build.GameModule;
import VASSAL.chat.ChatServerConnection;
import VASSAL.chat.LockableChatServerConnection;
import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.SimplePlayer;
import VASSAL.chat.SynchCommand;
import VASSAL.chat.ui.PlayerActionFactory;
import VASSAL.i18n.Resources;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;

public class SynchAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final long TOO_SOON = 15000L;
    private static Room lastRoom;
    private static long lastSync;
    private Player p;
    private ChatServerConnection client;
    private Room targetRoom;

    public SynchAction(Player p, ChatServerConnection client) {
        super(Resources.getString("Chat.synchronize"));
        this.p = p;
        this.client = client;
        this.targetRoom = null;
        for (Room room : client.getAvailableRooms()) {
            if (!room.getPlayerList().contains(p)) continue;
            this.targetRoom = room;
        }
        long now = System.currentTimeMillis();
        this.setEnabled(p != null && GameModule.getGameModule() != null && !p.equals(client.getUserInfo()) && client.getRoom() != null && client.getRoom().equals(this.targetRoom) && (!this.targetRoom.equals(lastRoom) || now - lastSync > 15000L));
    }

    public static void clearSynchRoom() {
        lastRoom = null;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.isEnabled()) {
            long now = System.currentTimeMillis();
            if (!this.targetRoom.equals(lastRoom) || now - lastSync > 15000L) {
                GameModule.getGameModule().getGameState().setup(false);
                this.client.sendTo(this.p, new SynchCommand(this.client.getUserInfo(), this.client));
                lastSync = now;
            }
            lastRoom = this.targetRoom;
        }
    }

    public static PlayerActionFactory factory(final ChatServerConnection client) {
        return new PlayerActionFactory(){

            @Override
            public Action getAction(SimplePlayer p, JTree tree) {
                Room r = client.getRoom();
                if (client instanceof LockableChatServerConnection && ((LockableChatServerConnection)client).isDefaultRoom(r)) {
                    return null;
                }
                return new SynchAction(p, client);
            }
        };
    }

    static {
        lastSync = System.currentTimeMillis();
    }
}

